/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.davs;

import br.intelidata.commons.modulo.pvdav.regranegocio.DavItemRN;
import br.intelidata.uniplusweb.core.coreinterfaces.ValidationSaldoEstoqueInterface;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="dav-estoque-saldo")
public class DavValidationSaldo
implements ValidationSaldoEstoqueInterface {
    public BigDecimal getQuantidadeVendida(Long id, Long idItemAtual, Long idProduto, List<Long> idsLotes, String valor, boolean kit, List<Long> idsItensIgnorados) {
        if (!NumberUtil.longNullOuZero((Long)id)) {
            if (kit && !NumberUtil.longNullOuZero((Long)idItemAtual)) {
                idItemAtual = DavItemRN.getInstance().buscarIdItemKitFilhoWeb(id, idItemAtual, idProduto);
            }
            int variacao = StringUtil.stringNullOrEmpty((String)valor) ? Integer.parseInt(valor) : 0;
            Long[] idsDesconsiderados = null;
            if (!ListMapUtil.listNullOrEmpty(idsItensIgnorados)) {
                if (idItemAtual != null) {
                    idsItensIgnorados.add(idItemAtual);
                }
                idsDesconsiderados = idsItensIgnorados.toArray(new Long[0]);
            } else if (idItemAtual != null) {
                idsDesconsiderados = new Long[]{idItemAtual};
            }
            return DavItemRN.getInstance().getQuantidadeProdutoPorIdDav(idProduto, Integer.valueOf(variacao), idsLotes, idsDesconsiderados, new Long[]{id});
        }
        return BigDecimal.ZERO;
    }
}

