/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.declaracaoexportacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.fiscal.DeclaracaoExportacao;
import br.intelidata.commons.domain.pojo.fiscal.DeclaracaoExportacaoNotaItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.DeclaracaoExportacaoNotaItemRN;
import br.intelidata.commons.domain.regranegocio.DeclaracaoExportacaoNotaRN;
import br.intelidata.commons.domain.regranegocio.DeclaracaoExportacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/declaracoes-exportacao"})
@SubMenuMapping(MENU="SubMenuPainelContadorParametrosAuxiliarSpedFiscal", NOME="Declara\u00e7\u00f5es de Exporta\u00e7\u00e3o (1100)", ROTA="/speds/declaracoes-exportacao", PROGRAMA=1127)
public class DeclaracaoExportacaoCrudController
extends CrudController<DeclaracaoExportacao, DeclaracaoExportacaoRN> {
    public DeclaracaoExportacaoCrudController() {
        super((AbstractRegraNegocio)DeclaracaoExportacaoRN.getInstance(), DeclaracaoExportacao::new, true, true);
    }

    protected GridBuilder<DeclaracaoExportacaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("dataConclusaoExportacao", "Conclus\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipoDocumento", "Documento", 0, true));
        colunas.add(new ColunaSQL("numeroDeclaracao", "Declara\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("dataDeclaracao", "Data", 0, true));
        GridBuilder grid = new GridBuilder(DeclaracaoExportacaoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        return grid;
    }

    protected void beforeCreate(DeclaracaoExportacao declaracaoExportacao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        declaracaoExportacao.setIdFilial(SessaoUtil.getSessao().getIdFilial());
    }

    protected void beforeRead(DeclaracaoExportacao declaracaoExportacao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        declaracaoExportacao.setNotas(DeclaracaoExportacaoNotaRN.getInstance().buscarListaPorDeclaracao(declaracaoExportacao.getId()));
    }

    @RequestMapping(value={"/buscar-itens-nota"})
    @DBAutoCommit
    public List<DeclaracaoExportacaoNotaItem> buscarItensNota(@RequestParam Long idNota) {
        return DeclaracaoExportacaoNotaItemRN.getInstance().buscarListaPorNotaFiscal(idNota);
    }

    protected String getCacheId() {
        return "declaracoes-exportacao".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

