/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.desmontagem;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.desmontagem.Desmontagem;
import br.intelidata.commons.domain.pojo.desmontagem.DesmontagemItem;
import br.intelidata.commons.domain.pojo.desmontagem.DesmontagemOrigem;
import br.intelidata.commons.domain.pojo.desmontagem.StatusDesmontagem;
import br.intelidata.commons.domain.pojo.enuns.estoque.TipoConfiguracaoEstoqueNegativo;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.pojo.producao.FichaTecnicaDesagregacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.DesmontagemItemRN;
import br.intelidata.commons.domain.regranegocio.DesmontagemRN;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoCommonRN;
import br.intelidata.commons.modulo.estoque.regranegocio.EstoqueNegativoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.producao.regranegocio.FichaTecnicaDesagregacaoRN;
import br.intelidata.commons.modulo.produto.regranegocio.LoteRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.desmontagem.DesmontagemWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/desmontagens"})
@SubMenuMapping(MENU="SubMenuEstoqueGeral", NOME="Desmontagens de produtos", ICONE="icon-grade-produto", ROTA="/estoques/desmontagens", PROGRAMA=1415)
public class DesmontagemCrudController
extends CrudController<Desmontagem, DesmontagemRN> {
    public DesmontagemCrudController() {
        super((AbstractRegraNegocio)DesmontagemRN.getInstance(), Desmontagem::new, true, true);
    }

    protected GridBuilder<?> getGridBuilder() {
        boolean possuiFiliais = FilialCommonRN.getInstance().getFiliais().size() > 1;
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("status", "statusfiltro", "C\u00f3digo do status", 0, false, new String[0]));
        colunas.add(new ColunaSQL("data", "datafiltro", "Data", 0, false, new String[0]));
        colunas.add(new ColunaSQL("idfilial", "idfilial", 0, false));
        colunas.add(new ColunaSQL("idproduto", "idProduto", "ID produto", 0, false, new String[0]));
        if (possuiFiliais) {
            colunas.add(new ColunaSQL("codigo", "codigoFilial", "Filial", 100, true, new String[]{"fk_desmontagem_filial"}));
        }
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("data", "Data", 120, true));
        colunas.add(new ColunaSQL("codigo", "codigoProduto", "Produto", 150, true, new String[]{"fk_desmontagem_prod"}));
        colunas.add(new ColunaSQL("nome", "nomeProduto", "Descri\u00e7\u00e3o", 0, true, new String[]{"fk_desmontagem_prod"}));
        colunas.add(new ColunaSQL("quantidade", "Quantidade", 150, true));
        colunas.add(new ColunaSQL("status", "Status", 120, true));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(DesmontagemRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("data"));
        grid.addReferenciaDefault(new Referencia("codigo"));
        grid.addOrdemDefault(new Ordem("data", true));
        grid.addOrdemDefault(new Ordem("codigo", true));
        return grid;
    }

    @RequestMapping(value={"/preco-custo"})
    @DBAutoCommit
    public BigDecimal buscarPrecoCusto(@RequestParam Long idProduto) {
        return DesmontagemItemRN.getInstance().getCustoProduto(SessaoUtil.getSessao(), idProduto);
    }

    protected void beforeRead(Desmontagem desmontagem, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        desmontagem.setItens(DesmontagemItemRN.getInstance().buscarListaItensPorDesmontagem(desmontagem.getId(), true));
        BigDecimal custo = DesmontagemItemRN.getInstance().getCustoProduto(SessaoUtil.getSessao(), desmontagem.getIdProduto());
        if (desmontagem.getPrecoUnitario().compareTo(custo) != 0) {
            int casasDecimais = (Integer)ProdutoCommonRN.getInstance().buscarValorPorID(desmontagem.getIdProduto(), "casasdecimaisprecocusto");
            this.notificationService.notifyUserNow(NotificationType.SIMPLE_NOTIFICATION, (Object)("O custo do produto de origem foi alterado de " + Util.formataNumero((BigDecimal)desmontagem.getPrecoUnitario().setScale(casasDecimais, RoundingMode.HALF_EVEN), (int)casasDecimais) + " para " + Util.formataNumero((BigDecimal)custo.setScale(casasDecimais, RoundingMode.HALF_EVEN), (int)casasDecimais) + "." + Util.lineSeparator + "Os custos de destino ser\u00e3o recalculados!"));
            DesmontagemItemRN.getInstance().atualizaCustoItensDaDesmontagem(desmontagem.getItens(), desmontagem.getPrecoUnitario(), custo, desmontagem.getQuantidade());
            desmontagem.setPrecoUnitario(custo);
            desmontagem.setValorTotal(desmontagem.getQuantidade().multiply(custo).setScale(2, RoundingMode.HALF_EVEN));
        }
    }

    @PostMapping(value={"/atualizar-quantidade-itens"})
    @DBAutoCommit
    public List<DesmontagemItem> atualizarQuantidadeItens(@RequestBody DesmontagemWrapper wrapper) {
        List itens;
        if (Util.longNullOuZero((Long)wrapper.getIdProduto())) {
            return new ArrayList<DesmontagemItem>();
        }
        if (!ListMapUtil.listNullOrEmpty((List)wrapper.getItensDesmontagem()) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)wrapper.getQuantidadeAnterior()) && Objects.equals(wrapper.getIdProdutoAnterior(), wrapper.getIdProduto())) {
            DesmontagemItemRN.getInstance().atualizaQuantidadeItensDaDesmontagem(wrapper.getItensDesmontagem(), wrapper.getQuantidadeAnterior(), wrapper.getQuantidadeNova(), wrapper.getPrecoCusto());
            itens = wrapper.getItensDesmontagem();
        } else {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(wrapper.getIdProduto());
            List itensFicha = FichaTecnicaDesagregacaoRN.getInstance().buscarListaPorIdProdutoComEstrutura(wrapper.getIdProduto(), Integer.valueOf(0));
            itens = DesmontagemItemRN.getInstance().carregaItensParaDesmontagem(produto.getTipoFichaTecnicaDesagregacao(), itensFicha, wrapper.getQuantidadeNova(), wrapper.getPrecoCusto());
        }
        return itens;
    }

    @PostMapping(value={"/totalizar-itens"})
    @DBAutoCommit
    public Map<String, Object> totalizarDesmontagem(@RequestBody DesmontagemWrapper wrapper) {
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        BigDecimal total = BigDecimal.ZERO;
        Map<Long, BigDecimal> mapQuantidadePorUN = null;
        if (!Util.listNullOrEmpty((List)wrapper.getItensDesmontagem())) {
            total = wrapper.getItensDesmontagem().stream().map(DesmontagemItem::getValorTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
            mapQuantidadePorUN = wrapper.getItensDesmontagem().stream().collect(Collectors.groupingBy(DesmontagemItem::getIdUnidadeMedida, Collectors.mapping(DesmontagemItem::getQuantidade, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        }
        retorno.put("total", total);
        StringBuilder sbQuantidadePorUnidade = new StringBuilder();
        if (!Util.mapNullOrEmpty(mapQuantidadePorUN)) {
            for (Map.Entry entry : mapQuantidadePorUN.entrySet()) {
                Unidademedida unidademedida = CacheSistema.getInstance().getUnidadeMedida((Long)entry.getKey());
                if (sbQuantidadePorUnidade.length() > 0) {
                    sbQuantidadePorUnidade.append(", ");
                }
                sbQuantidadePorUnidade.append(Util.formataNumero((BigDecimal)((BigDecimal)entry.getValue()), (String)Util.getMascaraQuantidade((int)(unidademedida != null ? unidademedida.getCasasdecimais() : 3))));
                sbQuantidadePorUnidade.append(" ");
                sbQuantidadePorUnidade.append(unidademedida != null ? unidademedida.getCodigo() : "##");
            }
        }
        retorno.put("resumo", "Resumo: " + sbQuantidadePorUnidade);
        return retorno;
    }

    @RequestMapping(value={"/gerar-notafiscal"})
    @DBTransaction
    public String gerarNotasFiscais(@RequestParam Long idDesmontagem) throws UnicoMensagemUsuarioException {
        Desmontagem desmontagem = (Desmontagem)DesmontagemRN.getInstance().buscarPorId(idDesmontagem);
        if (desmontagem == null) {
            throw new UnicoMensagemUsuarioException("WNTF9385", "Desmontagem n\u00e3o encontrada!");
        }
        if (StatusDesmontagem.NF_GERADA.equals((Object)desmontagem.getStatus())) {
            throw new UnicoMensagemUsuarioException("WNTF9386", "As notas fiscais dessa desmontagem j\u00e1 foram geradas!");
        }
        List notasGeradas = NotaFiscalRN.getInstance().gerarNotasFiscaisDesmontagem(SessaoUtil.getSessao(), Collections.singletonList(desmontagem));
        return "Notas fiscais geradas: " + notasGeradas.stream().map(NotaFiscal::getNumeroNotaFiscal).collect(Collectors.joining(", "));
    }

    @PostMapping(value={"/recalcular-itens"})
    @DBAutoCommit
    public List<DesmontagemItem> recalcularItens(@RequestBody DesmontagemWrapper wrapper) {
        if (!DesmontagemItemRN.getInstance().isUtilizandoGrauCusto(wrapper.getItensDesmontagem())) {
            DesmontagemItemRN.getInstance().atualizaTotalItensDesmontagem(wrapper.getItensDesmontagem(), wrapper.getQuantidadeNova(), wrapper.getPrecoCusto());
        } else if (!wrapper.isUtilizaGrauAntesInclusao()) {
            DesmontagemItemRN.getInstance().atualizaCustoItensDaDesmontagemPeloGrau(wrapper.getItensDesmontagem(), wrapper.getPrecoCusto());
        }
        return wrapper.getItensDesmontagem();
    }

    protected void beforeSave(Desmontagem desmontagem, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)desmontagem.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("COM279984", "Produto principal n\u00e3o informado! Verifique.");
        }
        if (ListMapUtil.listNullOrEmpty((List)desmontagem.getItens())) {
            throw new UnicoMensagemUsuarioException("WPRO225", "N\u00e3o foram informados os novos itens gerados atrav\u00e9s da desmontagem! Verifique.");
        }
        Desmontagem desmontagemOriginal = (Desmontagem)((DesmontagemRN)this.rn).buscarPorId(desmontagem.getId());
        if (desmontagemOriginal != null) {
            desmontagem.setListaOrigens(desmontagemOriginal.getListaOrigens());
        }
        Sessao sessao = SessaoUtil.getSessao();
        TipoConfiguracaoEstoqueNegativo tipoConfEstoqueNegativo = (TipoConfiguracaoEstoqueNegativo)PropriedadeRN.getInstance().getPropriedadeEnum(sessao.getFilial(), 75);
        if (!TipoConfiguracaoEstoqueNegativo.PERMITIR.equals((Object)tipoConfEstoqueNegativo)) {
            BigDecimal quantidadeOriginal = BigDecimal.ZERO;
            if (desmontagemOriginal != null && desmontagem.getId() > 0L) {
                quantidadeOriginal = desmontagemOriginal.getQuantidade();
            }
            BigDecimal saldoEstoque = ProdutoRN.getInstance().getSaldoEstoqueAtualOuPrevisto(false, sessao, sessao.getFilial().getId(), null, desmontagem.getIdProduto(), 0, null, null, null).add(quantidadeOriginal);
            if (desmontagem.getQuantidade().compareTo(saldoEstoque) > 0) {
                if (TipoConfiguracaoEstoqueNegativo.INFORMAR.equals((Object)tipoConfEstoqueNegativo)) {
                    this.notificationService.notifyUserNow(NotificationType.SIMPLE_NOTIFICATION, (Object)"Saldo insuficiente para a desmontagem!");
                } else {
                    throw new UnicoMensagemUsuarioException("WEST92", "Saldo insuficiente para a desmontagem!");
                }
            }
        }
    }

    protected void afterCreate(Desmontagem desmontagem, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.listNullOrEmpty((List)desmontagem.getListaOrigens())) {
            for (DesmontagemOrigem origem : desmontagem.getListaOrigens()) {
                NotaFiscalItem notaFiscalItem;
                if (origem.getModelo() == null || NumberUtil.longNullOuZero((Long)origem.getIdItemOrigem()) || (notaFiscalItem = (NotaFiscalItem)NotaFiscalItemRN.getInstance().buscarPorId(origem.getIdItemOrigem())) == null) continue;
                DesmontagemRN.getInstance().atualizaStatusDesmontagemNotaFiscalItem(SessaoUtil.getSessao(), notaFiscalItem, (String)NotaFiscalRN.getInstance().buscarValorPorID(notaFiscalItem.getIdnotafiscal(), "serie"));
            }
        }
    }

    @PostMapping(value={"/alterar-produto-mestre"})
    @DBAutoCommit
    public Desmontagem alterarProdutoMestre(@RequestBody Desmontagem desmontagem, @RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
        DesmontagemRN.getInstance().alterarProdutoMestreDesmontagem(SessaoUtil.getSessao(), desmontagem, produto);
        return desmontagem;
    }

    @PostMapping(value={"/alterar-produto-mestre-item"})
    @DBAutoCommit
    public Desmontagem alterarProdutoMestreItem(@RequestBody DesmontagemWrapper wrapper) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(wrapper.getIdProduto());
        DesmontagemRN.getInstance().alterarProdutoMestreItem(SessaoUtil.getSessao(), wrapper.getDesmontagens(), wrapper.getDesmontagem(), wrapper.getItem(), produto);
        return wrapper.getDesmontagem();
    }

    @PostMapping(value={"/alterar-produto-mestre-origem"})
    @DBAutoCommit
    public Desmontagem alterarProdutoMestreOrigem(@RequestBody DesmontagemWrapper wrapper) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(wrapper.getIdProduto());
        DesmontagemRN.getInstance().alterarProdutoMestreOrigem(SessaoUtil.getSessao(), wrapper.getDesmontagens(), wrapper.getDesmontagem(), wrapper.getOrigem(), produto);
        return wrapper.getDesmontagem();
    }

    @PostMapping(value={"/excluir-origem"})
    @DBAutoCommit
    public Desmontagem excluirOrigem(@RequestBody DesmontagemWrapper wrapper) {
        DesmontagemRN.getInstance().atualizaItensDesmontagem(wrapper.getDesmontagem());
        return wrapper.getDesmontagem();
    }

    @PostMapping(value={"/excluir-item"})
    @DBAutoCommit
    public Desmontagem excluirItem(@RequestBody DesmontagemWrapper wrapper) {
        DesmontagemRN.getInstance().atualizaOrigensDesmontagem(wrapper.getDesmontagem());
        return wrapper.getDesmontagem();
    }

    @PostMapping(value={"/atualizar-status"})
    @DBAutoCommit
    public Desmontagem atualizaStatusGeracaoDesmontagem(@RequestBody DesmontagemWrapper wrapper) {
        DesmontagemRN.getInstance().atualizaStatusGeracaoDesmontagem(SessaoUtil.getSessao(), wrapper.getDesmontagem());
        return wrapper.getDesmontagem();
    }

    @PostMapping(value={"/gravar-desmontagens"})
    @DBTransaction
    public void gravarDesmonatgens(@RequestBody DesmontagemWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        List desmontagens = wrapper.getDesmontagens();
        if (desmontagens.stream().anyMatch(desmontagem -> Util.bigDecimalNullOrZero((BigDecimal)desmontagem.getPrecoUnitario()))) {
            if (desmontagens.size() == 1) {
                throw new UnicoMensagemUsuarioException("WEST124", "O produto " + ((Desmontagem)desmontagens.get(0)).getNomeProduto() + " n\u00e3o possui custo, e sua desmontagem n\u00e3o ser\u00e1 gravada! Verifique.");
            }
            this.notificationService.notifyUserNow(NotificationType.SIMPLE_NOTIFICATION, (Object)"As desmontagens onde o produto principal n\u00e3o possui custo ser\u00e3o ignoradas! Verifique.");
        }
        if (LoteRN.getInstance().isSistemaControlaLote()) {
            for (Desmontagem desmontagem2 : desmontagens) {
                if (!DesmontagemRN.getInstance().isUtilizaLote(sessao, desmontagem2.getIdProduto())) continue;
                if (Util.listNullOrEmpty((List)desmontagem2.getLotes())) {
                    throw new UnicoMensagemUsuarioException("WEST119", "Desmontagem " + desmontagem2.getCodigo() + " n\u00e3o possui lotes informados! Verifique.");
                }
                if (!DesmontagemRN.getInstance().isQuantidadeLoteInvalida(desmontagem2.getQuantidade(), desmontagem2.getLotes())) continue;
                throw new UnicoMensagemUsuarioException("WEST120", "A quantidade da desmontagem " + desmontagem2.getCodigo() + " n\u00e3o confere com os lotes informados! Verifique.");
            }
        }
        EstoqueNegativoRN.getInstance().validarEstoqueDesmontagens(sessao, desmontagens);
        DesmontagemRN.getInstance().gravarDesmontagensGeradas(sessao, desmontagens, wrapper.isGerarNotas());
    }

    protected String getCacheId() {
        return "/api/desmontagens".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    @RequestMapping(value={"/validar-desmontagem-rapida"})
    @DBAutoCommit
    public Long validarDesmontagemRapida(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        return DesmontagemRN.getInstance().validaProdutoEFichaTecnicaDesmontagemRapida(idProduto);
    }

    @RequestMapping(value={"/validar-inclusao-item-desmontagem"})
    @DBAutoCommit
    public void validarInclusaoItemDesmontagem(@RequestParam Long idProduto, boolean desmontagemRapida) throws UnicoMensagemUsuarioException {
        List itensFicha = FichaTecnicaDesagregacaoRN.getInstance().buscarListaPorIdProdutoComEstrutura(idProduto, Integer.valueOf(0));
        for (FichaTecnicaDesagregacao fichaTecnicaDesagregacao : itensFicha) {
            DesmontagemRN.getInstance().validaTiposProduto(fichaTecnicaDesagregacao.getIdProduto(), desmontagemRapida);
        }
        DesmontagemRN.getInstance().validaTiposProduto(idProduto, desmontagemRapida);
    }
}

