/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.desmontagem.compras;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.RastreabilidadeDocumento;
import br.intelidata.commons.domain.pojo.desmontagem.Desmontagem;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoReclassificacao;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.DesmontagemRN;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemDesmontagemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/desmontagens-compras"})
public class DesmontagemComprasCrudController
extends CrudController<NotaFiscalItem, NotaFiscalItemRN> {
    public DesmontagemComprasCrudController() {
        super((AbstractRegraNegocio)NotaFiscalItemRN.getInstance(), NotaFiscalItem::new, true, true, false);
    }

    protected GridBuilder<?> getGridBuilder() {
        boolean possuiFiliais = FilialCommonRN.getInstance().getFiliais().size() > 1;
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", "Id do item da nota", 0, false, new String[0]));
        colunas.add(new ColunaSQL("idserie", "idserie", "Id Serie", 0, false, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("casasdecimaisprecocusto", "decimaiscusto", "decimais do custo", 0, false, new String[]{"fk_notafiscalitem_produto"}));
        colunas.add(new ColunaSQL("casasdecimais", "decimaisquantidade", "decimais da quantidade", 0, false, new String[]{"fk_notafiscalitem_produto", "fk_produto_unidademedida"}));
        if (possuiFiliais) {
            colunas.add(new ColunaSQL("codigo", "codigofilial", "Filial", 80, true, new String[]{"fk_notafiscalitem_notafiscal", "fk_notafiscal_filial"}));
            colunas.add(new ColunaSQL("idfilial", "idfilial", "idfilial", 0, false, new String[]{"fk_notafiscalitem_notafiscal"}));
        }
        colunas.add(new ColunaSQL("numeronotafiscal", "numeronotafiscal", "Nota fiscal", 120, true, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("serie", "modelo", "Modelo", 80, true, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("emissao", "emissao", "Emiss\u00e3o", 150, true, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("razaosocial", "fornecedor", "Fornecedor", 0, true, new String[]{"fk_notafiscalitem_notafiscal"}));
        colunas.add(new ColunaSQL("codigo", "codigoproduto", "Produto", 0, true, new String[]{"fk_notafiscalitem_produto"}));
        colunas.add(new ColunaSQL("nome", "nomeproduto", "Descri\u00e7\u00e3o", 0, true, new String[]{"fk_notafiscalitem_produto"}));
        colunas.add(new ColunaSQL("unidade", "unidade", "UN", 80, true, new String[0]));
        colunas.add(new ColunaSQL("quantidade", "quantidade", "Quantidade", 150, true, new String[0]));
        colunas.add(new ColunaSQL("precounitario", "precounitario", "Pre\u00e7o unit\u00e1rio", 150, true, new String[0]));
        colunas.add(new ColunaSQL("total", "valortotalitem", "Total", 150, true, new String[0]));
        colunas.add(new ColunaSQL("statusdesmontagem", "statusdesmontagem", "Status", 180, true, new String[0]));
        GridBuilder grid = new GridBuilder(NotaFiscalItemRN.getInstance().getTabela(), colunas, "desmontagem-compras");
        grid.addReferenciaDefault(new Referencia("tipodocumento", "tipodocumento", new String[]{"fk_notafiscalitem_notafiscal"}));
        grid.addCodicaoDefault(new Condicao("tipodocumento", Operador.IGUAL, TipoNotaFiscal.ENTRADA.getId()));
        grid.addOrdemDefault(new Ordem("emissao", true));
        grid.addOrdemDefault(new Ordem("numeronotafiscal", true));
        grid.addReferenciaDefault(new Referencia("tipoProdutoReclassificacao", "tipoProdutoReclassificacao", new String[]{"fk_notafiscalitem_produto"}));
        grid.addCodicaoDefault(new Condicao("tipoProdutoReclassificacao", Operador.IGUAL, TipoProdutoReclassificacao.MESTRE.getId().intValue()));
        return grid;
    }

    @RequestMapping(value={"/gerar-desmontagem"})
    @DBTransaction
    public List<Desmontagem> incluirDesmontagem(@RequestParam List<Long> idsNotaFiscalItem, @RequestParam(required=false, defaultValue="false") boolean gerarNotas) throws UnicoMensagemUsuarioException {
        List itens;
        if (!Util.listNullOrEmpty(idsNotaFiscalItem)) {
            boolean preVisualizar = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 1005);
            itens = NotaFiscalItemRN.getInstance().buscaItensPorIds((Long[])Util.lista2Array(Long.class, idsNotaFiscalItem));
            if (preVisualizar) {
                return DesmontagemRN.getInstance().gerarDesmontagensItens(SessaoUtil.getSessao(), itens, false, false);
            }
        } else {
            throw new UnicoMensagemUsuarioException("COM279986", "Selecione um ou mais itens para gerar a desmontagem.");
        }
        DesmontagemRN.getInstance().gerarDesmontagensItens(SessaoUtil.getSessao(), itens, true, gerarNotas);
        return null;
    }

    @RequestMapping(value={"/buscar-rastreabilidade"})
    @DBAutoCommit
    public List<RastreabilidadeDocumento> buscarRastreabilidade(@RequestParam Long idOrigem) {
        NotaFiscalItem item = (NotaFiscalItem)NotaFiscalItemRN.getInstance().buscarPorId(idOrigem);
        String modelo = (String)NotaFiscalRN.getInstance().buscarValorPorID(item.getIdnotafiscal(), "serie");
        return NotaFiscalItemDesmontagemRN.getInstance().buscarListaRastreabilidade((ModeloNotaFiscal)EnumUtils.getPorId(ModeloNotaFiscal.class, (Object)modelo), idOrigem);
    }

    protected String getCacheId() {
        return "/api/desmontagens-compras".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

