/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.execoes.UnicoPerguntaUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.Caso;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Constante;
import br.intelidata.commons.core.sql.usql.Escolha;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Extenso;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractDavItem;
import br.intelidata.commons.domain.pojo.AbstractFaturamento;
import br.intelidata.commons.domain.pojo.AbstractFaturamentoItem;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.CfopItem;
import br.intelidata.commons.domain.pojo.Cidade;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.EntidadeDesconto;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPrecoProduto;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.NaturezaOperacaoDTOWeb;
import br.intelidata.commons.domain.pojo.ParametrosNotaFiscalInterface;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.PedidoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.ComportamentoClienteAtrasoVendas;
import br.intelidata.commons.domain.pojo.enuns.CstPisCofins;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.ParceiroIntegracao;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.enuns.TransacaoFinanceiraMeioPagamento;
import br.intelidata.commons.domain.pojo.enuns.nfe.TipoContribuinte;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.TipoCalculoImposto;
import br.intelidata.commons.domain.pojo.expedicao.DocumentoConferidoInterface;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.pojo.generico.VariavelTextoGenerico;
import br.intelidata.commons.domain.pojo.notafiscal.AcaoComponenteItemTributavel;
import br.intelidata.commons.domain.pojo.pvdav.DavItem;
import br.intelidata.commons.domain.pojo.vendas.ConferenciaDocumentoItemDivergencia;
import br.intelidata.commons.domain.regranegocio.AbstractFaturamentoItemRN;
import br.intelidata.commons.domain.regranegocio.AbstractFaturamentoRN;
import br.intelidata.commons.domain.regranegocio.AtacarejoWeb;
import br.intelidata.commons.domain.regranegocio.CondicaoPagamentoCommonRN;
import br.intelidata.commons.domain.regranegocio.DavItemBaixaCommonRN;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.domain.wrapper.ImpostoWrapper;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.correios.CodigoFormatoObjetoInformado;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.correios.CodigoServicoCorreios;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.correios.PrePostagemEtiquetaTransporte;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.correios.TipoRotuloApiCorreios;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.correios.prepostagem.ResponsePrePostagemApiCorreios;
import br.intelidata.commons.modulo.c3po.ecommerce.regranegocio.correios.ProcessarApiCorreios;
import br.intelidata.commons.modulo.cadastros.regranegocio.CidadeRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDescontoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCodigoCargaDaf;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelDataCargaDaf;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelDocumentoFiscalDAV;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelNomePautaUtilizadaVenda;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelStatusCargaDaf;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelUsuarioCargaDaf;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVenda;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVendaFaturamento;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavItemRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoItemDivergenciaRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.MultipartUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoController;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoAlterarEntidadeDescontoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoTratamentoImposto;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.FaturamentoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.ImpostoFaturamentoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento.MesclagemFaturamentoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ImpostoCalculadoWrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public abstract class FaturamentoCrudController<E extends AbstractFaturamento, RN extends AbstractFaturamentoRN, I extends AbstractFaturamentoItem, IK extends ItemKit<IK>, IRN extends AbstractFaturamentoItemRN>
extends CalculoImpostoController<E, I, IK, RN> {
    private final IRN itemRN;
    private final AtacarejoService atacarejoService;
    private final ModuloService moduloService;
    private final TipoDocumentoDAV tipoDocumentoDAV;
    protected final FuncionalidadeService funcionalidadeService;
    protected CalculoImpostoService<I> calculoImpostoService;
    private final FaturamentoTratamentoImposto tratamentoImposto;

    public FaturamentoCrudController(RN rn, IRN itemRN, CalculoImpostoService<I> calculoImpostoService, FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService, Supplier<E> faturamentoSupplier, TipoDocumentoDAV tipoDocumentoDAV, FaturamentoTratamentoImposto tratamentoImposto) {
        super(rn, calculoImpostoService, faturamentoSupplier);
        this.itemRN = itemRN;
        this.calculoImpostoService = calculoImpostoService;
        this.funcionalidadeService = funcionalidadeService;
        this.atacarejoService = atacarejoService;
        this.moduloService = moduloService;
        this.tipoDocumentoDAV = tipoDocumentoDAV;
        this.tratamentoImposto = tratamentoImposto;
    }

    @DBAutoCommit
    public ImpostoCalculadoWrapper<I> atualizarComponentes(@RequestBody ImpostoWrapper<I> impostoWrapper) throws UnicoMensagemUsuarioException {
        return super.atualizarComponentes(impostoWrapper);
    }

    @DBAutoCommit
    public ImpostoCalculadoWrapper<I> calcularImpostos(@RequestBody ImpostoWrapper<I> impostoWrapper, @RequestParam(required=false) String crud, @RequestParam(required=false, defaultValue="true") boolean mapearAcoes) throws UnicoMensagemUsuarioException {
        impostoWrapper.setItens(this.separarItensKit(impostoWrapper.getItens()));
        ImpostoCalculadoWrapper impostoCalculadoWrapper = super.calcularImpostos(impostoWrapper, crud, mapearAcoes);
        impostoWrapper.setItens(this.agruparItensKit(impostoWrapper.getItens()));
        return impostoCalculadoWrapper;
    }

    @DBAutoCommit
    public List<I> recalcularImpostosItens(@RequestBody ImpostoWrapper<I> impostoWrapper) throws UnicoMensagemUsuarioException {
        impostoWrapper.setItens(this.separarItensKit(impostoWrapper.getItens()));
        return this.agruparItensKit(super.recalcularImpostosItens(impostoWrapper));
    }

    @RequestMapping(value={"/atualizar-dados-impressao"}, method={RequestMethod.POST})
    @DBTransaction
    public void atualizarDadosImpressao(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        AbstractFaturamento faturamento = (AbstractFaturamento)((AbstractFaturamentoRN)this.rn).buscarPorId(id);
        if (faturamento != null) {
            faturamento.setImpresso(true);
            faturamento.setDataHoraImpressao(DataHoraFactory.getDataHora());
            faturamento.setIgnoraValidacaoValorZerado(true);
            faturamento.setIgnoraValidacaoEstoque(true);
            ((AbstractFaturamentoRN)this.rn).alterar((AbstractPojo)faturamento, SessaoUtil.getSessao());
        }
    }

    @RequestMapping(value={"/buscar-assinatura"})
    @DBAutoCommit
    public E buscaAssinatura(@RequestParam Long idOrigem) throws UnicoMensagemUsuarioException {
        AbstractFaturamento faturamento = (AbstractFaturamento)((AbstractFaturamentoRN)this.rn).buscarPorId(idOrigem);
        if (faturamento != null && faturamento.getAssinatura() != null) {
            MultipartFile file = MultipartUtil.montaMultiPartiPorBytes((byte[])faturamento.getAssinatura(), (String)"assinatura.png");
            String url = this.saveFile.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Venda, file, true);
            faturamento.setCaminhoAssinatura(url);
            return (E)faturamento;
        }
        throw new UnicoMensagemUsuarioException("WWW661", "Venda n\u00e3o tem assinatura");
    }

    @RequestMapping(value={"/gerar-parcelas"})
    @DBAutoCommit
    public List<PedidoDocumentoFinanceiro> gerarParcelas(@RequestParam Long idCondicaoPagamento, @RequestParam BigDecimal total, @RequestParam(required=false) boolean isSaida, @RequestParam Long idEntidade, @RequestParam Long idTipoDocumentoFinanceiro, @RequestParam(required=false) String dataPedido, @RequestParam String dataEmissao, @RequestParam(required=false, defaultValue="0") int diaFaturamentoContrato, @RequestParam(required=false) String dataVencimentoContrato, @RequestParam(required=false) BigDecimal valorIcmsSt) throws UnicoMensagemUsuarioException {
        total = total.setScale(2, 6);
        return PedidoDocumentoFinanceiroRN.getInstance().gerarParcelas(idCondicaoPagamento, total, isSaida, idEntidade, idTipoDocumentoFinanceiro, !StringUtil.stringNullOrEmpty((String)dataPedido) ? DataHoraFactory.string2LocalDate((String)dataPedido, (String)"dd/MM/yyyy") : null, DataHoraFactory.string2LocalDate((String)dataEmissao, (String)"dd/MM/yyyy"), diaFaturamentoContrato, !StringUtil.stringNullOrEmpty((String)dataVencimentoContrato) ? DataHoraFactory.string2LocalDate((String)dataVencimentoContrato, (String)"dd/MM/yyyy") : null, SessaoUtil.getSessao().getFilial(), valorIcmsSt);
    }

    @RequestMapping(value={"/itens"})
    @DBAutoCommit
    public List<I> buscarItens(@RequestParam Long id, @RequestParam(required=false, defaultValue="false") boolean duplicacao, @RequestParam(required=false, defaultValue="false") boolean conferencia) throws UnicoMensagemUsuarioException {
        AbstractFaturamento faturamento = (AbstractFaturamento)((AbstractFaturamentoRN)this.rn).buscarPorId(id);
        if (faturamento == null) {
            throw new UnicoMensagemUsuarioException("WWW180", "Faturamento n\u00e3o encontrado");
        }
        Sessao sessao = SessaoUtil.getSessao();
        List itens = this.itemRN.buscarListaPorIdFaturamento(id);
        itens.forEach(item -> {
            item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(sessao.getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null));
            Unidademedida unidademedida = CacheSistema.getInstance().getUnidadeMedida(item.getIdUnidadeMedida());
            item.setDecimaisQuantidade(unidademedida.getCasasdecimais().intValue());
            item.setQuantidade(item.getQuantidade().setScale(item.getDecimaisQuantidade(), RoundingMode.HALF_EVEN));
            item.setPreco(item.getPreco().setScale(ProdutoRN.getInstance().getCasasDecimais(item.getIdproduto()), RoundingMode.HALF_EVEN));
            if (duplicacao) {
                item.setId(Long.valueOf(new BigDecimal(item.getId()).negate().longValue()));
                item.setPodeAlterarExcluir(true);
            } else {
                item.setPodeAlterarExcluir(this.itemRN.isPodeAlterarExcluir(item));
            }
            item.setPrecoUltimaVendaProduto(DavItemRN.getInstance().getPrecoUltimaVendaNfPorCliente(faturamento.getIdCliente(), item.getIdProduto()));
            TipoRegistroProduto tipo = ProdutoRN.getInstance().getTipoRegistroProduto(item.getIdProduto());
            item.setTipo(tipo != null ? tipo.getId() : "");
            if (!NumberUtil.longNullOuZero((Long)item.getIdCfop())) {
                NaturezaOperacao naturezaOperacao = NaturezaOperacaoRN.getInstance().buscarPorId(item.getIdCfop());
                NaturezaOperacaoDTOWeb dto = new NaturezaOperacaoDTOWeb();
                BeanUtil.copiarValores((Object)naturezaOperacao, (Object)dto, (boolean)false, (boolean)true, null);
                item.setCfopItem(dto);
            }
            item.setSaldoItem(DavItemBaixaCommonRN.getInstance().buscaSaldoPorItemPedido(item));
            if (!NumberUtil.longNullOuZero((Long)item.getId()) && item.getId() > 0L) {
                item.setTotalFaturado(DavItemBaixaCommonRN.getInstance().buscaTotalFaturadoPorItemPedido(item.getId()).setScale(item.getDecimaisQuantidade(), RoundingMode.HALF_EVEN));
                item.setTotalCancelado(DavItemBaixaCommonRN.getInstance().buscaTotalCanceladoPorItemPedido(item.getId()).setScale(item.getDecimaisQuantidade(), RoundingMode.HALF_EVEN));
            }
            item.setDescricaoPauta(new ProdutoItemRN().descricaoPautaPreco(sessao, item.getPautaPreco()));
            item.getMapPrecoUnitarioInformadoPorPauta().put(item.getPautaPreco() == 0L ? -1L : item.getPautaPreco(), item.getPreco());
        });
        if (conferencia) {
            List lista = new ConferenciaDocumentoItemDivergenciaRN().conferir(new DocumentoConferidoInterface[]{faturamento});
            Map mapPorDav = lista.stream().filter(c -> c.getItemDav() != null).collect(Collectors.toMap(c -> c.getItemDav().getId(), Function.identity()));
            for (AbstractFaturamentoItem item2 : itens) {
                item2.setConferencia((ConferenciaDocumentoItemDivergencia)mapPorDav.get(item2.getId()));
            }
        }
        return KitRN.getInstance().agruparItensKit(itens);
    }

    @PostMapping(value={"/processar-status-conferencia"})
    @DBAutoCommit
    public I processarStatusConferencia(@RequestBody FaturamentoWrapper<I> wrapper) {
        wrapper.getItem().getConferencia().processarStatus(wrapper.getItens().stream().map(AbstractDavItem::getConferencia).filter(Objects::nonNull).collect(Collectors.toList()), wrapper.getItem().getQuantidade());
        return (I)wrapper.getItem();
    }

    @RequestMapping(value={"/buscar-preco-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoItemWeb<I> getPrecoProduto(@RequestBody FaturamentoWrapper<I> wrapper) throws UnicoMensagemUsuarioException {
        Promocao promocao;
        ProdutoPreco produtoPreco;
        Sessao sessao = SessaoUtil.getSessao();
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, wrapper.getItem().getIdProduto());
        Long pautaAtacarejo = null;
        if (!NumberUtil.longNullOuZero((Long)wrapper.getItem().getIdEmbalagem()) && wrapper.getItem().getIdEmbalagem() != -1L) {
            wrapper.getItem().setIdUnidadeMedida(((Embalagem)EmbalagemRN.getInstance().buscarPorId(wrapper.getItem().getIdEmbalagem())).getIdUnidadeMedida());
        }
        if (this.atacarejoService.isAtacarejoHabilitado(sessao, wrapper.getIdCliente())) {
            pautaAtacarejo = this.atacarejoService.buscaPautaAtacarejo(produto, wrapper.getQuantidadeProduto(), sessao);
        }
        if (pautaAtacarejo != null && pautaAtacarejo >= 0L) {
            produtoPreco = this.atacarejoService.getPrecoAtacarejo(pautaAtacarejo, produto, wrapper.getItem().getIdEmbalagem(), sessao);
        } else {
            Entidade cliente;
            Long idCategoriaCliente = null;
            if (!NumberUtil.longNullOuZero((Long)wrapper.getIdCliente()) && (cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(wrapper.getIdCliente())) != null) {
                idCategoriaCliente = cliente.getIdCategoriaCliente();
            }
            ConsultaPrecoProduto consultaPrecoProduto = new ConsultaPrecoProduto(sessao.getFilial(), wrapper.getItem().getIdproduto(), wrapper.getItem().getPautaPreco(), VariacaoRN.getInstance().stringToMap(wrapper.getItem().getVariacoes()), wrapper.getItem().getIdEmbalagem());
            TipoValorPreco tipoPreco = TipoValorPreco.PRECO;
            if (!NumberUtil.longNullOuZero((Long)wrapper.getIdParametro())) {
                tipoPreco = this.calculoImpostoService.getTipoValorPreco(wrapper.getIdParametro(), PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372));
            }
            consultaPrecoProduto.setTipoValorPreco(tipoPreco);
            consultaPrecoProduto.setIdCategoriaCliente(idCategoriaCliente);
            produtoPreco = ProdutoRN.getInstance().getPreco(consultaPrecoProduto);
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            Map map = FormacaoPrecoProdutoRN.getInstance().getPrecoMinimoVendaProdutoWeb(sessao.getIdFilial(), produto.getId());
            wrapper.getItem().setPrecoMinimoVenda((BigDecimal)map.get("precoMinimoVenda"));
            wrapper.getItem().setPrecoProdutoOriginal((BigDecimal)map.get("precoProdutoOriginal"));
        } else {
            wrapper.getItem().setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
            wrapper.getItem().setPrecoProdutoOriginal(produto.getPreco());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produtoPreco.getPrecoPromocao())) {
            wrapper.getItem().setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
            wrapper.getItem().setPreco(produtoPreco.getPrecoPromocao());
            wrapper.getItem().setIdPromocao(produtoPreco.getIdPromocao());
        } else {
            wrapper.getItem().setDescontoPromocao(BigDecimal.ZERO);
            wrapper.getItem().setPreco(produtoPreco.getPreco());
            wrapper.getItem().setIdPromocao(null);
        }
        wrapper.getItem().setPrecoOriginal(produtoPreco.getPreco());
        ProdutoItemWeb produtoItemWeb = new ProdutoItemWeb();
        produtoItemWeb.setProdutoPreco(produtoPreco);
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            ImpostoWrapper imposto = new ImpostoWrapper((ProdutoItem)wrapper.getItem(), wrapper.getTipoCalculo(), wrapper.getIdParametro(), wrapper.getIdCliente(), wrapper.isPossuiItens(), wrapper.getTransacao());
            imposto.setCalcularImposto(true);
            ImpostoCalculadoWrapper impostoCalculado = this.calculoImpostoService.calcularImpostos(imposto, true);
            produtoItemWeb.setItem((ItemWeb)impostoCalculado.getItem());
            produtoItemWeb.setAcoes(impostoCalculado.getAcoes());
        } else {
            wrapper.getItem().setTotal(wrapper.getItem().getPreco().multiply(wrapper.getItem().getQuantidade()).subtract(wrapper.getItem().getDesconto()).setScale(2, 5));
            produtoItemWeb.setItem((ItemWeb)wrapper.getItem());
        }
        if (!NumberUtil.longNullOuZero((Long)((AbstractFaturamentoItem)produtoItemWeb.getItem()).getIdPromocao()) && (promocao = PromocaoRN.getInstance().buscarPorId(((AbstractFaturamentoItem)produtoItemWeb.getItem()).getIdPromocao())) != null) {
            produtoItemWeb.setPromocao(promocao);
        }
        return produtoItemWeb;
    }

    @RequestMapping(value={"/calcular-preco-itens"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImpostoFaturamentoWrapper<I> calcularItensPorCondicaoPagamento(@RequestBody FaturamentoWrapper<I> wrapper) throws UnicoMensagemUsuarioException {
        ImpostoFaturamentoWrapper imposto;
        Sessao sessao = SessaoUtil.getSessao();
        boolean calcularImpostos = this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO);
        boolean pautaPrecoItem = this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_ITEM);
        for (AbstractFaturamentoItem item : wrapper.getItens()) {
            ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, item.getIdProduto());
            if (!pautaPrecoItem && !wrapper.isForcarPautaItem()) {
                item.setPautaPreco(wrapper.getPauta());
            }
            TipoValorPreco tipoPreco = TipoValorPreco.PRECO;
            if (calcularImpostos) {
                tipoPreco = this.calculoImpostoService.getTipoValorPreco(wrapper.getIdParametro(), PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372));
            }
            long pauta = wrapper.getPauta();
            if (wrapper.isForcarPautaItem()) {
                pauta = item.getPautaPreco();
            }
            ProdutoPreco produtoPreco = new ProdutoItemRN().atualizarPreco(sessao, wrapper.getItens(), produto, (ProdutoItem)item, tipoPreco, wrapper.getIdCondicaoPgmto(), Long.valueOf(pauta), true, true, false, false, (AtacarejoWeb)this.atacarejoService, wrapper.getIdCliente());
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                FormacaoPrecoProduto precoProduto = FormacaoPrecoProdutoRN.getInstance().buscarFormacaoPrecoPorProdutoFilial(item.getIdproduto(), sessao.getIdFilial());
                if (precoProduto != null) {
                    if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                        item.setPrecoMinimoVenda(precoProduto.getPrecoMinimoVenda());
                    }
                } else if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                    item.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
                }
            } else if (item.getPrecoMinimoVenda().compareTo(BigDecimal.ZERO) == 0 && NumberUtil.longNullOuZero((Long)item.getIdSupervisorVenda())) {
                item.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
            }
            if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getPercentualdesconto())) {
                BigDecimal bruto = item.getPrecoUnitario().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN);
                item.setDesconto(NumberUtil.valorDesconto((BigDecimal)bruto, (BigDecimal)item.getPercentualdesconto(), (int)2));
            }
            this.getRegraNegocioItem().calculaTotalItem(item);
            if (item.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
            GeradorKitVendaFaturamento geradorKitVendaFaturamento = new GeradorKitVendaFaturamento(this.itemRN);
            geradorKitVendaFaturamento.calcularRateioKit(SessaoUtil.getSessao(), (ItemKit)item, item.getFilhosKit(), wrapper.getIdCondicaoPgmto());
        }
        if (calcularImpostos) {
            if (wrapper.isRatearDescontoSubTotal()) {
                imposto = this.ratearDescontoSubTotal(wrapper);
            } else {
                ImpostoWrapper impostoWrapper = new ImpostoWrapper(wrapper.getIdCliente(), wrapper.getIdParametro(), wrapper.getItens());
                impostoWrapper.setEstado(wrapper.getEstado());
                imposto = new ImpostoFaturamentoWrapper(this.recalcularImpostosItens(impostoWrapper));
            }
        } else {
            imposto = new ImpostoFaturamentoWrapper(wrapper.getItens());
        }
        return imposto;
    }

    @RequestMapping(value={"/ratear-descontos-subtotal"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ImpostoFaturamentoWrapper<I> ratearDescontoSubTotal(@RequestBody FaturamentoWrapper<I> wrapper) throws UnicoMensagemUsuarioException {
        ImpostoFaturamentoWrapper imposto;
        List itens = this.separarItensKit(wrapper.getItens());
        boolean descontoInvalido = false;
        try {
            this.getRegraNegocioItem().ratearDescontoSubTotal(SessaoUtil.getSessao(), itens, wrapper.getDescontoSubTotal(), wrapper.getIdUsuario());
        }
        catch (UnicoMensagemUsuarioException e) {
            descontoInvalido = true;
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            ImpostoWrapper impostoWrapper = new ImpostoWrapper(wrapper.getIdCliente(), wrapper.getIdParametro(), itens);
            impostoWrapper.setEstado(wrapper.getEstado());
            imposto = new ImpostoFaturamentoWrapper(this.recalcularImpostosItens(impostoWrapper));
        } else {
            imposto = new ImpostoFaturamentoWrapper(this.agruparItensKit(itens));
        }
        imposto.setDescontoInvalido(descontoInvalido);
        return imposto;
    }

    @RequestMapping(value={"/calcular-rateios-frete-outras-despesas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<I> calcularRateiosValorFrete(@RequestBody FaturamentoWrapper<I> wrapper) throws UnicoMensagemUsuarioException {
        List itens = this.separarItensKit(wrapper.getItens());
        this.getRegraNegocioItem().calculaRateioValor(itens, "frete", wrapper.getValorFrete());
        this.getRegraNegocioItem().calculaRateioValor(itens, "outrasDespesas", wrapper.getValorOutrasDespesas());
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            ImpostoWrapper impostoWrapper = new ImpostoWrapper(wrapper.getIdCliente(), wrapper.getIdParametro(), itens);
            impostoWrapper.setEstado(wrapper.getEstado());
            return this.recalcularImpostosItens(impostoWrapper);
        }
        return KitRN.getInstance().agruparItensKit(itens);
    }

    @PostMapping(value={"/calcular-precos-atacarejos"})
    @DBAutoCommit
    public List<I> atualizaProdutosAtacarejo(@RequestBody FaturamentoWrapper<I> wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (this.atacarejoService.isAtacarejoHabilitado(sessao, wrapper.getIdCliente())) {
            if (wrapper.getProduto() == null) {
                ProdutoDTOWeb prod = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, wrapper.getIdProduto());
                wrapper.setProduto(prod);
            }
            List itens = wrapper.getItens().stream().map(it -> {
                if (Util.longNullOuZero((Long)it.getIdFamilia())) {
                    Long idFamilia = (Long)ProdutoRN.getInstance().buscarValorPorID(it.getIdProduto(), "idfamilia");
                    it.setIdFamilia(idFamilia);
                }
                return it;
            }).collect(Collectors.toList());
            this.atacarejoService.atualizaProdutosAtacarejo(sessao, wrapper.getProduto(), itens, wrapper.getIdCliente(), wrapper.getIdCondicaoPgmto(), item -> this.getRegraNegocioItem().calculaTotalItem((AbstractFaturamentoItem)item));
            GeradorKitVendaFaturamento geradorKitVendaFaturamento = new GeradorKitVendaFaturamento(this.itemRN);
            for (AbstractFaturamentoItem item2 : wrapper.getItens()) {
                if (item2.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
                geradorKitVendaFaturamento.calcularRateioKit(SessaoUtil.getSessao(), (ItemKit)item2, item2.getFilhosKit(), wrapper.getIdCondicaoPgmto());
            }
        }
        return wrapper.getItens();
    }

    @RequestMapping(value={"/itens-mesclagem"}, method={RequestMethod.POST})
    @DBAutoCommit
    public MesclagemFaturamentoWrapper<I> buscarDadosMesclagem(@RequestBody List<Long> idsDav) throws UnicoMensagemUsuarioException {
        ((AbstractFaturamentoRN)this.rn).verificaPodeMesclarDocumentos(SessaoUtil.getSessao(), idsDav);
        ArrayList<Long> idsVendedores = new ArrayList<Long>();
        ArrayList itens = new ArrayList();
        for (Long id : idsDav) {
            itens.addAll(this.getRegraNegocioItem().buscarListaPorIdFaturamento(id));
        }
        for (AbstractFaturamentoItem item : itens) {
            Long idVendedor;
            if (Util.stringNullOrEmpty((String)item.getCodigoProduto())) {
                item.setCodigoProduto((String)ProdutoRN.getInstance().buscarValorPorID(item.getIdproduto(), "codigo"));
            }
            if (item.getIddav() == null || idsVendedores.contains(idVendedor = (Long)PedidoRN.getInstance().buscarValorPorID(item.getIddav(), "idRepresentante"))) continue;
            idsVendedores.add(idVendedor);
        }
        return new MesclagemFaturamentoWrapper(idsVendedores, itens);
    }

    @RequestMapping(value={"/cancelar-saldo"}, method={RequestMethod.POST})
    @DBTransaction
    public void cancelarSaldo(@RequestBody List<Long> idsDav) throws UnicoMensagemUsuarioException {
        PedidoRN.getInstance().cancelarSaldos(SessaoUtil.getSessao(), idsDav);
    }

    @RequestMapping(value={"/validar-cancelar-saldo"}, method={RequestMethod.POST})
    @DBAutoCommit
    public String validarCancelarSaldo(@RequestBody List<Long> idsDav) throws UnicoMensagemUsuarioException {
        String retorno = "";
        List pedidos = idsDav.stream().map(arg_0 -> ((PedidoRN)PedidoRN.getInstance()).buscarPorId(arg_0)).collect(Collectors.toList());
        int qtdValidos = 0;
        for (Pedido pedido : pedidos) {
            if (!pedido.getStatus().in(new AbstractEnum[]{StatusDAV.FECHADO, StatusDAV.PARCIAL})) continue;
            ++qtdValidos;
        }
        if (pedidos.size() > 1 && qtdValidos > 0 && pedidos.size() > qtdValidos) {
            retorno = "O sistema vai cancelar apenas os pedidos N\u00e3o faturado(s) e Parcialmente faturado(s).";
        }
        if (pedidos.size() == 1 && pedidos.size() != qtdValidos || qtdValidos == 0) {
            throw new UnicoMensagemUsuarioException("WVND151", "Selecione pedido(s) N\u00e3o faturado(s) ou Parcialmente faturado(s).");
        }
        return retorno;
    }

    @RequestMapping(value={"/mesclar-itens"}, method={RequestMethod.POST})
    @DBTransaction
    public String mesclarItensFaturamento(@RequestBody MesclagemFaturamentoWrapper<I> wrapper) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)wrapper.getIdVendedor())) {
            throw new UnicoMensagemUsuarioException("WWW670", "O vendedor n\u00e3o foi informado. Por favor, verifique.");
        }
        ((AbstractFaturamentoRN)this.rn).mesclarDocumentos(SessaoUtil.getSessao(), wrapper.getIdVendedor(), wrapper.getIdsDafs(), wrapper.getItensDaf(), this.getRegraNegocioItem());
        return "Documentos mesclados com sucesso";
    }

    protected NotificacaoCompartilhamento verificaCompartilhamento(List<E> documentos, String singular, String plural) {
        Long idEntidade = null;
        String codigosDocumentos = null;
        int cont = 0;
        for (AbstractFaturamento documento : documentos) {
            ++cont;
            if (Util.longNullOuZero(idEntidade)) {
                idEntidade = documento.getIdCliente();
            }
            if (Util.stringNullOrEmpty(codigosDocumentos)) {
                codigosDocumentos = documento.getCodigo().toString();
                continue;
            }
            if (cont != 1 && cont == documentos.size()) {
                codigosDocumentos = codigosDocumentos + " e " + documento.getCodigo().toString();
                continue;
            }
            codigosDocumentos = codigosDocumentos + ", " + documento.getCodigo().toString();
        }
        String complemento = cont > 1 ? "os " + singular.toLowerCase() + ": " : "o " + plural.toLowerCase() + " ";
        NotificacaoCompartilhamento notificacaoCompartilhamento = new NotificacaoCompartilhamento();
        notificacaoCompartilhamento.setAssunto("Segue em anexo " + complemento + codigosDocumentos + ".");
        notificacaoCompartilhamento.setCelular((String)EntidadeRN.getInstance().buscarValorPorID(idEntidade, "whatsapp"));
        return notificacaoCompartilhamento;
    }

    protected String reescreveTextoMensagem(List<E> faturamentos, Long idTextoGenerico) {
        TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(idTextoGenerico);
        String mensagem = textoGenerico.getTexto();
        if (mensagem == null) {
            return null;
        }
        Filial filial = SessaoUtil.getSessao().getFilial();
        mensagem = mensagem.replace(VariavelTextoGenerico.RAZAO_SOCIAL.getId(), filial.getRazaoSocialCompleta());
        mensagem = mensagem.replace(VariavelTextoGenerico.CNPJ_EMPRESA.getId(), filial.getCnpj());
        mensagem = mensagem.replace(VariavelTextoGenerico.NOME_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getNome());
        mensagem = mensagem.replace(VariavelTextoGenerico.INSCRICAO_ESTADUAL_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getInscricaoEstadual());
        mensagem = mensagem.replace(VariavelTextoGenerico.ENDERECO_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getEndereco());
        mensagem = mensagem.replace(VariavelTextoGenerico.NUMERO_ENDERECO_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getNumero());
        mensagem = mensagem.replace(VariavelTextoGenerico.CIDADE_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getCidade());
        mensagem = mensagem.replace(VariavelTextoGenerico.CEP_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getCep());
        mensagem = mensagem.replace(VariavelTextoGenerico.UF_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getEstado());
        mensagem = mensagem.replace(VariavelTextoGenerico.DATA_ATUAL.getId(), Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd/MM/yyyy"));
        mensagem = mensagem.replace(VariavelTextoGenerico.TOTAL_DOCUMENTOS_PEDIDO_OU_ORCAMENTO.getId(), Integer.toString(faturamentos.size()));
        StringBuilder documentos = new StringBuilder();
        StringBuilder vendedores = new StringBuilder();
        BigDecimal valorDocumentos = BigDecimal.ZERO;
        for (AbstractFaturamento documento : faturamentos) {
            Entidade vendedor;
            valorDocumentos = valorDocumentos.add(documento.getValor());
            if (documentos.length() > 0) {
                documentos.append(", ");
            }
            documentos.append(documento.getCodigo());
            Long idVendedor = documento.getIdRepresentante();
            if (Util.longNullOuZero((Long)idVendedor) || (vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(idVendedor)) == null || vendedores.indexOf(vendedor.toString()) >= 0) continue;
            if (vendedores.length() > 0) {
                vendedores.append(", ");
            }
            vendedores.append(vendedor);
        }
        Long idCliente = ((AbstractFaturamento)faturamentos.get(0)).getIdCliente();
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        mensagem = mensagem.replace(VariavelTextoGenerico.VENDEDOR_PEDIDO_OU_ORCAMENTO.getId(), vendedores);
        mensagem = mensagem.replace(VariavelTextoGenerico.VALOR_TOTAL_DOCUMENTOS_PEDIDO_OU_ORCAMENTO.getId(), Util.formataNumero((BigDecimal)valorDocumentos, (String)"#,##0.00"));
        mensagem = mensagem.replace(VariavelTextoGenerico.CODIGO_DOCUMENTOS_PEDIDO_OU_ORCAMENTO.getId(), documentos);
        mensagem = mensagem.replace(VariavelTextoGenerico.VALOR_TOTAL_DOCUMENTOS_POR_EXTENSO_PEDIDO_OU_ORCAMENTO.getId(), new Extenso(valorDocumentos).toString());
        if (cliente != null) {
            Cidade c = (Cidade)CidadeRN.getInstance().buscarPorId(cliente.getEndereco().getIdCidade());
            String cidade = c.getNome();
            String cep = cliente.getEndereco().getCep();
            String estado = cliente.getEndereco().getEstado();
            mensagem = mensagem.replace(VariavelTextoGenerico.NOME_CLIENTE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getNome());
            mensagem = mensagem.replace(VariavelTextoGenerico.RAZAO_SOCIAL_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getRazaoSocial());
            mensagem = mensagem.replace(VariavelTextoGenerico.CNPJ_CPF_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getCnpjCpf());
            mensagem = mensagem.replace(VariavelTextoGenerico.INSCRICAO_ESTADUAL_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getInscricaoEstadual());
            mensagem = mensagem.replace(VariavelTextoGenerico.ENDERECO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getEndereco());
            mensagem = mensagem.replace(VariavelTextoGenerico.BAIRRO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getBairro());
            mensagem = mensagem.replace(VariavelTextoGenerico.COMPLEMENTO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getComplemento());
            mensagem = mensagem.replace(VariavelTextoGenerico.NUMERO_ENDERECO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getNumero());
            mensagem = mensagem.replace(VariavelTextoGenerico.CIDADE_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cidade != null ? cidade : "");
            mensagem = mensagem.replace(VariavelTextoGenerico.CEP_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cep != null ? cep : "");
            mensagem = mensagem.replace(VariavelTextoGenerico.UF_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), estado != null ? estado : "");
            mensagem = mensagem.replace(VariavelTextoGenerico.PROFISSAO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getProfissao());
        } else {
            mensagem = mensagem.replaceAll("<@[A-Za-z]>", "");
        }
        return mensagem;
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idCliente", "idCliente", 0, false));
        colunas.add(new ColunaSQL("idTransacaoFinanceira", "idTransacaoFinanceira", 0, false));
        colunas.add(new ColunaSQL("idConfiguracaoEcommerce", "idConfiguracaoEcommerce", 0, false));
        colunas.add(new ColunaSQL("idFormaEntregaRegiao", "idFormaEntregaRegiao", 0, false));
        colunas.add(new ColunaSQL("despachoMelhorEnvio", "despachoMelhorEnvio", 0, false));
        colunas.add(new ColunaSQL("statusConferencia", "Status confer\u00eancia", 0, false));
        colunas.add(new ColunaSQL("codigo", "Documento", 130, true));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 0, true, new String[]{"fk_dav_cliente"}));
        colunas.add(new ColunaSQL("nome", "nomeVendedor", "Vendedor", 0, true, new String[]{"fk_dav_representante"}));
        colunas.add(new ColunaSQL("data", "Data", 120, true));
        ColunaSQL colunaValor = new ColunaSQL("valor", "Valor", 130, true);
        colunaValor.setTotalizar(true);
        colunas.add(colunaValor);
        colunas.add(new ColunaSQL("status", "Situa\u00e7\u00e3o", 120, true));
        colunas.add(new ColunaSQL("status", "statusDav", "Status", 120, false, new String[0]));
        colunas.add(new ColunaSQL("data", "dataPedido", "Data", 0, false, new String[0]));
        colunas.add(new ColunaSQL("entrega", "Entrega", 0, false));
        colunas.add(new ColunaSQL("nome", "vendedorPedido", "Vendedor", 0, false, new String[]{"fk_dav_representante"}));
        if (this.moduloService.isAtivo(Modulo.UNIPLUS_SHOP) && TipoDocumentoDAV.PEDIDO_FATURAMENTO.equals((Object)this.tipoDocumentoDAV)) {
            ColunaSQL meioPagamento = new ColunaSQL("meiopagamento", "meioPagTransacaoFinanceira", "Meio Pgmto", 0, false, new String[]{"fk_dav_transacaofinanceira"});
            meioPagamento.setClasseEnum(TransacaoFinanceiraMeioPagamento.class);
            colunas.add(meioPagamento);
        }
        if (this.moduloService.isAtivo(Modulo.ECOMMERCE)) {
            Caso caso = new Caso();
            caso.add(new Condicao(Separador.ABRE_PARENTESIS));
            caso.add(new Condicao("codigoecommerce", Operador.IGUAL, ""));
            caso.add(new Condicao(OperadorLogico.OU));
            caso.add(new Condicao("codigoecommerce", Operador.IS_NULL));
            caso.add(new Condicao(Separador.FECHA_PARENTESIS));
            caso.setValor(new Constante((Object)"false"));
            Escolha escolhaEcommerce = new Escolha(caso, new Constante((Object)"true"));
            ColunaSQL colunaSQLEcommerce = new ColunaSQL(escolhaEcommerce, "ecommerce", "E-commerce", 80, false, false);
            colunaSQLEcommerce.setTipoDadoBase(TipoDadoBase.CHARACTER_VARYING);
            colunas.add(colunaSQLEcommerce);
        }
        Caso caso2 = new Caso();
        caso2.add(new Condicao("parceirointegracao", Operador.IGUAL, ParceiroIntegracao.UNIPLUS_SHOP.getId().intValue()));
        caso2.setValor(new Constante((Object)"true"));
        Escolha escolhaUSHOP = new Escolha(caso2, new Constante((Object)"false"));
        ColunaSQL colunaSQLUSHOP = new ColunaSQL(escolhaUSHOP, "financeiroGeradoPorUniplusShop", "Gerado por Uniplus Shop", 80, false, false);
        colunaSQLUSHOP.setTipoDadoBase(TipoDadoBase.CHARACTER_VARYING);
        colunas.add(colunaSQLUSHOP);
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CONFERENCIA) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 908)) {
            colunas.add(new ColunaSQL("statusconferencia", "Confer\u00eancia", 200, true));
        }
        String aliasTabela = this.tipoDocumentoDAV != null ? ((AbstractFaturamentoRN)this.rn).getTabela().concat("_").concat(this.tipoDocumentoDAV.getId().toString()) : null;
        GridBuilder grid = new GridBuilder(((AbstractFaturamentoRN)this.rn).getTabela(), colunas, aliasTabela);
        grid.addReferenciaDefault(new Referencia("tipodocumento"));
        grid.addReferenciaDefault(new Referencia("idFilial"));
        grid.addReferenciaDefault(new Referencia("idRepresentante"));
        grid.addReferenciaDefault(new Referencia("pautapreco"));
        if (this.moduloService.isAtivo(Modulo.ECOMMERCE)) {
            grid.addReferenciaDefault(new Referencia("codigoecommerce"));
        }
        if (this.moduloService.isAtivo(Modulo.UNIPLUS_SHOP)) {
            grid.addReferenciaDefault(new Referencia("uniplusShop", "shop"));
        }
        if (this.tipoDocumentoDAV != null) {
            grid.addCodicaoDefault(new Condicao("tipodocumento", Operador.IGUAL, this.tipoDocumentoDAV.getId().intValue()));
        }
        Sessao sessao = SessaoUtil.getSessao();
        grid.addReferenciaDefault(new Referencia("idnotafiscal"));
        grid.addReferenciaDefault(new Referencia("parceirointegracao", "parceirointegracao", new String[]{"fk_dav_transacaofinanceira", "fk_transacao_intermediador"}));
        grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, sessao.getIdFilial()));
        grid.addOrdemDefault(new Ordem("dataPedido", true));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelDocumentoFiscalDAV(sessao, this.tipoDocumentoDAV));
        if (TipoDocumentoDAV.PEDIDO_FATURAMENTO.equals((Object)this.tipoDocumentoDAV) && ModuloManager.getInstance().isAtivo(Modulo.EXPEDICAO)) {
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelUsuarioCargaDaf(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelDataCargaDaf(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelStatusCargaDaf(sessao));
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCodigoCargaDaf(sessao));
        }
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelNomePautaUtilizadaVenda(sessao, FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)));
        return grid;
    }

    public List<Coluna> getColunasCustomizaveis() {
        return ((AbstractFaturamentoRN)this.rn).getColunaGridCustomizavelDavWW(this.tipoDocumentoDAV);
    }

    protected void carregarDadosItem(ProdutoItemWeb<I> produtoItem, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        this.carregarDadosItem(produtoItem, parametros, false, true);
    }

    protected void carregarDadosItem(ProdutoItemWeb<I> produtoItem, MultiValueMap<String, String> parametros, boolean apenasCarregarItem, boolean atualizaPreco) throws UnicoMensagemUsuarioException {
        Estado estado;
        Long idParametroFiscal = null;
        Long idCondicaoPgmto = null;
        Entidade cliente = null;
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        if (parametros.containsKey((Object)"idParametro")) {
            idParametroFiscal = StringUtil.convertFirstValueMapToLong(parametros, (String)"idParametro");
        } else if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            throw new UnicoMensagemUsuarioException("WWW175", "Par\u00e2metro para identificar natureza de opera\u00e7\u00e3o n\u00e3o encontrado.");
        }
        Long idCliente = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCliente");
        if (!NumberUtil.longNullOuZero((Long)idCliente)) {
            cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        }
        if (parametros.containsKey((Object)"idCondicaoPgmto")) {
            idCondicaoPgmto = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCondicaoPgmto");
        }
        Long pauta = StringUtil.convertFirstValueMapToLong(parametros, (String)"pauta");
        int transacao = StringUtil.convertFirstValueMapToInt(parametros, (String)"transacao");
        boolean possuiItens = StringUtil.convertFirstValueMapToBoolean(parametros, (String)"possuiItens");
        List novosTipos = StringUtil.getAllValuesMap(parametros, (String)"tiposEmbalagem");
        if (!ListMapUtil.listNullOrEmpty(tipos)) {
            novosTipos.forEach(tipo -> {
                TipoEmbalagem tipoEmbalagem = Enum.valueOf(TipoEmbalagem.class, tipo);
                if (!tipos.contains(tipoEmbalagem)) {
                    tipos.add(tipoEmbalagem);
                }
            });
        }
        Sessao sessao = SessaoUtil.getSessao();
        boolean calcularImpostos = this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO);
        boolean utilizaOperacaoFiscal = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372);
        TipoValorPreco tipoPreco = TipoValorPreco.PRECO;
        if (calcularImpostos) {
            tipoPreco = this.calculoImpostoService.getTipoValorPreco(idParametroFiscal, utilizaOperacaoFiscal);
        }
        String codigoEstado = "";
        if (cliente != null && (estado = (Estado)EstadoRN.getInstance().buscarPorId(cliente.getEndereco().getIdEstado())) != null) {
            codigoEstado = estado.getCodigo();
        }
        CfopItem cfopItem = new CfopItem(idParametroFiscal, null, codigoEstado, cliente != null ? cliente.getCnpjCpf() : null, 2);
        int origem = this.tipoDocumentoDAV.getId().equals(TipoDocumentoDAV.PEDIDO_FATURAMENTO.getId()) ? 18 : 43;
        new ProdutoItemRN().carregaItem(sessao, produtoItem, cliente, idParametroFiscal, idCondicaoPgmto, pauta, calcularImpostos, true, true, tipoPreco, utilizaOperacaoFiscal, true, false, cfopItem, tipos, false, atualizaPreco, (AtacarejoWeb)this.atacarejoService, origem, true);
        ((AbstractFaturamentoItem)produtoItem.getItem()).setPautaPreco(pauta);
        ((AbstractFaturamentoItem)produtoItem.getItem()).setTipoProdutoEspecifico(produtoItem.getProduto().getProdutoEspecifico());
        if (calcularImpostos && !apenasCarregarItem) {
            ImpostoWrapper imposto = new ImpostoWrapper((ProdutoItem)produtoItem.getItem(), TipoCalculoImposto.CST_IPI, idParametroFiscal, cliente != null ? cliente.getId() : null, possuiItens, transacao);
            imposto.setCalcularImposto(true);
            this.tratamentoImposto.tratarObjeto(imposto);
            List acoes = this.calculoImpostoService.calcularImpostos(imposto, true).getAcoes();
            produtoItem.setAcoes(acoes);
        }
        if (cliente != null) {
            ((AbstractFaturamentoItem)produtoItem.getItem()).setPrecoUltimaVendaProduto(DavItemRN.getInstance().getPrecoUltimaVendaNfPorCliente(cliente.getId(), produtoItem.getProduto().getId()));
        }
    }

    protected void beforeRead(E e, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (7 == modo) {
            e.setCodigo(null);
            e.setData(DataHoraFactory.getData());
            ((AbstractFaturamentoRN)this.rn).limparCamposParaDuplicar(e);
        }
        e.setValor(e.getValor().subtract(e.getValorFrete()).subtract(e.getOutrasDespesas()));
    }

    protected void beforeCreate(E faturamento, Optional<Long> parentId) {
        faturamento.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        if (faturamento.getData() == null) {
            faturamento.setData(DataHoraFactory.getData());
        }
        faturamento.setStatus(StatusDAV.FECHADO);
    }

    protected void beforeUpdate(E faturamento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (faturamento.getStatus().equals((Object)StatusDAV.INCLUIDO_POR_CLIENTE)) {
            faturamento.setStatus(StatusDAV.FECHADO);
        }
    }

    protected void beforeSave(E faturamento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        faturamento.setItensExcluidos(this.separarItensKit(faturamento.getItensExcluidos()));
        faturamento.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        faturamento.setCupomemitido(Integer.valueOf(0));
        ComportamentoClienteAtrasoVendas comportamentoClienteAtrasoVendas = (ComportamentoClienteAtrasoVendas)PropriedadeRN.getInstance().getPropriedadeEnum(Contexto.getInstance().getFilial(), 817);
        faturamento.setValidarDocumentosEmAtraso(!ComportamentoClienteAtrasoVendas.PERMITIR.equals((Object)comportamentoClienteAtrasoVendas));
        if (ListMapUtil.listNullOrEmpty((List)faturamento.getItens())) {
            throw new UnicoMensagemUsuarioException("WDAF9", "N\u00e3o existem itens para esse documento");
        }
        BigDecimal valorMinimo = PropriedadeRN.getInstance().getPropriedadeBigDecimal(SessaoUtil.getSessao().getFilial(), 1000030);
        if (valorMinimo.compareTo(BigDecimal.ZERO) > 0 && faturamento.getValor().compareTo(valorMinimo) > 0 && NumberUtil.longNullOuZero((Long)faturamento.getIdCliente())) {
            throw new UnicoMensagemUsuarioException("WDAF12", "Por favor informe o cliente pois o valor ultrapassa R$ " + StringUtil.formataNumero((BigDecimal)valorMinimo, (String)"#,###,###,##0.00", (int)2));
        }
        if (faturamento.isVerificarCredito()) {
            try {
                LimiteCreditoRN.getInstance().validarLimiteCredito(SessaoUtil.getSessao(), faturamento);
            }
            catch (UnicoPerguntaUsuarioException e) {
                throw new UnicoMensagemUsuarioException("COM236579", "O limite de cr\u00e9dito do cliente extrapolou! n\u00e3o \u00e9 poss\u00edvel continuar.");
            }
        }
        faturamento.setItens(this.separarItensKit(faturamento.getItens()));
        this.validarItens(faturamento);
    }

    @DBAutoCommit
    public List<I> getItens(Long id) throws UnicoMensagemUsuarioException {
        return this.buscarItens(id, false, false);
    }

    @PostMapping(value={"/incluir-registro-producao"})
    @DBAutoCommit
    public Map<String, Object> incluirRegistroProducao(@RequestBody List<Long> ids) throws UnicoMensagemUsuarioException {
        return ((AbstractFaturamentoRN)this.rn).incluirRegistroProducao(SessaoUtil.getSessao(), ids);
    }

    protected void verificaSePermiteCancelamento(Long id) throws UnicoMensagemUsuarioException {
        AbstractFaturamento faturamento = (AbstractFaturamento)((AbstractFaturamentoRN)this.rn).buscarPorId(id);
        if (faturamento == null) {
            throw new UnicoMensagemUsuarioException("WWW173", id + " n\u00e3o encontrado");
        }
        Integer status = faturamento.getStatus().getId();
        if (status == null) {
            status = 0;
        }
        if (status.equals(StatusDAV.PDV.getId()) || status.equals(StatusDAV.CANCELADO.getId()) || status.equals(StatusDAV.NOTAFISCAL_GERADA.getId()) || status.equals(StatusDAV.PREVENDA_GERADO.getId()) || status.equals(StatusDAV.DUPLICADO.getId()) || status.equals(StatusDAV.PEDIDO_GERADO.getId()) || status.equals(StatusDAV.MESCLADO.getId()) || status.equals(StatusDAV.TRANSFORMADO.getId())) {
            throw new UnicoMensagemUsuarioException("WWW174", "N\u00e3o \u00e9 poss\u00edvel excluir o documento.");
        }
    }

    private NaturezaOperacao getCfopItem(Entidade cliente, Long idProduto, ParametrosNotaFiscalInterface parametrosNotaFiscal, boolean utilizaOperacaoFiscal, String codigoEstado) throws UnicoMensagemUsuarioException {
        if (utilizaOperacaoFiscal) {
            return this.buscarNaturezaOperacaoDaOperacaoFiscal(cliente, idProduto, false, parametrosNotaFiscal != null ? parametrosNotaFiscal.getId() : null);
        }
        return this.buscaNaturezaOperacaoPreferencialItem(parametrosNotaFiscal, cliente, idProduto, codigoEstado);
    }

    public BigDecimal calcularPrecoPorCondicaoPagamento(BigDecimal preco, int casasDecimaisPrecoProduto, Long idPromocao, Long idCondicaoPagamento, Sessao sessao) {
        CondicaoPagamento condicaoPagamento = (CondicaoPagamento)CondicaoPagamentoCommonRN.getInstance().buscarPorId(idCondicaoPagamento);
        if (condicaoPagamento != null && (DescontoRN.getInstance().isPermiteDescontoCondicaoPagamento(sessao.getFilial(), condicaoPagamento) || Util.longNullOuZero((Long)idPromocao)) && condicaoPagamento.getFator().compareTo(BigDecimal.ZERO) > 0) {
            if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) > 0) {
                return condicaoPagamento.getFator().multiply(preco).setScale(casasDecimaisPrecoProduto, 1);
            }
            if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) < 0) {
                return preco.subtract(condicaoPagamento.getFator().multiply(preco).setScale(casasDecimaisPrecoProduto, 1));
            }
        }
        return preco;
    }

    private NaturezaOperacao buscarNaturezaOperacaoDaOperacaoFiscal(Entidade cliente, Long idProduto, boolean mostrarProdutoNaMsg, Long idOperacaoCabecalho) throws UnicoMensagemUsuarioException {
        TipoContribuinte tipoContribuinte = null;
        String codigoEstado = "";
        String cnpj = "";
        Long idEntidade = null;
        if (cliente != null) {
            Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(cliente.getEndereco().getIdEstado());
            if (estado != null) {
                codigoEstado = estado.getCodigo();
            }
            if (TipoPessoa.JURIDICA.equals((Object)cliente.getTipoPessoa())) {
                cnpj = cliente.getCnpjCpf();
            }
            tipoContribuinte = cliente.getTipoContribuinte();
            idEntidade = cliente.getId();
        }
        int origem = this.tipoDocumentoDAV.getId() == TipoDocumentoDAV.PEDIDO_FATURAMENTO.getId() ? 18 : 43;
        return NaturezaOperacaoRN.getInstance().buscarCfopsPorOperacaoFiscal(idProduto, idOperacaoCabecalho, tipoContribuinte, codigoEstado, true, mostrarProdutoNaMsg, cnpj, SessaoUtil.getSessao().getFilial(), idEntidade, origem);
    }

    private NaturezaOperacao buscaNaturezaOperacaoPreferencialItem(ParametrosNotaFiscalInterface parametros, Entidade cliente, Long idProduto, String codigoEstado) {
        boolean naoConsideraTributacaoEspecialItem = false;
        if (parametros != null) {
            naoConsideraTributacaoEspecialItem = parametros.isNaoConsideraTribEspecProduto();
        }
        int origem = this.tipoDocumentoDAV.getId() == TipoDocumentoDAV.PEDIDO_FATURAMENTO.getId() ? 18 : 43;
        return ProdutoRN.getInstance().getCFOPPreferencialTributacaoEspecial(idProduto, codigoEstado, SessaoUtil.getSessao().getFilial().getEstado(), true, naoConsideraTributacaoEspecialItem, origem, parametros, false, cliente.getTipoContribuinte(), SessaoUtil.getSessao().getFilial(), cliente);
    }

    private void validarItens(E faturamento) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            for (AbstractFaturamentoItem item : faturamento.getItens()) {
                int comparacaoValorFcpST;
                int comparacaoValorFcpInterno;
                boolean cstAliquotaZero;
                int comparacaoBaseCofins;
                boolean isReducaoCemPorCento;
                String cstIcms;
                boolean verificaPercentualICMS;
                boolean bl = verificaPercentualICMS = !StringUtil.stringNullOrEmpty((String)item.getSituacaotributaria()) && StringUtil.stringNullOrEmpty((String)item.getSituacaotributariaSN()) && !item.isNaoConsiderarValorTotalNota();
                if (verificaPercentualICMS && ((cstIcms = item.getSituacaotributaria().substring(1)).equals("00") || cstIcms.equals("10") || cstIcms.equals("20") || cstIcms.equals("70")) && item.getPercentualIcms().compareTo(BigDecimal.ZERO) == 0 && SessaoUtil.getSessao().getFilial().getTipoEnquadramento() != TipoEnquadramentoFilial.SIMPLESNACIONAL) {
                    throw new UnicoMensagemUsuarioException("WDAF101", "Para ST do Icms = " + cstIcms + " a al\u00edquota deve ser maior que 0. Configure no cadastro do \"Produto\" ou da \"Natureza de opera\u00e7\u00e3o\" ");
                }
                int comparacaoAliquotaIcms = item.getPercentualIcms().compareTo(BigDecimal.ZERO);
                int comparacaoBaseIcms = item.getBaseIcms().compareTo(BigDecimal.ZERO);
                boolean bl2 = isReducaoCemPorCento = item.getPercentualReducaoIcms().compareTo(NumberUtil.CEM) == 0;
                if (comparacaoAliquotaIcms != comparacaoBaseIcms && !isReducaoCemPorCento) {
                    String msg = comparacaoBaseIcms > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WDAF102", "A al\u00edquota e base de c\u00e1lculo do ICMS n\u00e3o conferem, a al\u00edquota de ICMS " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoAliquotaPis = item.getAliquotaPis().compareTo(BigDecimal.ZERO);
                int comparacaoBasePis = item.getBasePis().compareTo(BigDecimal.ZERO);
                CstPisCofins cstPisCofins = (CstPisCofins)EnumUtils.getPorId(CstPisCofins.class, (Object)item.getCstPis());
                if (comparacaoAliquotaPis != comparacaoBasePis && cstPisCofins != null && !cstPisCofins.isAliquotaZero()) {
                    String msg = comparacaoBasePis > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WDAF103", "A al\u00edquota e base de c\u00e1lculo do PIS n\u00e3o conferem, a al\u00edquota do PIS " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoAliquotaCofins = item.getAliquotaCofins().compareTo(BigDecimal.ZERO);
                if (comparacaoAliquotaCofins != (comparacaoBaseCofins = item.getBaseCofins().compareTo(BigDecimal.ZERO)) && cstPisCofins != null && !cstPisCofins.isAliquotaZero()) {
                    String msg = comparacaoBaseCofins > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WDAF104", "A al\u00edquota e base de c\u00e1lculo do COFINS n\u00e3o conferem, a al\u00edquota do COFINS " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoValorIcmsST = item.getIcmsSubstituicao().compareTo(BigDecimal.ZERO);
                int comparacaoBaseIcmsST = item.getBaseIcmsSubstituicao().compareTo(BigDecimal.ZERO);
                int comparacaoAliquotaIcmsST = item.getPercentualIcmsSubstituicao().compareTo(BigDecimal.ZERO);
                if (comparacaoValorIcmsST != comparacaoBaseIcmsST) {
                    String msg = comparacaoBaseIcmsST > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WDAF105", "Os valores de ICMS substitui\u00e7\u00e3o n\u00e3o conferem, o valor de ICMS substitui\u00e7\u00e3o " + msg + "deve ser informado quando o item " + msg + "possuir base de c\u00e1lculo de ICMS substitui\u00e7\u00e3o. Verifique! ");
                }
                if (comparacaoValorIcmsST != comparacaoAliquotaIcmsST) {
                    String msg = comparacaoValorIcmsST > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WDAF106", "Os valores de ICMS substitui\u00e7\u00e3o n\u00e3o conferem, a al\u00edquota de ICMS substitui\u00e7\u00e3o " + msg + "deve ser informada quando o item " + msg + "possuir valor de ICMS substitui\u00e7\u00e3o. Verifique! ");
                }
                int comparacaoAliquotaIPI = item.getPercentualIpi().compareTo(BigDecimal.ZERO);
                int comparacaoBaseIPI = item.getBaseIpi().compareTo(BigDecimal.ZERO);
                boolean bl3 = cstAliquotaZero = item.getSituacaoTributariaIPI() != null && item.getSituacaoTributariaIPI().isAliquotaZero();
                if (comparacaoAliquotaIPI != comparacaoBaseIPI && !cstAliquotaZero) {
                    String msg = comparacaoBaseIPI > 0 ? "" : "n\u00e3o ";
                    throw new UnicoMensagemUsuarioException("WDAF107", "A al\u00edquota e base de c\u00e1lculo do IPI n\u00e3o conferem, a al\u00edquota do IPI " + msg + "deve ser informada quando o item " + msg + "possuir base de c\u00e1lculo. Verifique! ");
                }
                int comparacaoAliquotaFcpInterno = item.getPercIcmsFundoPobrezaInterno().compareTo(BigDecimal.ZERO);
                if (comparacaoAliquotaFcpInterno != (comparacaoValorFcpInterno = item.getIcmsFundoPobrezaInterno().compareTo(BigDecimal.ZERO))) {
                    throw new UnicoMensagemUsuarioException("WDAF144", "A al\u00edquota e valor do FCP interno n\u00e3o conferem. Verifique! ");
                }
                int comparacaoAliquotaFcpST = item.getPercentualIcmsFundoPobrezaST().compareTo(BigDecimal.ZERO);
                if (comparacaoAliquotaFcpST != (comparacaoValorFcpST = item.getIcmsFundoPobrezaST().compareTo(BigDecimal.ZERO))) {
                    throw new UnicoMensagemUsuarioException("WDAF143", "A al\u00edquota e valor do FCP ST n\u00e3o conferem. Verifique! ");
                }
                String cst = item.getSituacaoTributaria() != null ? item.getSituacaoTributaria() : "";
                BigDecimal percentualDiferimento = item.getPercentualIcmsDiferido();
                if (cst.equals("51") && item.getPercentualIcmsDiferido().compareTo(NumberUtil.CEM) > 0) {
                    throw new UnicoMensagemUsuarioException("WNTF9057", "O percentual de diferimento est\u00e1 inv\u00e1lido!");
                }
                Map map = this.calculoImpostoService.atualizarComponentes(new ImpostoWrapper((ProdutoItem)item, null, !NumberUtil.longNullOuZero((Long)faturamento.getIdOperacaoFiscal()) ? faturamento.getIdOperacaoFiscal() : faturamento.getIdCfop(), faturamento.getIdCliente(), true, 0)).getAcoes().stream().collect(Collectors.toMap(acao -> acao.getTipoComponente().getAtributo(), Function.identity()));
                if (map.getOrDefault("icms", new AcaoComponenteItemTributavel()).isVisivel() && !NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getPercentualIcms()) && item.getPercentualIcms().compareTo(NumberUtil.CEM) >= 0) {
                    boolean isIcmsEmPercentual = item.getTipoValorICMS() == 0;
                    throw new UnicoMensagemUsuarioException("WDAF117", "O " + (isIcmsEmPercentual ? "percentual" : "valor") + " do ICMS est\u00e1 inv\u00e1lido!");
                }
                if (!map.getOrDefault("ipi", new AcaoComponenteItemTributavel()).isVisivel() || NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getPercentualIpi()) || item.getPercentualIpi().compareTo(NumberUtil.CEM) < 0) continue;
                boolean isIpiEmPercentual = item.getTipoValorIPI() == 0;
                throw new UnicoMensagemUsuarioException("WWDAF126", "O " + (isIpiEmPercentual ? "percentual" : "valor") + " do IPI est\u00e1 inv\u00e1lido!");
            }
        }
    }

    @RequestMapping(value={"/estornar-mesclagem"}, method={RequestMethod.POST})
    @DBTransaction
    public void estornarMesclagem(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        if (!((AbstractFaturamentoRN)this.rn).isDocumentoPedidosMesclados(id)) {
            throw new UnicoMensagemUsuarioException("DAF200", "N\u00e3o \u00e9 poss\u00edvel estornar o documento selecionado pois o mesmo n\u00e3o \u00e9 originado de mesclagem");
        }
        ((AbstractFaturamentoRN)this.rn).estornarPedidoMesclado(SessaoUtil.getSessao(), id, true);
    }

    @RequestMapping(value={"/recalcular-volume"}, method={RequestMethod.POST})
    @DBAutoCommit
    public E recalcularVolumes(@RequestBody E daf) {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_PESO_VOLUME_NOTA_FISCAL_DAF)) {
            NotaFiscalRN.getInstance().atualizarInformacoesCargaNotaFiscal(daf, daf.getItens());
        }
        return daf;
    }

    protected GeradorKitVenda<IK> getGeradorKitVenda() {
        return new GeradorKitVendaFaturamento(this.itemRN);
    }

    protected List<IK> afterRateioKit(ItemKitWrapper<E, IK> wrapper, List<IK> itensParaRateio) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_ORCAMENTO_FATURAMENTO)) {
            ImpostoWrapper impostoWrapper = new ImpostoWrapper(wrapper.getIdCliente(), wrapper.getIdParametro(), itensParaRateio);
            impostoWrapper.setEstado(wrapper.getEstado());
            return this.recalcularImpostosItens(impostoWrapper);
        }
        return itensParaRateio;
    }

    protected MultiValueMap<String, String> getMapParamsKit(ItemKitWrapper<E, IK> wrapper) {
        if (wrapper.getItem() != null) {
            wrapper.setIdParametro(((AbstractFaturamentoItem)wrapper.getItem()).getIdCfop());
        }
        return super.getMapParamsKit(wrapper);
    }

    private IRN getRegraNegocioItem() {
        return (IRN)this.itemRN;
    }

    protected String getSufixoParametrosRelatorio() {
        return "_daf";
    }

    public Extras getCampoExtra(String nome, String tabela) {
        if (tabela.equals(DavRN.getInstance().getTabela()) && this.tipoDocumentoDAV != null) {
            return ExtrasRN.getInstance().buscarPorNomeTabela(this.tipoDocumentoDAV.getTabelaCamposExtra());
        }
        return null;
    }

    @GetMapping(value={"dados-pre-postagem-etiquetas-transporte"})
    @DBAutoCommit
    public PrePostagemEtiquetaTransporte buscarDadosEtiquetaTransporte(@RequestParam Long idPedido) throws UnicoMensagemUsuarioException {
        PrePostagemEtiquetaTransporte dados = new PrePostagemEtiquetaTransporte();
        dados.setIdPedido(idPedido);
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorIdLazy(idPedido);
        if (pedido == null) {
            throw new UnicoMensagemUsuarioException("WECO513", "Pedido n\u00e3o foi encontrado.");
        }
        if (pedido.getEtiquetaPrePostagem() != null) {
            if (Util.stringNullOrEmpty((String)pedido.getCodigoObjetoPrePostagem())) {
                throw new UnicoMensagemUsuarioException("WECO510", "N\u00e3o foi encontrado o c\u00f3digo da pr\u00e9-postagem");
            }
            dados.setReimprimir(true);
            ResponsePrePostagemApiCorreios response = (ResponsePrePostagemApiCorreios)JSONUtil.getObject((String)pedido.getJsonPrePostagemCorreio(), ResponsePrePostagemApiCorreios.class);
            if (response != null) {
                String codigoObjeto;
                CodigoFormatoObjetoInformado formato;
                CodigoServicoCorreios servico;
                if (!Util.stringNullOrEmpty((String)response.getCodigoServico()) && (servico = (CodigoServicoCorreios)EnumUtils.getPorId(CodigoServicoCorreios.class, (Object)response.getCodigoServico())) != null) {
                    dados.setServicoCorreios(servico);
                }
                if (!Util.stringNullOrEmpty((String)response.getCodigoFormatoObjetoInformado()) && (formato = (CodigoFormatoObjetoInformado)EnumUtils.getPorId(CodigoFormatoObjetoInformado.class, (Object)response.getCodigoFormatoObjetoInformado())) != null) {
                    dados.setFormatoObjeto(formato);
                }
                if (!Util.stringNullOrEmpty((String)(codigoObjeto = response.getCodigoObjeto()))) {
                    dados.setCodigoObjeto(codigoObjeto);
                }
            }
        } else {
            TipoRotuloApiCorreios tipoRotulo;
            String rotulo;
            CodigoFormatoObjetoInformado codigoFormato;
            String formato;
            CodigoServicoCorreios codigoServico;
            Sessao sessao = SessaoUtil.getSessao();
            String servico = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), 1020);
            if (!Util.stringNullOrEmpty((String)servico) && (codigoServico = (CodigoServicoCorreios)EnumUtils.getPorId(CodigoServicoCorreios.class, (Object)servico)) != null) {
                dados.setServicoCorreios(codigoServico);
            }
            if (!Util.stringNullOrEmpty((String)(formato = (String)PropriedadeRN.getInstance().getPropriedadeEnum(sessao.getFilial(), 1021))) && (codigoFormato = (CodigoFormatoObjetoInformado)EnumUtils.getPorId(CodigoFormatoObjetoInformado.class, (Object)formato)) != null) {
                dados.setFormatoObjeto(codigoFormato);
            }
            if (!Util.stringNullOrEmpty((String)(rotulo = (String)PropriedadeRN.getInstance().getPropriedadeEnum(sessao.getFilial(), 1022))) && (tipoRotulo = (TipoRotuloApiCorreios)EnumUtils.getPorId(TipoRotuloApiCorreios.class, (Object)rotulo)) != null) {
                dados.setTipoRotulo(tipoRotulo);
            }
            dados.setImprimeRemetente(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 1023));
            List listaItens = DavItemRN.getInstance().buscarListaPorIdDav(pedido.getId());
            if (!Util.listNullOrEmpty((List)listaItens)) {
                BigDecimal pesoProduto = BigDecimal.ZERO;
                for (DavItem item2 : listaItens) {
                    if (item2.getTipoKit() == TipoKit.KIT_COMPONENTE.getId().intValue()) continue;
                    BigDecimal peso = BigDecimal.ZERO;
                    Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(item2.getIdProduto());
                    if (produto != null) {
                        peso = produto.getPeso();
                    }
                    pesoProduto = pesoProduto.add(peso.multiply(item2.getQuantidade()));
                }
                dados.setPeso(pesoProduto.multiply(BigDecimal.valueOf(1000L)).setScale(0, RoundingMode.HALF_EVEN));
                if (listaItens.stream().filter(item -> item.getTipoKit() != TipoKit.KIT_COMPONENTE.getId().intValue()).count() == 1L) {
                    DavItem davItem = (DavItem)listaItens.get(0);
                    Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(davItem.getIdProduto());
                    if (produto != null) {
                        if (!Util.bigDecimalNullOrZero((BigDecimal)produto.getAlturaShop())) {
                            dados.setAltura(produto.getAlturaShop());
                        }
                        if (!Util.bigDecimalNullOrZero((BigDecimal)produto.getComprimentoShop())) {
                            dados.setComprimento(produto.getComprimentoShop());
                        }
                        if (!Util.bigDecimalNullOrZero((BigDecimal)produto.getLarguraShop())) {
                            dados.setLargura(produto.getLarguraShop());
                        }
                    }
                }
            }
        }
        return dados;
    }

    @RequestMapping(value={"gerar-etiqueta-transporte"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void gerarEtiqueta(@RequestBody PrePostagemEtiquetaTransporte dados) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        PropriedadeRN.getInstance().setPropriedade(sessao, 1020, dados.getServicoCorreios().getId());
        PropriedadeRN.getInstance().setPropriedade(sessao, 1021, dados.getFormatoObjeto().getId());
        PropriedadeRN.getInstance().setPropriedade(sessao, 1022, dados.getTipoRotulo().getId());
        PropriedadeRN.getInstance().setPropriedade(sessao, 1023, Boolean.valueOf(dados.isImprimeRemetente()));
        dados.setSessao(sessao);
        ProcessarApiCorreios processarApi = new ProcessarApiCorreios();
        processarApi.processarEtiqueta(dados);
        Util.espera((int)4000);
        this.imprimiEtiquetaCorreios(dados.getIdPedido());
    }

    @RequestMapping(value={"reimprimir-etiqueta-transporte"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void reimprimirEtiqueta(@RequestBody Long idPedido) {
        this.imprimiEtiquetaCorreios(idPedido);
    }

    private void imprimiEtiquetaCorreios(Long idPedido) {
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorIdLazy(idPedido);
        if (pedido != null) {
            this.notificationService.notifyEtiquetaCorreios(Contexto.getInstance().getUsuario().getId(), pedido.getEtiquetaPrePostagem(), pedido.getDeclaracaoPrePostagem());
        }
    }

    @PostMapping(value={"cancelar-etiqueta-transporte"})
    @DBAutoCommit
    public void cancelarEtiquetaTransporte(@RequestBody Long idPedido) throws UnicoMensagemUsuarioException {
        ProcessarApiCorreios processar = new ProcessarApiCorreios();
        processar.enviaCancelamentoEtiqueta(SessaoUtil.getSessao(), idPedido);
    }

    @PostMapping(value={"/validar-entidade-desconto"})
    @DBTransaction
    public FaturamentoAlterarEntidadeDescontoWrapper validarEntidadeDesconto(@RequestBody FaturamentoWrapper<I> wrapper, @RequestParam Long idEntidadeAtual) {
        ArrayList<AbstractFaturamentoItem> itensAlterados = new ArrayList<AbstractFaturamentoItem>();
        ArrayList<AbstractFaturamentoItem> itensParaExcluir = new ArrayList<AbstractFaturamentoItem>();
        for (AbstractFaturamentoItem item : wrapper.getItens()) {
            EntidadeDesconto entidadeDescontoAtual = EntidadeDescontoRN.getInstance().buscaDescontoProduto(idEntidadeAtual, item.getIdProduto());
            EntidadeDesconto entidadeDescontoAnterior = (EntidadeDesconto)EntidadeDescontoRN.getInstance().buscarPorId(item.getIdEntidadeDesconto());
            if (entidadeDescontoAtual == null) continue;
            if (entidadeDescontoAnterior != null && entidadeDescontoAnterior.getTipoDesconto().equals((Object)entidadeDescontoAtual.getTipoDesconto()) && entidadeDescontoAnterior.getDesconto().compareTo(entidadeDescontoAtual.getDesconto()) == 0) {
                item.setIdEntidadeDesconto(entidadeDescontoAtual.getId());
                item.setEntidadeDesconto(entidadeDescontoAtual);
                itensAlterados.add(item);
                continue;
            }
            itensParaExcluir.add(item);
        }
        return new FaturamentoAlterarEntidadeDescontoWrapper(itensAlterados, itensParaExcluir);
    }
}

