/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.documentoauxiliarfaturamento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.AbstractFaturamentoItem;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.ParametrosNotaFiscalInterface;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.regranegocio.notafiscal.UtilNotaFiscal;
import br.intelidata.commons.domain.wrapper.ImpostoWrapper;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.TratamentoDadoImpostoInterface;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

@Component(value="tratar-dados-faturamento")
public class FaturamentoTratamentoImposto
implements TratamentoDadoImpostoInterface<AbstractFaturamentoItem> {
    private final CalculoImpostoService<AbstractFaturamentoItem> calculoImpostoService;

    public FaturamentoTratamentoImposto(CalculoImpostoService<AbstractFaturamentoItem> calculoImpostoService) {
        this.calculoImpostoService = calculoImpostoService;
    }

    public void tratarObjeto(ImpostoWrapper<AbstractFaturamentoItem> impostoWrapper) throws UnicoMensagemUsuarioException {
        Produto produto;
        Sessao sessao = SessaoUtil.getSessao();
        AbstractFaturamentoItem item = (AbstractFaturamentoItem)impostoWrapper.getItem();
        NaturezaOperacao naturezaOperacao = NaturezaOperacaoRN.getInstance().buscarPorId(item.getIdCfop());
        if (naturezaOperacao == null) {
            throw new UnicoMensagemUsuarioException("WWW691", "Natureza de opera\u00e7\u00e3o n\u00e3o encontrada");
        }
        boolean operacaoFiscal = this.calculoImpostoService.utilizaOperacaoFiscal(TipoEmissaoNotaFiscal.PROPRIA.equals((Object)impostoWrapper.getTipoEmissao()), sessao.getIdFilial());
        ParametrosNotaFiscalInterface parametrosNotaFiscalInterface = this.calculoImpostoService.getParametrosNotaFiscalInterface(impostoWrapper.getIdParametrosNF(), operacaoFiscal);
        boolean operacaoPodeExigirUnidadeTributavel = UtilNotaFiscal.isCfopExigeUnidadeMedidaTributavel((ParametrosNotaFiscalInterface)parametrosNotaFiscalInterface, (NaturezaOperacao)naturezaOperacao, (Produto)(produto = (Produto)ProdutoRN.getInstance().buscarPorId(item.getIdProduto())));
        if (operacaoPodeExigirUnidadeTributavel) {
            item.setQuantidadeTributavel(NotaFiscalItemRN.getInstance().calcularQuantidadeTributavel(item.getQuantidade(), item.getIdEmbalagemTributavel(), item.getIdEmbalagem()));
        } else {
            item.setQuantidadeTributavel(BigDecimal.ZERO);
        }
    }
}

