/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.configuracao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ConfiguracaoEcommerce;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoEcommerce;
import br.intelidata.commons.domain.pojo.enuns.ecommerce.TipoRoteadorEcommerce;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoEcommerceCommonRN;
import br.intelidata.commons.domain.regranegocio.b2c.RoteadorTransacaoFinanceiraRN;
import br.intelidata.commons.domain.regranegocio.ecommerce.RoteadorEcommerceRN;
import br.intelidata.commons.modulo.c3po.ecommerce.regranegocio.mercadolivre.ProcessarEcommerceMercadoLivre;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuracao-ecommerce"})
@SubMenuMapping(MENU="SubMenuEcommerceGeral", NOME="Configura\u00e7\u00f5es", ICONE="icon-gear", ROTA="/ecommerce/configuracao-ecommerce", PROGRAMA=1404)
public class ConfiguracaoEcommerceCrudController
extends CrudController<ConfiguracaoEcommerce, ConfiguracaoEcommerceCommonRN> {
    public ConfiguracaoEcommerceCrudController() {
        super((AbstractRegraNegocio)ConfiguracaoEcommerceCommonRN.getInstance(), ConfiguracaoEcommerce::new, true, false);
    }

    protected GridBuilder<ConfiguracaoEcommerceCommonRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("tipoIntegracao", "Tipo", 150, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("ambiente", "Ambiente", 150, true));
        colunas.add(new ColunaSQL("codigo", "codigofilial", "C\u00f3digo filial", 150, true, new String[]{"fk_config_ecommerce_filial"}));
        colunas.add(new ColunaSQL("nome", "nomefilial", "Nome filial", 0, true, new String[]{"fk_config_ecommerce_filial"}));
        colunas.add(new ColunaSQL("inativo", "inativo", "Inativo", 80, true, new String[0]));
        return new GridBuilder(ConfiguracaoEcommerceCommonRN.getInstance().getTabela(), colunas);
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<ConfiguracaoEcommerce> getCombo(@RequestParam boolean isAtivo) {
        return ConfiguracaoEcommerceCommonRN.getInstance().getComboWeb(isAtivo);
    }

    @RequestMapping(value={"/combo-perguntas-respostas"})
    @DBAutoCommit
    public List<ConfiguracaoEcommerce> getComboPergutasRespostas() {
        return ConfiguracaoEcommerceCommonRN.getInstance().getComboPergutasRespostasWeb();
    }

    @RequestMapping(value={"/campos"})
    @DBAutoCommit
    public Map<String, Boolean> getConfiguracaoCampos(TipoIntegracaoEcommerce tipo) {
        return ConfiguracaoEcommerceCommonRN.getInstance().getConfiguracaoCamposPorTipo(tipo);
    }

    protected void beforeSave(ConfiguracaoEcommerce configuracaoEcommerce, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave((AbstractPojo)configuracaoEcommerce, parentId);
        if (Util.longNullOuZero((Long)configuracaoEcommerce.getIdFilial())) {
            configuracaoEcommerce.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        }
    }

    protected void afterSave(ConfiguracaoEcommerce configuracaoEcommerce, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List ecommercesAtivos = ConfiguracaoEcommerceCommonRN.getInstance().buscarListaAtivos().stream().map(ConfiguracaoEcommerce::getTipoIntegracao).collect(Collectors.toList());
        this.notificationService.notifyTenantNow(NotificationType.ATUALIZAR_LISTA_ECOMMERCE, ecommercesAtivos);
    }

    @RequestMapping(value={"/gerar-code"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ConfiguracaoEcommerce gerarDadosAutenticacao(@RequestBody ConfiguracaoEcommerce configuracaoEcommerce) throws UnicoMensagemUsuarioException {
        return ConfiguracaoEcommerceCommonRN.getInstance().gerarDadosAutenticacao(configuracaoEcommerce);
    }

    @RequestMapping(value={"/buscar-url-autorizacao"})
    @DBAutoCommit
    public String buscarUrlAutorizacao(@RequestParam Long idConfEcommerce) {
        ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(idConfEcommerce);
        ProcessarEcommerceMercadoLivre processar = new ProcessarEcommerceMercadoLivre();
        return processar.buscarUrlAutorizacao(configuracaoEcommerce);
    }

    @RequestMapping(value={"/gravar-code-usuario"})
    @DBAutoCommit
    public void gravarCodeUsuario(@RequestParam Long idConfEcommerce, @RequestParam String codeUsuarioEcommerce) throws UnicoMensagemUsuarioException {
        ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(idConfEcommerce);
        ProcessarEcommerceMercadoLivre processar = new ProcessarEcommerceMercadoLivre();
        processar.gerarTokenAcesso(configuracaoEcommerce, codeUsuarioEcommerce);
    }

    protected void beforeRead(ConfiguracaoEcommerce configuracaoEcommerce, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        configuracaoEcommerce.setListaRoteadorTransacaoFinanceira(RoteadorTransacaoFinanceiraRN.getInstance().buscarListaPorIdConfiguracaoEcommerce(configuracaoEcommerce.getId()));
        RoteadorTransacaoFinanceiraRN.getInstance().carregaDadosRoteadorTransacaoFinanceira(configuracaoEcommerce.getListaRoteadorTransacaoFinanceira());
        configuracaoEcommerce.setListaRoteadortransportadora(RoteadorEcommerceRN.getInstance().buscarListaPorConfiguracaoEcommerceTipoRoteador(configuracaoEcommerce.getId(), TipoRoteadorEcommerce.TRANSPORTADORA));
        RoteadorEcommerceRN.getInstance().carregaDadosRoteadorEcommerce(configuracaoEcommerce.getListaRoteadortransportadora());
    }

    protected String getCacheId() {
        return "configuracao-ecommerce".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

