/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.perguntasrespostas;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.ecommerce.PerguntasRespostasEcommerce;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.PerguntasRespostasEcommerceRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.perguntasrespostas.PerguntaRespostaWrapper;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/perguntas-respostas"})
@SubMenuMapping(MENU="SubMenuEcommerceGeral", NOME="Perguntas e respostas", ICONE="icon-funcoes-auxiliares", ROTA="/ecommerce/perguntas-respostas", PROGRAMA=11002)
public class PerguntasRespostasEcommerceCrudController
extends SimpleCrudController<PerguntasRespostasEcommerce, PerguntasRespostasEcommerceRN> {
    public PerguntasRespostasEcommerceCrudController() {
        super((AbstractRegraNegocio)PerguntasRespostasEcommerceRN.getInstance());
    }

    @RequestMapping(value={"/lista"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<PerguntasRespostasEcommerce> getLista(@RequestBody PerguntaRespostaWrapper wrapper) {
        List listaPerguntasRespostas = PerguntasRespostasEcommerceRN.getInstance().buscarLista(wrapper.getIdConfiguracaoEcommerce(), wrapper.getStatus(), wrapper.getDataInicial(), wrapper.getDataFinal());
        PerguntasRespostasEcommerceRN.getInstance().carregaDadosPerguntasRepostas(listaPerguntasRespostas);
        return listaPerguntasRespostas;
    }

    @RequestMapping(value={"/buscar"}, method={RequestMethod.POST})
    @DBTransaction
    public void buscar(@RequestBody PerguntaRespostaWrapper wrapper) throws UnicoMensagemUsuarioException {
        PerguntasRespostasEcommerceRN.getInstance().sincronizarPerguntar(SessaoUtil.getSessao(), wrapper.getIdConfiguracaoEcommerce());
    }

    @RequestMapping(value={"/enviar"}, method={RequestMethod.POST})
    @DBTransaction
    public void enviar(@RequestBody PerguntasRespostasEcommerce perguntasRespostas) throws UnicoMensagemUsuarioException {
        PerguntasRespostasEcommerceRN.getInstance().enviarResposta(SessaoUtil.getSessao(), perguntasRespostas);
    }
}

