/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.empresa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.Empresa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.EmpresaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/empresas"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarFilial", NOME="Empresas", ROTA="/cadastros/empresas", PROGRAMA=54)
public class EmpresaCrudController
extends CrudController<Empresa, EmpresaRN> {
    public EmpresaCrudController() {
        super((AbstractRegraNegocio)EmpresaRN.getInstance(), Empresa::new);
    }

    protected GridBuilder<EmpresaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 200, true));
        colunas.add(new ColunaSQL("razaoSocial", "Nome", 0, true));
        GridBuilder grid = new GridBuilder(EmpresaRN.getInstance().getTabela(), colunas);
        grid.addReferencia(new Referencia("razaoSocial", "razaoSocialOrdem"));
        grid.addOrdem(new Ordem("razaoSocialOrdem"));
        return grid;
    }

    @RequestMapping(value={"/por-perfil"})
    @DBAutoCommit
    public List<Empresa> getComboPorPerfil() {
        return ((EmpresaRN)this.rn).getComboPorPerfil(SessaoUtil.getSessao().getUsuario().getIdPerfil());
    }

    @RequestMapping(value={"/lista"})
    @DBAutoCommit
    public List<Empresa> getTodasEmpresas() {
        return ((EmpresaRN)this.rn).buscarLista();
    }

    protected String getCacheId() {
        return "empresas";
    }
}

