/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.enquadramentoipi;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.EnquadramentoIPI;
import br.intelidata.commons.domain.pojo.enuns.CstIPI;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.EnquadramentoIPIRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/enquadramentos-ipi"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Enquadramentos de IPI", ROTA="/notas-fiscais/enquadramentos-ipi", PROGRAMA=1000047)
public class EnquadramentoIpiCrudController
extends CrudController<EnquadramentoIPI, EnquadramentoIPIRN> {
    public EnquadramentoIpiCrudController() {
        super((AbstractRegraNegocio)EnquadramentoIPIRN.getInstance(), EnquadramentoIPI::new);
    }

    @RequestMapping(value={"/validar"})
    @DBAutoCommit
    public boolean validarEnquadramentoCSTIPI(@RequestParam(value="cstIpi", required=false) CstIPI cstIpi, @RequestParam(value="value", required=false) Long idEnquadramento) throws UnicoMensagemUsuarioException {
        EnquadramentoIPIRN.getInstance().validarEnquadramentoCSTIPI(cstIpi, idEnquadramento);
        return true;
    }

    protected GridBuilder<EnquadramentoIPIRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("grupoCST", "Grupo CST", 200, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        return new GridBuilder(EnquadramentoIPIRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "enquadramentos-ipi";
    }
}

