/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.util.Contribuinte;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.ibge.ConsultaCidadeIBGE;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.receitaws.pojo.ReceitaConsultaContribuinte;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.BCrypt;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.whatsapp.TipoIntegracaoWhatsAppEnum;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Cep;
import br.intelidata.commons.domain.pojo.Cidade;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.EntidadeContaContabil;
import br.intelidata.commons.domain.pojo.EntidadeEnderecoAdicional;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.entidade.LimiteCreditoWrapper;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.ComportamentoClienteAtrasoVendas;
import br.intelidata.commons.domain.pojo.enuns.TipoEmailEntidade;
import br.intelidata.commons.domain.pojo.enuns.TipoEntidade;
import br.intelidata.commons.domain.pojo.enuns.TipoEntidadeRevenda;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoMascara;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.pojo.enuns.TipoRetornoDataValorCompraCliente;
import br.intelidata.commons.domain.pojo.enuns.TipoWhatsapp;
import br.intelidata.commons.domain.pojo.enuns.nfe.TipoContribuinte;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.pojo.generico.VariavelTextoGenerico;
import br.intelidata.commons.domain.pojo.whatsapp.ConfiguracaoWhatsApp;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CidadeCommonRN;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoWhatsAppRN;
import br.intelidata.commons.domain.regranegocio.EntidadeCommonRN;
import br.intelidata.commons.domain.regranegocio.EntidadeEnderecoAdicionalRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.CepRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.CidadeRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.cadastros.relatorio.AutorizacaoDependentesRelatorio;
import br.intelidata.commons.modulo.entidade.regranegocio.CartaoFidelidadeConfiguracaoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeContaContabilRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPautaPreco;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.commons.modulo.vendas.relatorio.VendasProdutoRelatorio;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.WhatsAppService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.CompartilhamentoEntidadeDTO;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.EntidadeCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.EntidadeDTO;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.EntidadeEmailWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@Component(value="entidades")
@RestController
@RequestMapping(value={"/api/entidades"})
@SuppressFBWarnings(value={"UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR"}, justification="Nesse caso \u00e9 lazyLoad assim o getGridBuilder n\u00e3o ser\u00e1 chamado antes de setar o tipo de entidade")
public class EntidadeCrudController
extends CrudController<Entidade, EntidadeRN> {
    @Autowired
    private ResponseEntityService responseService;
    @Autowired
    private WhatsAppService whatsAppService;
    @Autowired
    private TaskManager taskManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TipoEntidade tipoEntidade;

    public EntidadeCrudController() {
        this(null);
    }

    public EntidadeCrudController(TipoEntidade tipoEntidade) {
        super((AbstractRegraNegocio)EntidadeRN.getInstance(), Entidade::new, true, true, TipoArquivoArmazenado.Entidade);
        this.tipoEntidade = tipoEntidade;
    }

    @RequestMapping(value={"/consultar-contribuinte"})
    @DBAutoCommit
    public Entidade consultarContribuinte(@RequestBody Entidade entidade, @RequestParam String cnpj, @RequestParam(required=false) String uf) throws UnicoMensagemUsuarioException {
        cnpj = StringUtil.limpaMascara((String)cnpj, (String)TipoMascara.CNPJ.getId());
        Contribuinte contribuinte = null;
        ArrayList<String> excecoes = new ArrayList<String>();
        if (!StringUtil.stringNullOrEmpty((String)uf)) {
            try {
                contribuinte = new NfeManagerWeb(SessaoUtil.getSessao(), null).consultaCadastro(cnpj, uf);
            }
            catch (UnicoMensagemUsuarioException ex) {
                this.log.error("Exce\u00e7\u00e3o ao consultar contribuinte", (Throwable)ex);
                excecoes.add(ex.getMensagemSemCodigoDeErro());
            }
        }
        if (contribuinte == null) {
            HttpHeaders headers = new HttpHeaders();
            headers.set("Accept", "application/json");
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            try {
                ReceitaConsultaContribuinte receita;
                ResponseEntity response = new RestTemplate().exchange("https://www.receitaws.com.br/v1/cnpj/{cnpj}", HttpMethod.GET, entity, ReceitaConsultaContribuinte.class, new Object[]{cnpj});
                if (response.getStatusCodeValue() == HttpStatus.OK.value() && (receita = (ReceitaConsultaContribuinte)response.getBody()) != null) {
                    contribuinte = receita.getContribuinte();
                }
            }
            catch (Throwable ex) {
                this.log.error("Erro ao consultar contribuinte", ex);
                excecoes.add("Erro na consulta na receita federal: " + ex.getMessage());
            }
        }
        if (contribuinte == null || StringUtil.stringNullOrEmpty((String)contribuinte.getRazaoSocial()) && StringUtil.stringNullOrEmpty((String)contribuinte.getFantasia())) {
            throw new UnicoMensagemUsuarioException("NTF389", "Contribuinte n\u00e3o encontrado. " + String.join((CharSequence)". ", excecoes));
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getCNPJ()) || cnpj.length() == 14) {
            entidade.setRazaoSocial(contribuinte.getRazaoSocial());
            entidade.setNome(contribuinte.getFantasia());
        } else if (Util.stringNullOrEmpty((String)contribuinte.getRazaoSocial())) {
            entidade.setNome(contribuinte.getFantasia());
        } else {
            entidade.setNome(contribuinte.getRazaoSocial());
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getCNPJ())) {
            entidade.setTipoPessoa(TipoPessoa.JURIDICA);
            entidade.setCnpjCpf(contribuinte.getCNPJ());
        } else {
            entidade.setTipoPessoa(TipoPessoa.FISICA);
            entidade.setCnpjCpf(contribuinte.getCPF());
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getIE())) {
            entidade.setInscricaoEstadual(contribuinte.getIE());
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getCEP())) {
            entidade.getEndereco().setCep(contribuinte.getCEP());
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getEndereco())) {
            entidade.getEndereco().setEndereco(contribuinte.getEndereco());
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getNumero()) && !contribuinte.getNumero().equalsIgnoreCase("NAO INFORMADO")) {
            entidade.getEndereco().setNumero(contribuinte.getNumero());
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getComplemento())) {
            entidade.getEndereco().setComplemento(contribuinte.getComplemento());
        }
        if (!Util.stringNullOrEmpty((String)contribuinte.getBairro())) {
            entidade.getEndereco().setBairro(contribuinte.getBairro());
        }
        entidade.setNascimento(DataHoraFactory.string2LocalDate((String)contribuinte.getDataFundacao(), (String)"yyyy-MM-dd"));
        Estado estado = (Estado)EstadoRN.getInstance().buscarPorCodigo(contribuinte.getUF());
        if (estado != null) {
            entidade.getEndereco().setIdEstado(estado.getId());
            Cidade cidade = CidadeRN.getInstance().buscarPorNomeIgual(contribuinte.getMunicipio(), estado.getId());
            if (cidade == null) {
                Cep cep;
                cidade = CidadeRN.getInstance().buscarPorNomeSemAcento(contribuinte.getMunicipio(), estado.getId());
                if (cidade == null) {
                    Long codigoIBGE = null;
                    if (!Util.stringNullOrEmpty((String)contribuinte.getCodigoMunicipio())) {
                        codigoIBGE = Util.string2Long((String)contribuinte.getCodigoMunicipio());
                    } else {
                        ConsultaCidadeIBGE consultaCidadeIBGE = new ConsultaCidadeIBGE();
                        Long codigoIBGEAux = consultaCidadeIBGE.consultarCodigoIBGE(estado.getCodigoIbge(), contribuinte.getMunicipio());
                        if (!Util.longNullOuZero((Long)codigoIBGEAux)) {
                            codigoIBGE = codigoIBGEAux;
                        }
                    }
                    if (!NumberUtil.longNullOuZero((Long)codigoIBGE) && (cidade = CidadeRN.getInstance().buscarPorCodigoIBGE(codigoIBGE)) == null) {
                        cidade = CidadeCommonRN.getInstance().cadastraNovaCidade(codigoIBGE, Util.removerAcentos((String)contribuinte.getMunicipio()), estado.getId(), SessaoUtil.getSessao());
                    }
                }
                if (cidade == null && (cep = CepRN.getInstance().buscarPorCep(SessaoUtil.getSessao(), contribuinte.getCEP())) != null) {
                    cidade = (Cidade)CidadeRN.getInstance().buscarPorId(cep.getIdCidade());
                }
            }
            if (cidade != null) {
                entidade.getEndereco().setIdCidade(cidade.getId());
            }
        }
        entidade.setEnderecoCobranca(entidade.getEndereco());
        entidade.setEnderecoEntrega(entidade.getEndereco());
        entidade.setEmail(contribuinte.getEmail());
        entidade.setTelefone(contribuinte.getTelefone());
        entidade.setInativo(contribuinte.isInativo());
        return entidade;
    }

    @RequestMapping(value={"/tipos-email"})
    @DBAutoCommit
    public CompartilhamentoEntidadeDTO getTiposEmailPossiveis(@RequestParam Long idEntidade) {
        HashMap<TipoEmailEntidade, String> tipos = new HashMap<TipoEmailEntidade, String>();
        Entidade entidade = (Entidade)((EntidadeRN)this.rn).buscarPorId(idEntidade);
        if (entidade != null) {
            if (!StringUtil.stringNullOrEmpty((String)entidade.getEmail())) {
                tipos.put(TipoEmailEntidade.PRINCIPAL, entidade.getEmail());
            }
            if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailFaturamento())) {
                tipos.put(TipoEmailEntidade.FATURAMENTO, entidade.getEmailFaturamento());
            }
            if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailFaturamentoCopia())) {
                tipos.put(TipoEmailEntidade.FATURAMENTO_COPIA, entidade.getEmailFaturamentoCopia());
            }
            if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailFinanceiro())) {
                tipos.put(TipoEmailEntidade.FINANCEIRO, entidade.getEmailFinanceiro());
            }
            if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailTecnico())) {
                tipos.put(TipoEmailEntidade.TECNICO, entidade.getEmailTecnico());
            }
            if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailCotacao())) {
                tipos.put(TipoEmailEntidade.COTACAO, entidade.getEmailCotacao());
            }
            if (!StringUtil.stringNullOrEmpty((String)entidade.getEmailComprador())) {
                tipos.put(TipoEmailEntidade.COMPRADOR, entidade.getEmailComprador());
            }
            return new CompartilhamentoEntidadeDTO(tipos, entidade.getNumeroEnvioWhatsapp());
        }
        return null;
    }

    @RequestMapping(value={"/email-transportadora"})
    @DBAutoCommit
    public String getEmailTransportadora(@RequestParam Long idTransportadora) {
        return ((EntidadeRN)this.rn).buscarEmailTransportadoraWeb(idTransportadora);
    }

    @RequestMapping(value={"/por-tipo"})
    @DBAutoCommit
    public List<EntidadeDTO> buscarEntidadesAutoComplete(@RequestParam(value="filial", required=false) boolean filtrarFilial, @RequestParam(value="inativo", required=false) boolean exibirInativos, @RequestParam(value="query", required=false) String textoPesquisado, @RequestParam(value="limite", required=false, defaultValue="6") Integer limite, @RequestParam(value="ids", required=false) List<Long> ids, @RequestParam(value="filtrarRevendaIntelidata", required=false) boolean filtrarRevendaIntelidata, @RequestParam(required=false) Long idVendedor, @RequestParam(required=false, defaultValue="true") boolean considerarPreferenciaFiltroPorFilial, TipoEntidade ... tiposEntidades) {
        List entidades = EntidadeRN.getInstance().buscaDadosSelectComboWeb(SessaoUtil.getSessao(), false, filtrarFilial, exibirInativos, limite.intValue(), textoPesquisado, ids, filtrarRevendaIntelidata, idVendedor, considerarPreferenciaFiltroPorFilial, tiposEntidades);
        return entidades.stream().map(entidade -> {
            EntidadeDTO dto = new EntidadeDTO();
            BeanUtil.copiarValores((Object)entidade, (Object)dto, (boolean)false, (boolean)true, null);
            return dto;
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/dto-por-id/{id}"})
    @DBAutoCommit
    public EntidadeDTO buscarEntidadeDTOPorId(@PathVariable Long id) {
        List entidades = EntidadeRN.getInstance().buscaDadosSelectComboWeb(SessaoUtil.getSessao(), false, false, true, 0, null, Collections.singletonList(id), false, null, true, new TipoEntidade[0]);
        if (!ListMapUtil.listNullOrEmpty((List)entidades)) {
            return (EntidadeDTO)entidades.stream().map(entidade -> {
                EntidadeDTO dto = new EntidadeDTO();
                BeanUtil.copiarValores((Object)entidade, (Object)dto, (boolean)false, (boolean)true, null);
                return dto;
            }).collect(Collectors.toList()).get(0);
        }
        return null;
    }

    @RequestMapping(value={"/buscar-por-grupo-fornecedor"})
    @DBAutoCommit
    public List<EntidadeDTO> buscarPorIdGrupoFornecedor(@RequestParam Long idGrupoFornecedor) {
        List entidades = EntidadeRN.getInstance().buscarFornecedoresDoGrupoDeFornecedor(idGrupoFornecedor);
        if (!ListMapUtil.listNullOrEmpty((List)entidades)) {
            return entidades.stream().map(entidade -> {
                EntidadeDTO dto = new EntidadeDTO();
                BeanUtil.copiarValores((Object)entidade, (Object)dto, (boolean)false, (boolean)true, null);
                if (entidade.getEndereco() != null && !Util.longNullOuZero((Long)entidade.getEndereco().getIdEstado())) {
                    dto.setEstado(EstadoRN.getInstance().buscarValorPorID(entidade.getEndereco().getIdEstado(), "codigo") + "");
                }
                return dto;
            }).collect(Collectors.toList());
        }
        return new ArrayList<EntidadeDTO>();
    }

    @RequestMapping(value={"/entidade-financeiro/{id}"})
    @DBAutoCommit
    public Entidade buscarEntidadeFinanceiroPorId(@PathVariable Long id) {
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(id);
        if (entidade != null) {
            Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(entidade.getEndereco().getIdEstado());
            if (estado != null) {
                entidade.setCodigoEstado(estado.getCodigo());
            }
            return entidade;
        }
        return null;
    }

    @RequestMapping(value={"/validar-inativa"})
    @DBAutoCommit
    public void validarInativo(@RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        if (EntidadeRN.getInstance().entidadeInativa(idEntidade)) {
            throw new UnicoMensagemUsuarioException("COM236605", "N\u00e3o \u00e9 possivel selecionar o " + this.tipoEntidade.getDescricao().toLowerCase() + " porque o mesmo est\u00e1 inativo");
        }
    }

    @RequestMapping(value={"/validar-cpfcnpj-duplicado"})
    @DBAutoCommit
    public boolean cpfCnpjDuplicado(@RequestParam String value, @RequestParam(required=false) String codigo) {
        return EntidadeRN.getInstance().isCnpjCpfCadastrado(value, codigo);
    }

    @RequestMapping(value={"/validar-ie"})
    @DBAutoCommit
    public boolean validarInscricaoEstadual(@RequestParam String value, @RequestParam(required=false) Long idEstado, @RequestParam(required=false) String codigo, @RequestParam boolean permitirIsento, @RequestParam(required=false, value="true") boolean validarIEDuplicada) throws UnicoMensagemUsuarioException {
        Estado estado;
        if (!(NumberUtil.longNullOuZero((Long)idEstado) || (estado = (Estado)EstadoRN.getInstance().buscarPorId(idEstado)) == null || estado.getCodigo().trim().isEmpty() || StringUtil.validaIE((String)value, (String)estado.getCodigo(), (boolean)permitirIsento))) {
            throw new UnicoMensagemUsuarioException("WENT19", "Inscri\u00e7\u00e3o estadual inv\u00e1lida");
        }
        boolean permiteDuplicado = PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getFilial(), 593);
        if (!permiteDuplicado && validarIEDuplicada && EntidadeRN.getInstance().isInscricaoEstadualCadastrado(value, codigo)) {
            throw new UnicoMensagemUsuarioException("WENT58", " Essa Inscri\u00e7\u00e3o Estadual j\u00e1 foi cadastrada");
        }
        return true;
    }

    public String getDescricaoTabela() {
        return this.tipoEntidade != null ? this.tipoEntidade.getTituloPlural() : null;
    }

    public Extras getCampoExtra(String nome, String tabela) {
        if (tabela.equals(EntidadeRN.getInstance().getTabela()) && this.tipoEntidade != null) {
            return ExtrasRN.getInstance().buscarPorNomeTabela(this.tipoEntidade.getTabelaExtra());
        }
        return null;
    }

    protected void beforeCreate(Entidade entidade, Optional<Long> parentId) {
        entidade.setDataCadastro(DataHoraFactory.getData());
        entidade.setDataHoraInclusao(DataHoraFactory.getDataHora());
        Entidade ent = (Entidade)EntidadeRN.getInstance().buscarPorCodigo(entidade.getCodigo());
        if (ent != null) {
            String novoCodigo = EntidadeRN.getInstance().getCodigoUnico(Contexto.getInstance().getSessao(), (Object)entidade.getCodigo());
            entidade.setCodigo(novoCodigo);
        }
    }

    protected void beforeRead(Entidade entidade, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        EntidadeContaContabil entidadeContaContabil;
        if (!StringUtil.stringNullOrEmpty((String)entidade.getCaminhoImagem())) {
            entidade.setCaminhoImagem(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.Pequena, entidade.getCaminhoImagem()));
        }
        if ((TipoEntidade.CLIENTE.equals((Object)this.tipoEntidade) || TipoEntidade.FORNECEDOR.equals((Object)this.tipoEntidade) && (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.INTEGRACAO_COM_CONTABILIDADE) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_CONTRIBUICOES_CONTA_CONTABIL) || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SPED_FISCAL_CONTA_CONTABIL))) && (entidadeContaContabil = EntidadeContaContabilRN.getInstance().buscarPorEntidade(entidade.getId(), SessaoUtil.getSessao().getFilial().getIdEmpresa())) != null) {
            entidade.setIdContaContabilIntegracao(TipoEntidade.CLIENTE.equals((Object)this.tipoEntidade) ? entidadeContaContabil.getIdContaContabil() : entidadeContaContabil.getIdContaContabilFornecedor());
            entidade.setCadastroCliente(TipoEntidade.CLIENTE.equals((Object)this.tipoEntidade));
        }
        entidade.setEnderecosAdicionais(EntidadeEnderecoAdicionalRN.getInstance().buscarPorIdEntidade(entidade.getId()));
        if (!StringUtil.stringNullOrEmpty((String)entidade.getWhatsapp())) {
            String whats = Util.apenasNumeros((String)entidade.getWhatsapp());
            if (whats.length() == 12) {
                entidade.setTipoWhatsapp(TipoWhatsapp.DIGITOS_9);
            } else if (whats.length() == 11) {
                entidade.setTipoWhatsapp(TipoWhatsapp.DIGITOS_8);
            }
        }
    }

    protected void beforeUpdate(Entidade entidade, Optional<Long> parentId) {
        entidade.setDataHoraAlteracao(DataHoraFactory.getDataHora());
        String caminhoOriginal = EntidadeRN.getInstance().getCaminhoImagemWeb(entidade.getId());
        if (!StringUtil.stringNullOrEmpty((String)caminhoOriginal)) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, TipoImagem.Pequena, caminhoOriginal);
            if (StringUtil.stringNullOrEmpty((String)entidade.getCaminhoImagem()) || !entidade.getCaminhoImagem().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, caminhoOriginal);
            } else {
                entidade.setCaminhoImagem(caminhoOriginal);
            }
        }
    }

    protected void beforeDelete(Entidade entidade) {
        if (!StringUtil.stringNullOrEmpty((String)entidade.getCaminhoImagem())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Entidade, entidade.getCaminhoImagem());
        }
    }

    protected void beforeSave(Entidade entidade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(entidade.getEndereco().getIdEstado());
        if (estado != null && estado.getCodigo().equalsIgnoreCase("EX")) {
            entidade.setTipoContribuinte(TipoContribuinte.NAO_CONTRIBUINTE);
        }
    }

    protected GridBuilder<EntidadeRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("celular", "Celular", 0, false));
        colunas.add(new ColunaSQL("whatsapp", "WhatsApp", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("nome", "Nome", 250, true));
        colunas.add(new ColunaSQL("tipoPessoa", "Tipo pessoa", 120, true, TipoPessoa.class));
        colunas.add(new ColunaSQL("razaoSocial", "Raz\u00e3o social", 250, true));
        colunas.add(new ColunaSQL("cnpjCpf", "CNPJ/CPF", 150, true));
        colunas.add(new ColunaSQL("nome", "nomeEstado", "Estado", 150, true, new String[]{"fk_entidade_estado"}));
        colunas.add(new ColunaSQL("nome", "nomeCidade", "Cidade", 150, true, new String[]{"fk_entidade_cidade"}));
        colunas.add(new ColunaSQL("telefone", "Telefone", 100, true));
        colunas.add(new ColunaSQL("inativo", "Inativo", 100, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("pautapreco", "Pauta preco", 100, false));
        ColunaSQL tipoRevenda = new ColunaSQL("tiporevenda", "TipoRevenda", 0, false, TipoEntidadeRevenda.class);
        tipoRevenda.setAlias("tipoRevendaFixo");
        colunas.add(tipoRevenda);
        GridBuilder gridBuilder = new GridBuilder(EntidadeRN.getInstance().getTabela(), colunas, this.tipoEntidade != null ? this.tipoEntidade.getTabelaExtra() : null);
        if (this.tipoEntidade != null) {
            String descricaoTipo = this.tipoEntidade.getCampo();
            gridBuilder.addCodicaoDefault(new Condicao(descricaoTipo, Operador.IGUAL, 1));
            gridBuilder.addReferenciaDefault(new Referencia(descricaoTipo, descricaoTipo));
        }
        gridBuilder.addReferenciaDefault(new Referencia("inativo", "entidadeInativa"));
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            gridBuilder.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPautaPreco(SessaoUtil.getSessao()));
        }
        return gridBuilder;
    }

    protected String getCacheId() {
        return "entidades".concat("_").concat(this.tipoEntidade != null ? this.tipoEntidade.name() : "");
    }

    public List<Coluna> getColunasCustomizaveis() {
        return EntidadeRN.getInstance().getColunaGridCustomozaveisWW(this.tipoEntidade);
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        Optional<ColunaSQL> filter = colunas.stream().filter(colunaSQL -> colunaSQL.getAlias().equals("valorUltimaCompra") || colunaSQL.getAlias().equals("valorPrimeiraCompra") || colunaSQL.getAlias().equals("dataPrimeiraCompra") || colunaSQL.getAlias().equals("dataUltCompra")).findFirst();
        if (filter.isPresent()) {
            dados.forEach(dado -> {
                int idxDataUltCompra;
                int idxDataPrimeiraCompra;
                int idxValorPrimeiraCompra;
                int idxID = this.getIndexColuna("id", colunas);
                int idxValorUltimaCompra = this.getIndexColuna("valorUltimaCompra", colunas);
                if (idxValorUltimaCompra > -1 && StringUtil.stringNullOrEmpty((String)((String)dado[idxValorUltimaCompra]))) {
                    dado[idxValorUltimaCompra] = ((EntidadeRN)this.rn).buscarDataValorCompraCliente((Long)dado[idxID], TipoRetornoDataValorCompraCliente.VALOR_ULTIMA_COMPRA);
                }
                if ((idxValorPrimeiraCompra = this.getIndexColuna("valorPrimeiraCompra", colunas)) > -1 && StringUtil.stringNullOrEmpty((String)((String)dado[idxValorPrimeiraCompra]))) {
                    dado[idxValorPrimeiraCompra] = ((EntidadeRN)this.rn).buscarDataValorCompraCliente((Long)dado[idxID], TipoRetornoDataValorCompraCliente.VALOR_PRIMEIRA_COMPRA);
                }
                if ((idxDataPrimeiraCompra = this.getIndexColuna("dataPrimeiraCompra", colunas)) > -1 && StringUtil.stringNullOrEmpty((String)((String)dado[idxDataPrimeiraCompra]))) {
                    dado[idxDataPrimeiraCompra] = ((EntidadeRN)this.rn).buscarDataValorCompraCliente((Long)dado[idxID], TipoRetornoDataValorCompraCliente.DATA_PRIMEIRA_COMPRA);
                }
                if ((idxDataUltCompra = this.getIndexColuna("dataUltCompra", colunas)) > -1 && StringUtil.stringNullOrEmpty((String)((String)dado[idxDataUltCompra]))) {
                    dado[idxDataUltCompra] = ((EntidadeRN)this.rn).buscarDataValorCompraCliente((Long)dado[idxID], TipoRetornoDataValorCompraCliente.DATA_ULTIMA_COMPRA);
                }
            });
        }
    }

    @RequestMapping(value={"/produtos-comprados"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> getRelatorioProdutosComprados(@RequestBody Long idEntidade) throws UnicoMensagemUsuarioException {
        Remessa remessa = new VendasProdutoRelatorio().getRelatorio(DataHoraFactory.of((int)1900, (int)1, (int)1), DataHoraFactory.getData(), idEntidade);
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"Produtos Comprados");
    }

    @RequestMapping(value={"/autorizacao-dependentes"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> getRelatorioAutorizacaoDependentes(@RequestBody Long idEntidade) throws UnicoMensagemUsuarioException {
        Remessa remessa = new AutorizacaoDependentesRelatorio().getRelatorio(SessaoUtil.getSessao(), idEntidade.longValue());
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"Autorizacao Dependentes");
    }

    @RequestMapping(value={"/validar-cliente"})
    @DBAutoCommit
    public void validarCliente(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        Entidade entidade;
        Sessao sessao = SessaoUtil.getSessao();
        ComportamentoClienteAtrasoVendas comportamentoClienteAtrasoVendas = (ComportamentoClienteAtrasoVendas)PropriedadeRN.getInstance().getPropriedadeEnum(sessao.getFilial(), 817);
        if (comportamentoClienteAtrasoVendas != null && comportamentoClienteAtrasoVendas.in(new AbstractEnum[]{ComportamentoClienteAtrasoVendas.AVISAR_E_PERGUNTAR, ComportamentoClienteAtrasoVendas.BLOQUEAR}) && (entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(id)) != null && !EntidadeRN.getInstance().isLiberaVendaClienteAtrasado(entidade) && EntidadeRN.getInstance().isEntidadeBloqueadaPorAtraso(sessao, entidade.getId())) {
            throw new UnicoMensagemUsuarioException("DAF133", "Este cliente possui documentos em atraso! Imposs\u00edvel continuar.");
        }
        EntidadeCommonRN.getInstance().permiteVender(sessao, id, true, false);
    }

    @PostMapping(value={"/enviar-email"})
    @DBAutoCommit
    public void enviarEmail(@RequestBody EntidadeEmailWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (wrapper.getFiltroGrid() != null) {
            wrapper.setIdsEntidades(this.getListaIDs(wrapper.getFiltroGrid().getQuery(), wrapper.getFiltroGrid().getFilter()));
        }
        1 iCreateTask = new /* Unavailable Anonymous Inner Class!! */;
        iCreateTask.createTask((Object)wrapper, "Ids entidades ".concat(wrapper.getIdsEntidades().stream().map(Object::toString).collect(Collectors.joining(","))));
    }

    @PostMapping(value={"/enviar-whatsapp"})
    @DBAutoCommit
    public Map<String, String> enviarWhatsapp(@RequestBody EntidadeEmailWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (wrapper.getFiltroGrid() != null) {
            wrapper.setIdsEntidades(this.getListaIDs(wrapper.getFiltroGrid().getQuery(), wrapper.getFiltroGrid().getFilter()));
        }
        Sessao sessao = SessaoUtil.getSessao();
        ConfiguracaoWhatsApp configuracaoWhatsApp = ConfiguracaoWhatsAppRN.getInstance().buscaConfiguracaoUsuario(sessao);
        if (configuracaoWhatsApp != null) {
            if (configuracaoWhatsApp.getTipoIntegracao().equals((Object)TipoIntegracaoWhatsAppEnum.PADRAO) && wrapper.getIdsEntidades().size() > 1) {
                throw new UnicoMensagemUsuarioException("WWW111", "N\u00e3o \u00e9 poss\u00edvel enviar o WhatsApp para mais de um cliente.");
            }
            TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(wrapper.getIdTextoGenerico());
            String mensagemOriginal = textoGenerico.getTexto();
            if (mensagemOriginal == null) {
                throw new UnicoMensagemUsuarioException("WWW112", "Texto gen\u00e9rico selecionado n\u00e3o possui um texto cadastrado.");
            }
            Filial filial = sessao.getFilial();
            ArrayList<Notificacao> notificacoes = new ArrayList<Notificacao>();
            for (Long idEntidade : wrapper.getIdsEntidades()) {
                String mensagem = mensagemOriginal.replace(VariavelTextoGenerico.RAZAO_SOCIAL.getId(), filial.getRazaoSocialCompleta());
                mensagem = mensagem.replace(VariavelTextoGenerico.CNPJ_EMPRESA.getId(), filial.getCnpj());
                mensagem = mensagem.replace(VariavelTextoGenerico.DATA_ATUAL.getId(), Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd/MM/yyyy"));
                Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
                if (Util.stringNullOrEmpty((String)Util.apenasNumeros((String)entidade.getNumeroEnvioWhatsapp()))) continue;
                mensagem = mensagem.replace(VariavelTextoGenerico.RAZAO_SOCIAL_ANIVERSARIANTE.getId(), entidade.getRazaoSocial());
                mensagem = mensagem.replace(VariavelTextoGenerico.NOME_ANIVERSARIANTE.getId(), entidade.getNome());
                Notificacao notificacao = new Notificacao();
                notificacao.setFone(entidade.getNumeroEnvioWhatsapp());
                notificacao.setMsg(mensagem);
                notificacoes.add(notificacao);
            }
            if (notificacoes.isEmpty()) {
                throw new UnicoMensagemUsuarioException("WWW113", "Nenhum cliente com n\u00famero de WhatsApp. Verifique.");
            }
            if (configuracaoWhatsApp.getTipoIntegracao().equals((Object)TipoIntegracaoWhatsAppEnum.PADRAO)) {
                HashMap<String, String> resultado = new HashMap<String, String>();
                resultado.put("whatsapp", ((Notificacao)notificacoes.get(0)).getFone());
                resultado.put("mensagem", this.whatsAppService.enviarWhatsApp(notificacoes, sessao));
                return resultado;
            }
            this.whatsAppService.enviarWhatsApp(notificacoes, sessao);
        }
        return null;
    }

    @RequestMapping(value={"/buscar-aniversariantes-do-dia"})
    @DBAutoCommit
    public List<Map<String, Object>> buscarAniversariantesDoDia() {
        return EntidadeRN.getInstance().buscarAniversariantesDoDia();
    }

    @RequestMapping(value={"/endereco-adicional"})
    @DBAutoCommit
    public List<EntidadeEnderecoAdicional> buscarEnderecosAdicionais(@RequestParam Long idEntidade) {
        return EntidadeEnderecoAdicionalRN.getInstance().buscarPorIdEntidade(idEntidade);
    }

    @RequestMapping(value={"/codigo-cartao-fidelidade"})
    @DBAutoCommit
    public String gerarCodigoCartaoFidelidade() throws UnicoMensagemUsuarioException {
        return CartaoFidelidadeConfiguracaoRN.getInstance().geraCodigoCartaoFidelidade(SessaoUtil.getSessao(), 1).stream().findFirst().orElse("");
    }

    @RequestMapping(value={"/cadastrar-senha"})
    @DBAutoCommit
    public void cadastrarSenha(@RequestParam Long idCliente, @RequestParam String senha, @RequestParam boolean excluir) throws UnicoMensagemUsuarioException {
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        if (excluir) {
            cliente.setSenhaCartaoFidelidade("");
        } else {
            cliente.setSenhaCartaoFidelidade(BCrypt.hashpw((String)senha, (String)BCrypt.gensalt()));
        }
        EntidadeRN.getInstance().alterar((AbstractPojo)cliente, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/verificar-senha"})
    @DBAutoCommit
    public boolean verificaSePossuiSenha(@RequestParam Long idCliente) throws UnicoMensagemUsuarioException {
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        return !Util.stringNullOrEmpty((String)cliente.getSenhaCartaoFidelidade());
    }

    @RequestMapping(value={"/promocoes-cliente"})
    @DBAutoCommit
    public List<Promocao> buscarListaPromocaoPorCliente(@RequestParam Long idEntidade) {
        return PromocaoRN.getInstance().buscarPromocaoScanntechPorCliente(idEntidade);
    }

    @RequestMapping(value={"/visualizar-limite-credito"})
    @DBAutoCommit
    public LimiteCreditoWrapper buscarLimiteCredito(@RequestParam Long idEntidade) {
        return LimiteCreditoRN.getInstance().buscaLimiteCreditoExibicao(SessaoUtil.getSessao(), idEntidade);
    }

    static /* synthetic */ TaskManager access$000(EntidadeCrudController x0) {
        return x0.taskManager;
    }
}

