/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.util.BCrypt;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.CartaoFidelidadeConfiguracao;
import br.intelidata.commons.domain.pojo.ConfiguracoesAdicionaisEntidade;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.TipoEntidade;
import br.intelidata.commons.domain.pojo.vendas.CargaDocumentoHistoricoEntrega;
import br.intelidata.commons.domain.regranegocio.CartaoFidelidadeConfiguracaoCommonRN;
import br.intelidata.commons.modulo.entidade.regranegocio.CartaoClienteRN;
import br.intelidata.commons.modulo.entidade.regranegocio.CartaoFidelidadeConfiguracaoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDependenteRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.CargaDocumentoHistoricoEntregaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.EntidadeCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.EntidadeEtiquetaWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="cad_cliente", QUANTIDADE=QuantidadeCampoExtra.ENTIDADE)
@RestController
@RequestMapping(value={"/api/clientes"})
@SubMenuMapping(MENU="SubMenuCadastroGeral", NOME="Clientes", ICONE="icon-cliente", ROTA="/entidades/clientes", PROGRAMA=2)
public class ClienteCrudController
extends EntidadeCrudController {
    private final ModuloService moduloService;
    private final FuncionalidadeService funcionalidade;

    @Autowired
    public ClienteCrudController(ModuloService moduloService, FuncionalidadeService funcionalidade) {
        super(TipoEntidade.CLIENTE);
        this.moduloService = moduloService;
        this.funcionalidade = funcionalidade;
    }

    @RequestMapping(value={"/historico-entregas"})
    @DBAutoCommit
    public List<CargaDocumentoHistoricoEntrega> buscarHistoricoEntrega(@RequestParam Long idEntidade) {
        return CargaDocumentoHistoricoEntregaRN.getInstance().buscarListaDadosPorCliente(idEntidade);
    }

    @RequestMapping(value={"/consultar-contribuinte"})
    @DBAutoCommit
    public Entidade consultarContribuinte(@RequestBody Entidade entidade, @RequestParam String cnpj, @RequestParam(required=false) String uf) throws UnicoMensagemUsuarioException {
        Entidade entidadeConsultada = super.consultarContribuinte(entidade, cnpj, uf);
        this.carregarDadosAdicionais(entidadeConsultada);
        return entidadeConsultada;
    }

    @RequestMapping(value={"/montar-dados-etiqueta"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EntidadeEtiquetaWrapper> montarDadosEtiquetaMalDireta(@RequestBody List<Long> ids) {
        return ids.stream().distinct().map(id -> (Entidade)EntidadeRN.getInstance().buscarPorId(id)).filter(Objects::nonNull).map(EntidadeEtiquetaWrapper::new).collect(Collectors.toList());
    }

    protected void beforeSave(Entidade entidade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave(entidade, parentId);
        if (!StringUtil.stringNullOrEmpty((String)entidade.getSenhaCartaoFidelidade()) && !CartaoFidelidadeConfiguracaoCommonRN.getInstance().sistemaGeraNumeroCartao()) {
            entidade.setSenhaCartaoFidelidade(BCrypt.hashpw((String)entidade.getSenhaCartaoFidelidade(), (String)BCrypt.gensalt()));
        }
        if (!this.funcionalidade.isAtiva(Funcionalidade.HISTORICO_BLOQUEIO_CLIENTE)) {
            entidade.setCreditoRestrito(entidade.isBloquearCredito() ? EnumSimNao.SIM.getId() : EnumSimNao.NAO.getId());
        }
        if (!NumberUtil.longNullOuZero((Long)entidade.getId()) && this.funcionalidade.isAtiva(Funcionalidade.CARTAO_FIDELIDADE)) {
            List cartaoClientes = CartaoClienteRN.getInstance().buscarPorIdEntidade(entidade.getId());
            entidade.setCartaoCliente(cartaoClientes);
        }
    }

    protected void beforeRead(Entidade entidade, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead(entidade, modo, parentId);
        this.carregarDadosAdicionais(entidade);
        entidade.setBloquearCredito(entidade.getCreditoRestrito().equals(EnumSimNao.SIM.getId()));
    }

    private void carregarDadosAdicionais(Entidade entidade) {
        ConfiguracoesAdicionaisEntidade configuracoesAdicionaisEntidade = new ConfiguracoesAdicionaisEntidade();
        Entidade entidadeDependente = EntidadeDependenteRN.getInstance().getPaiDoDependente(entidade.getId());
        if (entidadeDependente != null) {
            HashMap<String, String> pai = new HashMap<String, String>();
            pai.put("pai", entidadeDependente.toString());
            pai.put("limite", entidadeDependente.getLimiteCredito().toString());
            configuracoesAdicionaisEntidade.setPaiDependente(pai);
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CARTAO_FIDELIDADE)) {
            CartaoFidelidadeConfiguracao cartaoFidelidadeConfiguracao = CartaoFidelidadeConfiguracaoRN.getInstance().buscar();
            configuracoesAdicionaisEntidade.setCartaoFidelidade(cartaoFidelidadeConfiguracao);
        }
        entidade.setConfiguracoesAdicionaisEntidade(configuracoesAdicionaisEntidade);
    }
}

