/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.cartaocliente;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.BCrypt;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.CartaoCliente;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CartaoClienteCommonRN;
import br.intelidata.commons.domain.regranegocio.CartaoFidelidadeConfiguracaoCommonRN;
import br.intelidata.commons.modulo.entidade.regranegocio.CartaoClienteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cartoes-cliente"})
public class CartaoClienteCrudController
extends CrudController<CartaoCliente, CartaoClienteRN> {
    public CartaoClienteCrudController() {
        super((AbstractRegraNegocio)CartaoClienteRN.getInstance(), CartaoCliente::new);
        this.dependsOn("idEntidade");
    }

    @RequestMapping(value={"/validar"})
    @DBAutoCommit
    public boolean validarCartao(@RequestParam String cartao, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        CartaoClienteCommonRN.getInstance().validaNumeroCartao(cartao, CartaoFidelidadeConfiguracaoCommonRN.getInstance().buscar());
        CartaoCliente cartaoCliente = CartaoClienteCommonRN.getInstance().buscarPorCartao(cartao);
        if (cartaoCliente != null && !cartaoCliente.getIdEntidade().equals(idEntidade)) {
            throw new UnicoMensagemUsuarioException("WENT49", "Cart\u00e3o j\u00e1 cadastrado para outro cliente.Verifique!");
        }
        return true;
    }

    protected void beforeSave(CartaoCliente cartaoCliente, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)cartaoCliente.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW55", "Entidade n\u00e3o informada.");
        }
        if (this.validarCartao(cartaoCliente.getCartao(), cartaoCliente.getIdEntidade())) {
            cartaoCliente.setDataEmissao(DataHoraFactory.getData());
        }
        if (cartaoCliente.isCadastrarSenha()) {
            cartaoCliente.setSenhaCartao(BCrypt.hashpw((String)cartaoCliente.getSenhaCartao(), (String)BCrypt.gensalt()));
        }
    }

    protected GridBuilder<CartaoClienteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("senhaCartao", "senhaCartao", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("dataEmissao", "Emiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("cartao", "Cart\u00e3o", 150, true));
        colunas.add(new ColunaSQL("status", "Status", 150, true));
        return new GridBuilder(CartaoClienteRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "cartoes-cliente";
    }
}

