/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.dependente;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.EntidadeDependente;
import br.intelidata.commons.domain.pojo.PojoDetailList;
import br.intelidata.commons.domain.pojo.enuns.GrauParentesco;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDependenteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dependentes-entidade"})
public class EntidadeDependenteCrudController
extends CrudController<EntidadeDependente, EntidadeDependenteRN> {
    private ResponseEntityService responseEntityService;

    @Autowired
    public EntidadeDependenteCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)EntidadeDependenteRN.getInstance(), EntidadeDependente::new, false);
        this.responseEntityService = responseEntityService;
        this.dependsOn("idEntidade");
    }

    @RequestMapping(value={"/buscar-pai"})
    @DBAutoCommit
    public ResponseEntity<String> buscarPaiDependente(@RequestParam Long idEntidade) {
        String json = "{";
        Entidade entidade = EntidadeDependenteRN.getInstance().getPaiDoDependente(idEntidade);
        if (entidade != null) {
            json = json + "\"pai\":".concat(JsonUtil.escapeQuote((String)entidade.toString())).concat(", \"limite\":").concat(entidade.getLimiteCredito().toString());
        }
        return this.responseEntityService.createJSONResponse(json.concat("}"));
    }

    @RequestMapping(value={"/existe-dependente"})
    @DBAutoCommit
    public boolean possuiDependentes(@RequestParam Long idEntidade) {
        return EntidadeDependenteRN.getInstance().entidadeTemDependentes(idEntidade);
    }

    protected void beforeSave(EntidadeDependente entidadeDependente, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)entidadeDependente.getIdEntidade()) || NumberUtil.longNullOuZero((Long)entidadeDependente.getIdDependente())) {
            throw new UnicoMensagemUsuarioException("WWW47", "Entidade e dependente precisam ser informados");
        }
        if (entidadeDependente.getIdDependente().equals(entidadeDependente.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WENT22", "Este cliente n\u00e3o pode ser dependente de si mesmo");
        }
        if (EntidadeDependenteRN.getInstance().entidadeTemDependentes(entidadeDependente.getIdDependente())) {
            throw new UnicoMensagemUsuarioException("WENT24", "Este cliente n\u00e3o pode ser um dependente por que j\u00e1 possui dependentes");
        }
        for (EntidadeDependente dep : this.buscarDependentes(entidadeDependente.getIdEntidade())) {
            if (!dep.getIdDependente().equals(entidadeDependente.getIdDependente()) || !NumberUtil.longNullOuZero((Long)entidadeDependente.getId()) && (NumberUtil.longNullOuZero((Long)entidadeDependente.getId()) || entidadeDependente.getId().equals(dep.getId()))) continue;
            throw new UnicoMensagemUsuarioException("WENT25", "Dependente " + dep + " j\u00e1 cadastrado");
        }
    }

    protected GridBuilder<EntidadeDependenteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("iddependente", "idDependente", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigoDependente", "Codigo", 150, true, new String[]{"fk_entidadedependente_dep"}));
        colunas.add(new ColunaSQL("nome", "nomeDependente", "Nome", 150, true, new String[]{"fk_entidadedependente_dep"}));
        colunas.add(new ColunaSQL("limitecredito", "limiteCredito", "Limite", 150, true, new String[]{"fk_entidadedependente_dep"}));
        colunas.add(new ColunaSQL("grauParentesco", "Grau", 150, true, GrauParentesco.class));
        return new GridBuilder(EntidadeDependenteRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "dependentes-entidade";
    }

    private PojoDetailList<EntidadeDependente> buscarDependentes(Long idEntidade) {
        return EntidadeDependenteRN.getInstance().buscarListaPorEntidade(idEntidade);
    }
}

