/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.cliente.notificacaoposvenda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.Coalesce;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ClienteSemVenda;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusNfce;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoOperacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notificacao-posvenda-cliente"})
public class NotificacaoPosVendaClienteController
extends CrudController<ClienteSemVenda, EntidadeRN> {
    public NotificacaoPosVendaClienteController() {
        super((AbstractRegraNegocio)EntidadeRN.getInstance(), ClienteSemVenda::new, true, false);
    }

    protected String getCacheId() {
        return "notificacao-posvenda-cliente";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "codigocliente", "C\u00f3digo", 0, false, new String[0]));
        colunas.add(new ColunaSQL("idRepresentante", "idRepresentante", 0, false));
        colunas.add(new ColunaSQL("idEstado", "idEstado", 0, false));
        colunas.add(new ColunaSQL("idCidade", "idCidade", 0, false));
        colunas.add(new ColunaSQL("bairro", "bairroFiltro", "bairroFiltro", 0, false, new String[0]));
        colunas.add(new ColunaSQL("inativo", "inativo", 0, false));
        colunas.add(new ColunaSQL("registradospc", "registradospc", 0, false));
        colunas.add(new ColunaSQL("nome", "nomeordem", "nomeordem", 0, false, new String[0]));
        colunas.add(new ColunaSQL("datacadastro", "datacadastro", 0, false));
        ColunaSQL colunaSQLDias = new ColunaSQL("diasInatividade", "diasInatividade", 0, false);
        colunaSQLDias.setVirtual(true);
        colunas.add(colunaSQLDias);
        ColunaSQL colunaSQLApenasComVendas = new ColunaSQL("apenasClientesVendas", "apenasClientesVendas", 0, false);
        colunaSQLApenasComVendas.setVirtual(true);
        colunas.add(colunaSQLApenasComVendas);
        USelect uSelectUltimaCompraNF = new USelect("notafiscal", "nfultimacompra");
        uSelectUltimaCompraNF.add(new ColunaSQL(Funcao.MAX, "emissao", "ultimacompranf", new Object[0]));
        uSelectUltimaCompraNF.add((ColunaSQL)new Referencia("identidade", "nfentidade"));
        uSelectUltimaCompraNF.add((ColunaSQL)new Referencia("tipodocumento"));
        uSelectUltimaCompraNF.add((ColunaSQL)new Referencia("status"));
        uSelectUltimaCompraNF.add((ColunaSQL)new Referencia("idfilial"));
        uSelectUltimaCompraNF.add((ColunaSQL)new Referencia("consideravenda", "consideravenda", new String[]{"fk_notafiscal_cfop"}));
        uSelectUltimaCompraNF.add((ColunaSQL)new Referencia("consideravenda", "consideravendaop", new String[]{"fk_notafiscal_operacaofiscal"}));
        uSelectUltimaCompraNF.add(new Condicao("nfentidade", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
        uSelectUltimaCompraNF.add(new Condicao(OperadorLogico.E));
        uSelectUltimaCompraNF.add(new Condicao(Separador.ABRE_PARENTESIS));
        uSelectUltimaCompraNF.add(new Condicao("consideravenda", Operador.IGUAL, EnumSimNao.SIM.getId().intValue()));
        uSelectUltimaCompraNF.add(new Condicao(OperadorLogico.OU));
        uSelectUltimaCompraNF.add(new Condicao("consideravendaop", Operador.IGUAL, EnumSimNao.SIM.getId().intValue()));
        uSelectUltimaCompraNF.add(new Condicao(Separador.FECHA_PARENTESIS));
        uSelectUltimaCompraNF.add(new Condicao("tipodocumento", Operador.IGUAL, TipoNotaFiscal.SAIDA.getId()));
        uSelectUltimaCompraNF.add(new Condicao("status", Operador.CONTIDO_EM, new Integer[]{StatusNotaFiscal.NORMAL.getId(), StatusNotaFiscal.NFE_AUTORIZADA.getId(), StatusNotaFiscal.NFSE_AUTORIZADA.getId()}));
        ColunaSQL colunaUltimaCompraNF = new ColunaSQL(uSelectUltimaCompraNF, "ultimacompranf", 50, false);
        colunaUltimaCompraNF.setNome("ultimacompranf");
        colunaUltimaCompraNF.setAlias("ultimacompranf");
        colunaUltimaCompraNF.setTipoDadoBase(TipoDadoBase.DATE);
        colunaUltimaCompraNF.setVirtual(true);
        colunas.add(colunaUltimaCompraNF);
        USelect uSelectUltimaCompraPDV = new USelect("operacao", "pdvultimacompra");
        uSelectUltimaCompraPDV.add(new ColunaSQL(Funcao.MAX, "data", "data", new Object[0]));
        uSelectUltimaCompraPDV.add((ColunaSQL)new Referencia("cliente"));
        uSelectUltimaCompraPDV.add((ColunaSQL)new Referencia("tipo"));
        uSelectUltimaCompraPDV.add((ColunaSQL)new Referencia("cancelado"));
        uSelectUltimaCompraPDV.add((ColunaSQL)new Referencia("filial"));
        uSelectUltimaCompraPDV.add((ColunaSQL)new Referencia(new Coalesce("statusnfce", "0"), "statusnfce"));
        uSelectUltimaCompraPDV.add(new Condicao("tipo", Operador.CONTIDO_EM, new Integer[]{TipoOperacao.VENDA.getId(), TipoOperacao.VENDA_MANUAL.getId()}));
        uSelectUltimaCompraPDV.add(new Condicao("cancelado", Operador.IGUAL, 0));
        uSelectUltimaCompraPDV.add(new Condicao("statusnfce", Operador.CONTIDO_EM, StatusNfce.getStatusAutorizadasRelatorio()));
        uSelectUltimaCompraPDV.add(new Condicao("cliente", Operador.IGUAL_REFERENCIA_EXTERNA, "codigocliente"));
        ColunaSQL colunaUltimaCompraPDV = new ColunaSQL(uSelectUltimaCompraPDV, "ultimacomprapdv", 50, false);
        colunaUltimaCompraPDV.setNome("ultimacomprapdv");
        colunaUltimaCompraPDV.setAlias("ultimacomprapdv");
        colunaUltimaCompraPDV.setTipoDadoBase(TipoDadoBase.DATE);
        colunaUltimaCompraPDV.setVirtual(true);
        colunas.add(colunaUltimaCompraPDV);
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("nome", "Nome", 250, true));
        ColunaSQL colunaSQLDataUltimaCompra = new ColunaSQL("dataUltimaCompra", "\u00daltima compra", 150, true);
        colunaSQLDataUltimaCompra.setVirtual(true);
        colunaSQLDataUltimaCompra.setTipoDadoBase(TipoDadoBase.DATE);
        colunaSQLDataUltimaCompra.setClasseValor(TipoDadoBase.DATE.getClasseJava());
        colunas.add(colunaSQLDataUltimaCompra);
        colunas.add(new ColunaSQL("telefone", "Telefone", 150, true));
        colunas.add(new ColunaSQL("celular", "Celular", 150, true));
        colunas.add(new ColunaSQL("whatsapp", "Whatsapp", 150, true));
        colunas.add(new ColunaSQL("email", "Email", 200, true));
        colunas.add(new ColunaSQL("nome", "vendedor", "Vendedor", 200, true, new String[]{"fk_entidade_representante"}));
        colunas.add(new ColunaSQL("endereco", "Endere\u00e7o", 0, true));
        colunas.add(new ColunaSQL("numeroendereco", "numeroEndereco", "N\u00famero", 120, true, new String[0]));
        colunas.add(new ColunaSQL("bairro", "Bairro", 150, true));
        colunas.add(new ColunaSQL("nome", "cidade", "Cidade", 120, true, new String[]{"fk_entidade_cidade"}));
        colunas.add(new ColunaSQL("codigo", "estado", "UF", 70, true, new String[]{"fk_entidade_estado"}));
        GridBuilder gridBuilder = new GridBuilder(EntidadeRN.getInstance().getTabela(), colunas, "grid_notificacao_cliente");
        gridBuilder.addReferenciaDefault(new Referencia("cliente"));
        gridBuilder.addCodicaoDefault(new Condicao("cliente", Operador.IGUAL, 1));
        gridBuilder.addOrdem(new Ordem("nomeordem"));
        return gridBuilder;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        int idxUltimaCompraNF = this.getIndexColuna("ultimacompranf", colunas);
        int idxUltimaCompraPDV = this.getIndexColuna("ultimacomprapdv", colunas);
        int idxDataCadastro = this.getIndexColuna("datacadastro", colunas);
        int idxUltimaCompra = this.getIndexColuna("dataUltimaCompra", colunas);
        int idxDiasInatividade = this.getIndexColuna("diasInatividade", colunas);
        int diasInatividade = 0;
        boolean apenasClientesVendas = false;
        Integer tipoOrdemDataUltimaCompra = null;
        for (FilterField filter : filters) {
            if (filter.getField().equalsIgnoreCase("diasInatividade")) {
                diasInatividade = Util.string2int((String)filter.getValue1());
                continue;
            }
            if (filter.getField().equalsIgnoreCase("apenasClientesVendas")) {
                apenasClientesVendas = Boolean.parseBoolean(filter.getValue1());
                continue;
            }
            if (!filter.getField().equalsIgnoreCase("dataUltimaCompra") || !filter.getType().equalsIgnoreCase("Ordem")) continue;
            if (filter.getValue1().equalsIgnoreCase("false")) {
                tipoOrdemDataUltimaCompra = 0;
                continue;
            }
            if (!filter.getValue1().equalsIgnoreCase("true")) continue;
            tipoOrdemDataUltimaCompra = 1;
        }
        for (Object[] registro : dados) {
            LocalDate ultimaCompraNF = DataHoraFactory.date2LocalDate((Object)registro[idxUltimaCompraNF]);
            LocalDate ultimaCompraPDV = DataHoraFactory.date2LocalDate((Object)registro[idxUltimaCompraPDV]);
            LocalDate dataCadastro = DataHoraFactory.date2LocalDate((Object)registro[idxDataCadastro]);
            LocalDate data = null;
            if (ultimaCompraNF != null || ultimaCompraPDV != null) {
                data = ultimaCompraNF != null && ultimaCompraPDV == null ? ultimaCompraNF : (ultimaCompraNF == null ? ultimaCompraPDV : (ultimaCompraNF.isAfter(ultimaCompraPDV) ? ultimaCompraNF : ultimaCompraPDV));
            }
            registro[idxUltimaCompra] = Util.formataDataHora((Temporal)data, (String)"dd/MM/yyyy");
            if (data == null) {
                data = dataCadastro;
            }
            if (data != null) {
                registro[idxDiasInatividade] = ChronoUnit.DAYS.between(data, DataHoraFactory.getData());
                continue;
            }
            registro[idxDiasInatividade] = 0L;
        }
        Iterator<Object[]> iterator = dados.iterator();
        while (iterator.hasNext()) {
            Object[] arr = iterator.next();
            if (apenasClientesVendas && Util.stringNullOrEmpty((String)((String)arr[idxUltimaCompra]))) {
                iterator.remove();
                continue;
            }
            if (diasInatividade > 0 && (Long)arr[idxDiasInatividade] <= (long)diasInatividade) {
                iterator.remove();
                continue;
            }
            if (!Util.stringNullOrEmpty((String)((String)arr[idxUltimaCompra]))) continue;
            LocalDate dataCadastro = DataHoraFactory.date2LocalDate((Object)arr[idxDataCadastro]);
            arr[idxUltimaCompra] = Util.formataDataHora((Temporal)dataCadastro, (String)"dd/MM/yyyy");
        }
        if (tipoOrdemDataUltimaCompra != null) {
            Integer finalTipoOrdemDataUltimaCompra = tipoOrdemDataUltimaCompra;
            dados.sort((o1, o2) -> {
                LocalDate dt1 = DataHoraFactory.string2LocalDate((String)o1[idxUltimaCompra].toString(), (String)"dd/MM/yyyy");
                LocalDate dt2 = DataHoraFactory.string2LocalDate((String)o2[idxUltimaCompra].toString(), (String)"dd/MM/yyyy");
                return finalTipoOrdemDataUltimaCompra == 0 ? Util.compararObjetos((Comparable)dt1, (Comparable)dt2) : Util.compararObjetos((Comparable)dt2, (Comparable)dt1);
            });
        }
        if (diasInatividade > 0) {
            PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 978, Integer.valueOf(diasInatividade));
        }
    }
}

