/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.contato;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.crm.EntidadeContato;
import br.intelidata.commons.domain.pojo.entidade.EntidadeContatoCotacaoGrupo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.crm.regranegocio.EntidadeContatoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeContatoCotacaoGrupoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidade-contatos"})
public class EntidadeContatoCrudController
extends CrudController<EntidadeContato, EntidadeContatoRN> {
    public EntidadeContatoCrudController() {
        super((AbstractRegraNegocio)EntidadeContatoRN.getInstance(), EntidadeContato::new, false);
        this.dependsOn("idEntidade");
    }

    protected void beforeSave(EntidadeContato contatoEntidade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)contatoEntidade.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW48", "Entidade n\u00e3o informada");
        }
    }

    protected GridBuilder<EntidadeContatoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("idTipoContato", "idTipoContato", 0, false));
        colunas.add(new ColunaSQL("cotacao", "Cota\u00e7\u00e3o", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("telefone", "Telefone", 0, true));
        colunas.add(new ColunaSQL("celular", "Celular", 0, true));
        colunas.add(new ColunaSQL("email", "E-mail", 0, true));
        colunas.add(new ColunaSQL("descricao", "tipoContato", "Tipo contato", 0, true, new String[]{"fk_entidadecontato_tipocontato"}));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(EntidadeContatoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("id"));
        return grid;
    }

    protected void afterSave(EntidadeContato entidadeContato, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        EntidadeContatoCotacaoGrupoRN.getInstance().excluirGruposDaEntidadeContato(SessaoUtil.getSessao(), entidadeContato.getId());
        if (!Util.listNullOrEmpty((List)entidadeContato.getIdsGrupos())) {
            EntidadeContatoCotacaoGrupoRN.getInstance().incluirGruposContatos(SessaoUtil.getSessao(), entidadeContato.getId(), entidadeContato.getIdsGrupos().stream().map(idGrupo -> new EntidadeContatoCotacaoGrupo(entidadeContato.getId(), idGrupo, null)).collect(Collectors.toList()));
        }
    }

    protected void afterDelete(EntidadeContato entidadeContato) throws UnicoMensagemUsuarioException {
        EntidadeContatoCotacaoGrupoRN.getInstance().excluirGruposDaEntidadeContato(SessaoUtil.getSessao(), entidadeContato.getId());
    }

    @RequestMapping(value={"/buscar-grupos-cotacao"})
    @DBTransaction
    public List<EntidadeContatoCotacaoGrupo> buscarListaIdsGrupos(@RequestParam Long idEntidadeContato) {
        return EntidadeContatoCotacaoGrupoRN.getInstance().buscarListaPorIdContatoCarregaNome(idEntidadeContato);
    }

    protected String getCacheId() {
        return "entidade-contatos";
    }
}

