/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.historicocontato;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.ContatoEntidade;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.ContatoEntidadeRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contatos-entidade"})
public class ContatoEntidadeCrudController
extends CrudController<ContatoEntidade, ContatoEntidadeRN> {
    public ContatoEntidadeCrudController() {
        super((AbstractRegraNegocio)ContatoEntidadeRN.getInstance(), ContatoEntidade::new, false);
        this.dependsOn("idEntidade");
    }

    protected void beforeSave(ContatoEntidade contatoEntidade, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)contatoEntidade.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW737", "Entidade n\u00e3o informada");
        }
        contatoEntidade.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
    }

    protected GridBuilder<ContatoEntidadeRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idEntidade", "idEntidade", 0, false));
        colunas.add(new ColunaSQL("idUsuario", "idUsuario", 0, false));
        colunas.add(new ColunaSQL("idTipoHistoricoContato", "idTipoHistoricoContato", 0, false));
        colunas.add(new ColunaSQL("dataHora", "datahora", 100, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 500, true));
        colunas.add(new ColunaSQL("descricao", "tipoHistorico", "Tipo", 150, true, new String[]{"fk_contatoentidade_tiphiscon"}));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usuario", 150, true, new String[]{"fk_contatoentidade_user"}));
        GridBuilder grid = new GridBuilder(ContatoEntidadeRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("dataHora", true));
        return grid;
    }

    protected String getCacheId() {
        return "contatos-entidade";
    }
}

