/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.entidade.representante.flex;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.Flex;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.r2d2rest.regranegocio.FlexRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/flex"})
@SubMenuMapping(MENU="", NOME="Flex", ROTA="/entidades/representantes/:idVendedor/flex", PROGRAMA=5, CUSTOM_ACTION=true)
public class FlexCrudController
extends CrudController<Flex, FlexRN> {
    public FlexCrudController() {
        super((AbstractRegraNegocio)FlexRN.getInstance(), Flex::new);
        this.dependsOn("idVendedor");
    }

    protected String getCacheId() {
        return "flex";
    }

    protected GridBuilder<FlexRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "nome", "Vendedor", 300, true, new String[]{"fk_flex_vendedor"}));
        colunas.add(new ColunaSQL("valor", "Valor Flex", 0, true));
        colunas.add(new ColunaSQL("porcMaxFlexPed", "% Max.Flex", 0, true));
        colunas.add(new ColunaSQL("porcMinFlexPed", "% Min. Flex", 0, true));
        colunas.add(new ColunaSQL("status", "Ativo", 0, true));
        colunas.add(new ColunaSQL("validade", "Validade", 0, true));
        colunas.add(new ColunaSQL("valor", "saldoFlex", "Saldo Flex", 0, true, new String[0]));
        GridBuilder grid = new GridBuilder(FlexRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("validade"));
        grid.addReferenciaDefault(new Referencia("idVendedor"));
        return grid;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(dado -> {
            int idxSaldo = this.getIndexColuna("saldoFlex", colunas);
            if (idxSaldo > -1) {
                Long idFlex = (Long)dado[this.getIndexColuna("id", colunas)];
                BigDecimal saldo = FlexRN.getInstance().buscarSaldoFlex(idFlex);
                saldo = saldo.add((BigDecimal)dado[this.getIndexColuna("valor", colunas)]);
                dado[idxSaldo] = saldo;
            }
        });
    }
}

