/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.eventosistema;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.domain.pojo.EventoSistema;
import br.intelidata.commons.domain.pojo.enuns.CategoriaEventoSistema;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.EventoSistemaRN;
import br.intelidata.commons.modulo.ferramentas.centralpendencias.enums.TipoEventoSistema;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.eventosistema.FiltroGridDataEvento;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/eventos-sistema"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliar", NOME="Eventos do sistema", ROTA="/ferramentas/eventos-sistema", PROGRAMA=516)
public class EventoSistemaCrudController
extends CrudController<EventoSistema, EventoSistemaRN> {
    @Autowired
    public EventoSistemaCrudController() {
        super((AbstractRegraNegocio)EventoSistemaRN.getInstance(), EventoSistema::new, true, true, false);
    }

    protected GridBuilder<EventoSistemaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idUsuario", "ID usu\u00e1rio", 0, false));
        colunas.add(new ColunaSQL("millis", "millis_number", "millis", 0, false, new String[0]));
        ColunaSQL colunaData = new ColunaSQL("millis", "data", "Data", 200, true, new String[0]);
        colunaData.setFuncao(Funcao.MILLIS_TO_DATE_TIME);
        colunaData.setTipoDadoBase(TipoDadoBase.DATETIME);
        colunaData.setClasseValor(LocalDateTime.class);
        colunaData.setTipoDadoBaseCustomizado(true);
        colunas.add(colunaData);
        ColunaSQL colunaCategoria = new ColunaSQL("categoria", "Categoria", 300, true);
        colunaCategoria.setClasseEnum(CategoriaEventoSistema.class);
        colunas.add(colunaCategoria);
        colunas.add(new ColunaSQL("descricao", "Descricao", 0, true));
        GridBuilder gridBuilder = new GridBuilder(EventoSistemaRN.getInstance().getTabela(), colunas);
        gridBuilder.addReferenciaDefault(new Referencia("tipoevento"));
        gridBuilder.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
        gridBuilder.addCodicaoDefault(new Condicao("tipoevento", Operador.CONTIDO_EM, new Integer[]{TipoEventoSistema.EVENTO.getId(), TipoEventoSistema.AMBOS.getId()}));
        gridBuilder.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        gridBuilder.addCodicaoDefault(new Condicao("tipoevento", Operador.IGUAL, Long.valueOf(0L)));
        gridBuilder.addCodicaoDefault(new Condicao(OperadorLogico.OU));
        gridBuilder.addCodicaoDefault(new Condicao("tipoevento", Operador.IS_NULL));
        gridBuilder.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
        gridBuilder.addOrdemDefault(new Ordem("data"));
        return gridBuilder;
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        super.prepareGrid();
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridDataEvento());
    }

    protected String getCacheId() {
        return "eventos-sistema";
    }
}

