/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.requisicaotransferencia;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.enuns.StatusRequisicaoTransferencia;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.transferencia.RequisicaoTransferencia;
import br.intelidata.commons.domain.pojo.transferencia.RequisicaoTransferenciaItem;
import br.intelidata.commons.modulo.compras.regranegocio.RequisicaoCompraRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.RequisicaoTransferenciaItemRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.RequisicaoTransferenciaRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.requisicaotransferencia.RequisicaoTransferenciaController;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.requisicaotransferencia.RequisicaoTransferenciaWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atendimentos-requisicao-transferencia"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Atendimento das requisi\u00e7\u00f5es de transfer\u00eancia", ROTA="/expedicoes/atendimentos-requisicao-transferencia", PROGRAMA=220, ICONE="icon-demonstracao")
public class AtendimentoRequisicaoTransferenciaCrudController
extends RequisicaoTransferenciaController {
    protected GridBuilder<RequisicaoTransferenciaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idFilial", "ID filial", 0, false));
        colunas.add(new ColunaSQL("codigo", "Requisi\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("nome", "usuario", "Usu\u00e1rio", 0, true, new String[]{"fk_requisicaotransf_usuario"}));
        colunas.add(new ColunaSQL("nome", "filial", "Filial requisitada", 0, true, new String[]{"fk_requisicaotransf_filreq"}));
        colunas.add(new ColunaSQL("dataEmissao", "Emiss\u00e3o", 150, true));
        GridBuilder grid = new GridBuilder(RequisicaoTransferenciaRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilialrequisitada"));
        grid.addCodicaoDefault(new Condicao("idfilialrequisitada", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.addReferenciaDefault(new Referencia("status", "status"));
        grid.addCodicaoDefault(new Condicao("status", Operador.DIFERENTE, StatusRequisicaoTransferencia.FATURADO.getId().intValue()));
        grid.addOrdem(new Ordem("dataEmissao"));
        return grid;
    }

    @RequestMapping(value={"/buscar-itens"})
    @DBAutoCommit
    public List<RequisicaoTransferenciaItem> carregarItens(@RequestParam Long[] idsRequisicoes, @RequestParam boolean isFaturamento) throws UnicoMensagemUsuarioException {
        ArrayList<RequisicaoTransferenciaItem> itens = new ArrayList<RequisicaoTransferenciaItem>();
        for (Long idRequisicao : idsRequisicoes) {
            RequisicaoTransferencia requisicao = (RequisicaoTransferencia)RequisicaoTransferenciaRN.getInstance().buscarPorId(idRequisicao);
            if (requisicao != null && requisicao.getStatus() != null) {
                if (isFaturamento && !requisicao.getStatus().isPodeFaturar()) {
                    throw new UnicoMensagemUsuarioException("WEXP45", "Requisi\u00e7\u00e3o " + requisicao.getCodigo() + " n\u00e3o pode mais ser faturada!");
                }
                if (!isFaturamento && !requisicao.getStatus().isPodeRequisitar()) {
                    throw new UnicoMensagemUsuarioException("WEXP46", "Requisi\u00e7\u00e3o " + requisicao.getCodigo() + " n\u00e3o pode mais ser requisitada!");
                }
            }
            itens.addAll(RequisicaoTransferenciaItemRN.getInstance().buscarListaPorIdRequisicaoTransferencia(SessaoUtil.getSessao(), idRequisicao, isFaturamento));
        }
        return itens;
    }

    @PostMapping(value={"/gerar-nota-fiscal"})
    @DBAutoCommit
    public NotaFiscal gerarNotaFiscalRequisicaoTransferencia(@RequestBody RequisicaoTransferenciaWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        List idsRequisicaoTransferencia = wrapper.getItens().stream().map(RequisicaoTransferenciaItem::getIdRequisicaoTransferencia).distinct().collect(Collectors.toList());
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().importarRequisicaoTransferencia(sessao, idsRequisicaoTransferencia, wrapper.getItens(), TipoNotaFiscal.SAIDA, wrapper.getIdOperacaoFiscal(), wrapper.getIdOperacaoFiscalEntradaAutomatica());
        notaFiscal.setTransferencia(true);
        notaFiscal.setTipoDocumento(TipoNotaFiscal.SAIDA);
        return notaFiscal;
    }

    @PostMapping(value={"/gerar-requisicao-compra"})
    @DBTransaction
    public void gerarRequisicaoCompra(@RequestBody RequisicaoTransferenciaWrapper wrapper) throws UnicoMensagemUsuarioException {
        RequisicaoCompraRN.getInstance().gerarRequisicaoCompraPorRequisicaoTrasnferencia(SessaoUtil.getSessao(), wrapper.getItens());
    }

    protected String getCacheId() {
        return "atendimentos-requisicao-transferencia".concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

