/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.requisicaotransferencia;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.ComplementoProdutoFilial;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.transferencia.RequisicaoTransferencia;
import br.intelidata.commons.domain.pojo.transferencia.RequisicaoTransferenciaItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.expedicao.regranegocio.RequisicaoTransferenciaItemRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.RequisicaoTransferenciaRN;
import br.intelidata.commons.modulo.produto.regranegocio.ComplementoProdutoFilialRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImpressaoCrudWrapper;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class RequisicaoTransferenciaController
extends CrudController<RequisicaoTransferencia, RequisicaoTransferenciaRN> {
    @Autowired
    public RequisicaoTransferenciaController() {
        super((AbstractRegraNegocio)RequisicaoTransferenciaRN.getInstance(), RequisicaoTransferencia::new, true, true, true);
    }

    protected void beforeRead(RequisicaoTransferencia requisicao, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List itens = RequisicaoTransferenciaItemRN.getInstance().buscarListaPorIdRequisicaoTransferencia(SessaoUtil.getSessao(), requisicao.getId(), false);
        if (itens != null) {
            for (RequisicaoTransferenciaItem item : itens) {
                Unidademedida unidade = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(item.getIdUnidadeMedida());
                if (unidade != null) {
                    item.setQuantidade(item.getQuantidade().setScale((int)unidade.getCasasdecimais(), RoundingMode.HALF_EVEN));
                    item.setDecimaisUnidadeMedida(unidade.getCasasdecimais().intValue());
                }
                if (!Util.stringNullOrEmpty((String)item.getDescricaoVariacoes())) continue;
                item.setDescricaoVariacoes(VariacaoRN.getInstance().getDescricaoPorVariacoesQuantidade(item.getIdProduto(), item.getVariacoes()));
            }
        }
        requisicao.setItens(itens);
    }

    @DBAutoCommit
    public EDIProcessado importarArquivoEdi(@RequestPart(value="file") MultipartFile file, @RequestParam Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ImportacaoDadosColetor importacaoDadosColetor = new ImportacaoDadosColetor(RequisicaoTransferenciaItem.class, idEdi, file);
        importacaoDadosColetor.importar();
        return importacaoDadosColetor.getEDIProcessado();
    }

    protected void afterImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
        if (impressaoCrudWrapper.getDados().containsKey("itens")) {
            boolean variacaoHabilitada = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.VARIACAO);
            uViewer.saltaLinha();
            if (variacaoHabilitada) {
                uViewer.inicioNivel(new int[]{10, 10, 25, 25, 5, 15, 10});
            } else {
                uViewer.inicioNivel(new int[]{15, 10, 30, 10, 25, 10});
            }
            uViewer.inicioTitulo();
            uViewer.escreveTitulo("C\u00f3digo de Barras", false);
            uViewer.escreveTitulo("C\u00f3digo", false);
            uViewer.escreveTitulo("Descri\u00e7\u00e3o", false);
            if (variacaoHabilitada) {
                uViewer.escreveTitulo("Varia\u00e7\u00f5es", false);
            }
            uViewer.escreveTitulo("Unidade", false);
            uViewer.escreveTitulo("Endere\u00e7o", false);
            uViewer.escreveTitulo("Quantidade", true);
            uViewer.fimTitulo();
            Long idFilialRequisitada = Util.string2Long((String)impressaoCrudWrapper.getDados().get("idFilialRequisitada").toString());
            List listaItens = (List)impressaoCrudWrapper.getDados().get("itens");
            for (Map mapItem : listaItens) {
                Long idProduto = Util.string2Long((String)mapItem.get("produto").toString());
                uViewer.inicioLinha();
                uViewer.escreveColuna((String)ProdutoRN.getInstance().buscarValorPorID(idProduto, "ean"), false);
                uViewer.escreveColuna((String)mapItem.get("produto"));
                uViewer.escreveColuna((String)mapItem.get("descricao"));
                if (variacaoHabilitada) {
                    uViewer.escreveColuna((String)mapItem.get("descricaoVariacoes"));
                }
                uViewer.escreveColuna((String)mapItem.get("unidadeMedida"));
                String endereco = "";
                if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.ESTOQUE_PRODUTO_FILIAL)) {
                    List comp = ComplementoProdutoFilialRN.getInstance().buscarListaConfiguracaoEstoqueProduto(idProduto);
                    endereco = comp.stream().filter(c -> c.getIdFilial().equals(idFilialRequisitada)).map(ComplementoProdutoFilial::getEndereco).findFirst().orElse("");
                } else {
                    endereco = (String)ProdutoRN.getInstance().buscarValorPorID(idProduto, "endereco");
                }
                uViewer.escreveColuna(endereco);
                int casasDecimais = mapItem.get("decimaisUnidadeMedida") != null ? (Integer)mapItem.get("decimaisUnidadeMedida") : 2;
                uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("quantidade"), casasDecimais));
                uViewer.fimLinha();
            }
            uViewer.fimNivel();
        }
    }
}

