/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.requisicaotransferencia;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.modulo.expedicao.regranegocio.RequisicaoTransferenciaRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.requisicaotransferencia.RequisicaoTransferenciaController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/requisicoes-transferencia"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Requisi\u00e7\u00f5es de transfer\u00eancia", ROTA="/expedicoes/requisicoes-transferencia", PROGRAMA=219, ICONE="icon-exportar-doc")
public class RequisicaoTransferenciaCrudController
extends RequisicaoTransferenciaController {
    protected GridBuilder<RequisicaoTransferenciaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("status", "status_default", "Status", 100, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "Requisi\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("nome", "usuario", "Usu\u00e1rio", 0, true, new String[]{"fk_requisicaotransf_usuario"}));
        colunas.add(new ColunaSQL("nome", "filial", "Filial requisitada", 0, true, new String[]{"fk_requisicaotransf_filreq"}));
        colunas.add(new ColunaSQL("dataEmissao", "Emiss\u00e3o", 150, true));
        colunas.add(new ColunaSQL("status", "Status", 100, true));
        GridBuilder grid = new GridBuilder(RequisicaoTransferenciaRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        grid.addOrdem(new Ordem("dataEmissao"));
        return grid;
    }

    @RequestMapping(value={"/marcar-faturado"})
    @DBTransaction
    public void marcarFaturado(@RequestParam Long idRequisicao) throws UnicoMensagemUsuarioException {
        RequisicaoTransferenciaRN.getInstance().marcarComoFaturado(Contexto.getInstance().getSessao(), idRequisicao);
    }

    protected String getCacheId() {
        return "requisicoes-transferencia".concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

