/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.expedicao.retirada;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoNumeroSerie;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.TipoRetiradaDocumento;
import br.intelidata.commons.domain.pojo.vendas.Retirada;
import br.intelidata.commons.domain.pojo.vendas.RetiradaDocumento;
import br.intelidata.commons.domain.pojo.vendas.RetiradaItem;
import br.intelidata.commons.domain.pojo.vendas.RetiradaItemBaixa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.RetiradaItemBaixaRN;
import br.intelidata.commons.modulo.expedicao.regranegocio.RetiradaRN;
import br.intelidata.commons.modulo.expedicao.relatorio.ReciboRetiradaRelatorio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.pdv.regranegocio.ItemRN;
import br.intelidata.commons.modulo.produto.regranegocio.MovimentoNumeroSerieRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoNumeroSerieRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.expedicao.retirada.RetiradaWrapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/retiradas"})
@SubMenuMapping(MENU="SubMenuEstoqueExpedicao", NOME="Retiradas", ROTA="/expedicoes/retiradas", PROGRAMA=1343, ICONE="icon-delivery")
public class RetiradaCrudController
extends CrudController<Retirada, RetiradaRN> {
    @Autowired
    public RetiradaCrudController() {
        super((AbstractRegraNegocio)RetiradaRN.getInstance(), Retirada::new, true, true, true);
    }

    protected GridBuilder<RetiradaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("iddocumento", "iddocumento", 0, false));
        colunas.add(new ColunaSQL("iditem", "IdItem", 0, false));
        colunas.add(new ColunaSQL("idfilial", "Id Filial", 0, false));
        colunas.add(new ColunaSQL("idproduto", "idProduto", 0, false));
        colunas.add(new ColunaSQL("codigocliente", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 0, false));
        colunas.add(new ColunaSQL("status", "Status", 0, false));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaisun", "Decimais", 0, false, new String[]{"fk_retiradavw_unidade"}));
        colunas.add(new ColunaSQL("documento", "N\u00famero documento", 170, true));
        colunas.add(new ColunaSQL("serie", "S\u00e9rie", 80, true));
        colunas.add(new ColunaSQL("modelo", "Modelo", 90, true));
        colunas.add(new ColunaSQL("emissao", "Data Emiss\u00e3o", 130, true));
        colunas.add(new ColunaSQL("pdv", "PDV", 80, false));
        colunas.add(new ColunaSQL("nomecliente", "Cliente", 300, true));
        colunas.add(new ColunaSQL("produto", "C\u00f3digo", 100, true));
        colunas.add(new ColunaSQL("descricao", "Produto", 300, true));
        colunas.add(new ColunaSQL("codigounidademedida", "UN", 60, true));
        colunas.add(new ColunaSQL("quantidade", "Qtd. vendida", 120, true));
        colunas.add(new ColunaSQL("quantidaderetirada", "Qtd. retirada", 120, true));
        colunas.add(new ColunaSQL("saldo", "Saldo", 120, true));
        colunas.add(new ColunaSQL("retirado", "Retirado", 100, false));
        colunas.add(new ColunaSQL("datahoraretirada", "Data/Hora retirada", 150, true));
        colunas.add(new ColunaSQL("usuarioretirada", "Usu\u00e1rio Retirada", 150, true));
        colunas.add(new ColunaSQL("status", "Status", 100, true));
        GridBuilder grid = new GridBuilder(RetiradaRN.getInstance().getTabela(), colunas);
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        grid.addOrdem(new Ordem("emissao"));
        return grid;
    }

    @RequestMapping(value={"/buscar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<RetiradaDocumento> getListaRetiradaDocumento(@RequestBody RetiradaWrapper wrapper) {
        TreeMap mapRetiradaDocumento = new TreeMap();
        for (Map mapLinha : wrapper.getDados()) {
            Long idItem = Long.parseLong(mapLinha.get("iditem").toString());
            if (Util.longNullOuZero((Long)idItem)) continue;
            Integer pdv = (Integer)mapLinha.get("pdv");
            Long idDocumento = Long.parseLong(mapLinha.get("iddocumento").toString());
            RetiradaRN.getInstance().getDocumentoRetirada(idDocumento, idItem, pdv, wrapper.getSituacao(), mapRetiradaDocumento);
        }
        return new ArrayList<RetiradaDocumento>(mapRetiradaDocumento.values());
    }

    @RequestMapping(value={"/gravar"}, method={RequestMethod.POST})
    @DBTransaction
    public void atualizarInformacoesRetirada(@RequestBody List<RetiradaItem> itens) throws UnicoMensagemUsuarioException {
        List listaCuponsItens;
        List listaNotasItens = itens.stream().filter(i -> !Util.longNullOuZero((Long)i.getIdNotaFiscalItem()) && BigDecimal.ZERO.compareTo(i.getQuantidade()) < 0).collect(Collectors.toList());
        if (!Util.listNullOrEmpty(listaNotasItens)) {
            NotaFiscalItemRN.getInstance().atualizaInformacoesRetiradaItens(SessaoUtil.getSessao(), listaNotasItens);
        }
        if (!Util.listNullOrEmpty(listaCuponsItens = itens.stream().filter(i -> !Util.longNullOuZero((Long)i.getIdItem()) && BigDecimal.ZERO.compareTo(i.getQuantidade()) < 0).collect(Collectors.toList()))) {
            ItemRN.getInstance().atualizaInformacoesRetiradaItens(SessaoUtil.getSessao(), listaCuponsItens);
        }
    }

    @RequestMapping(value={"/estornar"}, method={RequestMethod.POST})
    @DBTransaction
    public void estornarRetirada(@RequestBody RetiradaItem item) throws UnicoMensagemUsuarioException {
        RetiradaRN.getInstance().estornarRetirada(SessaoUtil.getSessao(), item.getIdItem(), item.getPdv(), item.getIdProduto());
    }

    @RequestMapping(value={"/imprimir-retirada"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> imprimirReciboRetirada(@RequestBody List<RetiradaDocumento> documentos) throws UnicoMensagemUsuarioException {
        Map<String, List<RetiradaDocumento>> map = documentos.stream().collect(Collectors.groupingBy(RetiradaDocumento::getNomeCliente));
        ArrayList<Remessa> remessas = new ArrayList<Remessa>();
        for (Map.Entry<String, List<RetiradaDocumento>> linha : map.entrySet()) {
            linha.getValue().forEach(documento -> documento.getItens().forEach(item -> {
                item.setQuantidade(item.getQuantidade().setScale((int)item.getDecimaisQuantidade(), RoundingMode.HALF_EVEN));
                item.setPrecoUnitario(item.getPrecoUnitario().setScale(ProdutoRN.getInstance().getCasasDecimais(item.getIdProduto()), RoundingMode.HALF_EVEN));
                item.setValorTotal(item.getValorTotal().setScale(2, RoundingMode.HALF_EVEN));
            }));
            remessas.add(ReciboRetiradaRelatorio.getInstance().getRelatorio(SessaoUtil.getSessao(), linha.getValue()));
        }
        ByteArrayOutputStream outputArquivoNovo = new ByteArrayOutputStream();
        Util.concatPDFs(remessas.stream().map(rem -> rem.getMalote().extrai("pdf")).collect(Collectors.toList()), (OutputStream)outputArquivoNovo, (boolean)false);
        return this.responseEntityService.createPDFResponse(outputArquivoNovo.toByteArray());
    }

    @RequestMapping(value={"/buscar-numero-serie"}, method={RequestMethod.POST})
    @DBTransaction
    public List<ProdutoNumeroSerie> buscarNumeroSerie(@RequestBody RetiradaItem item) {
        int origem = 2;
        Long idBusca = item.getIdNotaFiscalItem();
        if (Util.longNullOuZero((Long)idBusca)) {
            idBusca = item.getIdItem();
            origem = 1;
        }
        List produtos = MovimentoNumeroSerieRN.getInstance().buscarPorIdOrigemTipoOrigem(idBusca, new Integer[]{origem});
        for (ProdutoNumeroSerie produto : produtos) {
            ProdutoNumeroSerie serie = ProdutoNumeroSerieRN.getInstance().buscarPorIdProdutoNumeroSerie(produto.getIdproduto(), produto.getNumeroserie());
            produto.setStatus(serie.getStatus());
        }
        return produtos;
    }

    @RequestMapping(value={"/consultar-retirada"}, method={RequestMethod.POST})
    @DBTransaction
    public List<RetiradaItemBaixa> consultarRetirada(@RequestBody RetiradaItem item) {
        Long idItemBusca = null;
        TipoRetiradaDocumento tipoRetiradaDocumento = null;
        if (!Util.longNullOuZero((Long)item.getIdNotaFiscalItem())) {
            idItemBusca = item.getIdNotaFiscalItem();
            tipoRetiradaDocumento = TipoRetiradaDocumento.NOTA_FISCAL;
        } else if (!Util.longNullOuZero((Long)item.getIdItem())) {
            idItemBusca = item.getIdItem();
            tipoRetiradaDocumento = TipoRetiradaDocumento.PDV;
        }
        List listaItensBaixas = RetiradaItemBaixaRN.getInstance().getBuscarListaBaixaPorIdItem(idItemBusca, tipoRetiradaDocumento);
        HashMap<Long, String> mapUsuario = new HashMap<Long, String>();
        HashMap<Long, Produto> mapProduto = new HashMap<Long, Produto>();
        HashMap<String, Unidademedida> mapUnidade = new HashMap<String, Unidademedida>();
        for (RetiradaItemBaixa itemBaixa : listaItensBaixas) {
            Unidademedida unidade;
            Produto produto = (Produto)mapProduto.get(itemBaixa.getIdProduto());
            if (produto == null) {
                produto = (Produto)ProdutoRN.getInstance().buscarPorId(itemBaixa.getIdProduto());
                mapProduto.put(itemBaixa.getIdProduto(), produto);
            }
            if ((unidade = (Unidademedida)mapUnidade.get(produto.getUnidadeMedida())) == null) {
                unidade = UnidademedidaRN.getInstance().buscarPorCodigo(produto.getUnidadeMedida());
                mapUnidade.put(produto.getUnidadeMedida(), unidade);
            }
            itemBaixa.setQuantidade(itemBaixa.getQuantidade().setScale((int)unidade.getCasasdecimais(), RoundingMode.HALF_EVEN));
            itemBaixa.setCasasDecimais(unidade.getCasasdecimais().intValue());
            if (Util.longNullOuZero((Long)itemBaixa.getIdUsuario())) continue;
            String nomeUsuario = (String)mapUsuario.get(itemBaixa.getId());
            if (Util.stringNullOrEmpty((String)nomeUsuario)) {
                Usuario usuario = UsuarioRN.getInstance().buscarPorId(itemBaixa.getIdUsuario());
                nomeUsuario = usuario.getNome();
                mapUsuario.put(usuario.getId(), usuario.getNome());
            }
            itemBaixa.setNomeUsuario(nomeUsuario);
        }
        return listaItensBaixas;
    }

    protected String getCacheId() {
        return "retiradas".concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

