/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.extratorcartaofidelidade;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.core.util.UnicoPeriodoModel;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.regranegocio.ExtratoCartaoFidelidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/extrato-cartao-fidelidade"})
@SubMenuMapping(MENU="SubMenuPdvGeral", NOME="Extrato do cart\u00e3o fidelidade", ICONE="icon icon-e-moeda", ROTA="/pdvs/extrato-cartao-fidelidade", PROGRAMA=1000003)
public class ExtratoCartaoFidelidadeSimpleController
extends SimpleController {
    @RequestMapping(value={"/filtrar"})
    @DBAutoCommit
    public List<MapResultSet> filtrar(@RequestParam Long idCliente, @RequestParam LocalDate inicio, @RequestParam LocalDate fim) {
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        return new ExtratoCartaoFidelidadeRN().carregarDados(cliente, new UnicoPeriodoModel(inicio, fim));
    }

    @RequestMapping(value={"/incluir"})
    @DBTransaction
    public void incluirAcerto(@RequestParam Long idCliente, @RequestParam LocalDate data, @RequestParam BigDecimal pontos) throws UnicoMensagemUsuarioException {
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        if (cliente == null) {
            throw new UnicoMensagemUsuarioException("WWW580", "Informe um cliente para adicionar os pontos");
        }
        new ExtratoCartaoFidelidadeRN().incluirAcerto(cliente.getCodigo(), data, pontos, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/cancelar"})
    @DBTransaction
    public void cancelarAcerto(@RequestParam Long idOperacao) throws UnicoMensagemUsuarioException {
        new ExtratoCartaoFidelidadeRN().cancelarAcerto(idOperacao, SessaoUtil.getSessao());
    }
}

