/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.filial;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.licenca.ProdutoLicenca;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.InativoFilial;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.IndicadorFilial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.EmpresaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.LicencaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.commons.modulo.fiscal.regranegocio.ClassificacaoTributariaIbsCbsRN;
import br.intelidata.commons.modulo.produto.IbsCbsCustomizavel;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsCodigo;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsCst;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelIbsCbsNome;
import br.intelidata.commons.sped.contribuicoes.IndicadorIncidenciaTributaria;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.service.ApiCacheService;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.core.util.TipoCache;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.filial.JobReplicarPreco;
import br.intelidata.uniplusweb.web.rest.app.crud.filial.ReplicacaoPrecoWrapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unico.pojo.Licenca;

@RestController
@RequestMapping(value={"/api/filiais"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarFilial", NOME="Filiais", ROTA="/cadastros/filiais", PROGRAMA=13)
public class FilialCrudController
extends CrudController<Filial, FilialRN>
implements ICreateTask {
    private final LicencaService licencaService;
    private final TaskManager taskManager;
    private final ApiCacheService apiCacheService;

    public FilialCrudController(LicencaService licencaService, TaskManager taskManager, ApiCacheService apiCacheService) {
        super((AbstractRegraNegocio)FilialRN.getInstance(), Filial::new, true, true);
        this.licencaService = licencaService;
        this.taskManager = taskManager;
        this.apiCacheService = apiCacheService;
    }

    public TipoJob getTipoJob() {
        return TipoJob.REPLICACAO_PRECO;
    }

    public Class<? extends AbstractJob> job() {
        return JobReplicarPreco.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/validar-cnpj"})
    @DBAutoCommit
    public boolean validarCnpj(@RequestParam String value, @RequestParam(required=false) String variacaoCPF, @RequestParam(required=false) String codigo) {
        return FilialRN.getInstance().isCnpjCpfCadastrado(value, variacaoCPF, codigo);
    }

    @RequestMapping(value={"/quantidade"})
    @DBAutoCommit
    public int getNumerosFilias() {
        return FilialRN.getInstance().getQuantidadesFiliais();
    }

    @RequestMapping(value={"/filtrar-por-perfil"})
    @DBAutoCommit
    public List<Filial> filtrarPorPerfil(@RequestParam(required=false) Long idPerfil, @RequestParam(value="query", required=false) String filtro, @RequestParam(required=false) boolean cdm, @RequestParam(required=false) Long idEmpresa) {
        return FilialRN.getInstance().getFiliaisComboWeb(idEmpresa, idPerfil, cdm, filtro);
    }

    @RequestMapping(value={"/filtrar-conciliacao"})
    @DBAutoCommit
    public List<Filial> filtrarFiliaisConciliacao() {
        return FilialRN.getInstance().getComboPorLicencaWeb(ProdutoLicenca.CONCIFLEX);
    }

    @RequestMapping(value={"/validar-ie"})
    @DBAutoCommit
    public boolean validarInscricaoEstadual(@RequestParam String value, @RequestParam(required=false) Long idEstado, @RequestParam boolean permitirIsento) throws UnicoMensagemUsuarioException {
        Estado estado;
        if (!(StringUtil.stringNullOrEmpty((String)value) || (estado = (Estado)EstadoRN.getInstance().buscarPorId(idEstado)) == null || estado.getCodigo() == null || estado.getCodigo().isEmpty() || StringUtil.validaIE((String)value, (String)estado.getCodigo(), (boolean)permitirIsento))) {
            throw new UnicoMensagemUsuarioException("WCAD12", "Inscri\u00e7\u00e3o estadual inv\u00e1lida");
        }
        return true;
    }

    @RequestMapping(value={"/filiais-replicacao-preco"})
    @DBAutoCommit
    public List<Filial> carregarFiliaisReplicacaoPreco(@RequestParam(required=false) boolean apenasAtualizarProduto) {
        List filials = apenasAtualizarProduto ? FilialRN.getInstance().getTodasFiliaisApenasCodigoNome() : FilialRN.getInstance().buscarLista();
        filials.sort(Comparator.comparing(Filial::getId));
        return filials;
    }

    @RequestMapping(value={"/replicar-preco"})
    @DBAutoCommit
    public void replicarPreco(@RequestParam Long idFilialParaReplicar, @RequestParam(required=false) Long idFilialParaCopiar, @RequestParam(required=false) boolean apenasAtualizarProduto) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (NumberUtil.longNullOuZero((Long)idFilialParaCopiar)) {
            idFilialParaCopiar = sessao.getIdFilial();
        }
        ReplicacaoPrecoWrapper replicacao = new ReplicacaoPrecoWrapper();
        replicacao.setIdFilialParaCopiar(idFilialParaCopiar);
        replicacao.setIdNovaFilial(idFilialParaReplicar);
        replicacao.setApenasAtualizarProduto(apenasAtualizarProduto);
        this.createTask((Object)replicacao);
    }

    protected void beforeCreate(Filial filial, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarLicencaCnpj(filial, 0);
        if (!EmpresaRN.getInstance().isHabilitarEmpresaNoSistema() && NumberUtil.longNullOuZero((Long)filial.getIdEmpresa())) {
            filial.setIdEmpresa((Long)EmpresaRN.getInstance().getIdsEmpresas().get(0));
        }
    }

    protected void beforeUpdate(Filial filial, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Filial filialOriginal = (Filial)FilialRN.getInstance().buscarPorId(filial.getId());
        filial.setCnpj(filialOriginal.getCnpj());
        filial.setRazaoSocial(filialOriginal.getRazaoSocial());
        this.validarLicencaCnpj(filial, 1);
    }

    protected void beforeSave(Filial filial, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarHora(filial.getPrimeiroTurnoHoraInicial());
        this.validarHora(filial.getPrimeiroTurnoHoraFinal());
        this.validarHora(filial.getSegundoTurnoHoraInicial());
        this.validarHora(filial.getSegundoTurnoHoraFinal());
        this.validarHora(filial.getTerceiroTurnoHoraInicial());
        this.validarHora(filial.getTerceiroTurnoHoraFinal());
        this.validarHora(filial.getQuartoTurnoHoraInicial());
        this.validarHora(filial.getQuartoTurnoHoraFinal());
        if (!NumberUtil.longNullOuZero((Long)filial.getId())) {
            FilialRN.getInstance().acertaPerfilFilial(SessaoUtil.getSessao(), filial.getId(), true);
        }
        UsuarioRN.getInstance().atualizaLocalTrabalhoNuloWeb(SessaoUtil.getSessao());
    }

    protected void afterSave(Filial filial, Optional<Long> parentId) {
        this.cacheService.removerCache(TipoCache.ID_TIME_ZONE_ID.getId().concat(filial.getId().toString()));
        this.apiCacheService.evictAll(ContextoHolder.getTenant());
    }

    protected GridBuilder<FilialRN> getGridBuilder() {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 60, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("razaoSocial", "Raz\u00e3o social", 0, true));
        colunas.add(new ColunaSQL("cnpj", "CNPJ/CPF", 200, true));
        colunas.add(new ColunaSQL("cidade", "Cidade", 150, true));
        colunas.add(new ColunaSQL("estado", "UF", 40, true));
        GridBuilder gridBuilder = new GridBuilder(FilialRN.getInstance().getTabela(), colunas);
        if (LicencaManager.getInstance().isEnterprise() && !SessaoUtil.getSessao().getUsuario().isAdministrador()) {
            USelect subSelect = new USelect("perfil_filial");
            subSelect.add(new ColunaSQL("idfilial"));
            subSelect.add((ColunaSQL)new Referencia("idperfil", "idperfil"));
            subSelect.add(new Condicao("idperfil", Operador.IGUAL, SessaoUtil.getSessao().getUsuario().getIdPerfil()));
            gridBuilder.addCodicaoDefault(new Condicao("id", Operador.CONTIDO_EM, subSelect));
        }
        gridBuilder.addCodicaoDefault(new Condicao("inativo", Operador.DIFERENTE, InativoFilial.INATIVO_POR_LICENCA.getId().intValue()));
        gridBuilder.addReferenciaDefault(new Referencia("inativo", "inativo"));
        gridBuilder.addOrdem(new Ordem("nome"));
        if (ClassificacaoTributariaIbsCbsRN.getInstance().habilitarIbsCbs(sessao.getFilial())) {
            gridBuilder.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsNome(sessao, IbsCbsCustomizavel.FILIAL));
            gridBuilder.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsCodigo(sessao, IbsCbsCustomizavel.FILIAL));
            gridBuilder.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelIbsCbsCst(sessao, IbsCbsCustomizavel.FILIAL));
        }
        return gridBuilder;
    }

    public List<Coluna> getColunasCustomizaveis() {
        return FilialRN.getInstance().getColunaCostumizavelFilialWW(SessaoUtil.getSessao());
    }

    protected String getCacheId() {
        if (LicencaManager.getInstance().isEnterprise()) {
            return "filiais-" + SessaoUtil.getSessao().getUsuario().getIdPerfil();
        }
        return "filiais";
    }

    private void validarHora(String valor) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)valor) && !valor.matches("([0-1][0-9]|2[0-3])\\:[0-5][0-9]|(__:__)")) {
            throw new UnicoMensagemUsuarioException("WCAD14", "Hora inv\u00e1lida!");
        }
    }

    private void validarLicencaCnpj(Filial filial, int transacao) throws UnicoMensagemUsuarioException {
        List licencasTrocaRazao;
        if (this.licencaService.getDadosLicenca().isDemonstracao()) {
            return;
        }
        List licencas = LicencaRN.getInstance().getLicencasInstaladas();
        List filiais = FilialRN.getInstance().buscarLista();
        if (transacao != 1 && filiais.stream().anyMatch(f -> Objects.equals(f.getCnpj(), filial.getCnpj()) && Objects.equals(StringUtils.trimToEmpty((String)f.getVariacaoCPF()), StringUtils.trimToEmpty((String)filial.getVariacaoCPF())))) {
            throw new UnicoMensagemUsuarioException("WWW367", "J\u00e1 existe uma filial com esse " + filial.getTipoPessoa().getLabel() + ": " + filial.getCnpj() + ".");
        }
        Optional<Licenca> licencaFilial = licencas.stream().filter(l -> Objects.equals(l.getCnpj(), filial.getCnpj()) && Objects.equals(StringUtils.trimToEmpty((String)l.getVariacaoCPF()), StringUtils.trimToEmpty((String)filial.getVariacaoCPF())) && l.getProdutoLicenca().isRequerCNPJ()).findFirst();
        if (!licencaFilial.isPresent()) {
            throw new UnicoMensagemUsuarioException("WWW368", "N\u00e3o existe uma licen\u00e7a para o " + filial.getTipoPessoa().getLabel() + " informado. Verifique!");
        }
        if (!licencaFilial.get().getRazaSocial().trim().equals(filial.getRazaoSocial().trim()) && TipoPessoa.JURIDICA.equals((Object)filial.getTipoPessoa()) && (ListMapUtil.listNullOrEmpty(licencasTrocaRazao = licencas.stream().filter(l -> filial.getCnpj().equals(l.getCnpj()) && l.getProdutoLicenca().equals((Object)ProdutoLicenca.TROCAR_RAZAO_SOCIAL)).sorted(Comparator.comparing(Licenca::getDataAtivacao)).collect(Collectors.toList())) || licencasTrocaRazao.stream().noneMatch(f -> f.getRazaSocial().trim().equalsIgnoreCase(filial.getRazaoSocial().trim())))) {
            throw new UnicoMensagemUsuarioException("WWW374", "Raz\u00e3o social diferente da esperada: '" + licencaFilial.get().getRazaSocial() + "'. Verifique!");
        }
    }

    protected void beforeRead(Filial filial, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GS1) && IndicadorFilial.FILIAL.equals((Object)filial.getIndicadorFilial())) {
            FilialRN.getInstance().carregaDadosGS1(filial);
        }
    }

    @RequestMapping(value={"/filiais-scanntech"})
    @DBAutoCommit
    public List<Filial> buscarFiliaisScanntech() {
        return FilialRN.getInstance().getFiliaisScanntechComboWeb();
    }

    @RequestMapping(value={"/buscar-incidencia-tributaria-matriz"})
    @DBAutoCommit
    public IndicadorIncidenciaTributaria buscarIndicadorIncidenciaTributariaMatriz() throws UnicoMensagemUsuarioException {
        return FilialRN.getInstance().buscaIncidenciaTributariaMatriz(SessaoUtil.getSessao());
    }
}

