/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.filial;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.FormacaoPrecoProduto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.regranegocio.FormacaoPrecoProdutoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.filial.ReplicacaoPrecoWrapper;
import java.util.List;

public class JobReplicarPreco
extends AbstractPrepareJob {
    public JobReplicarPreco(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(TipoNotificacaoSimples.SUCCESS, "Replica\u00e7\u00e3o de pre\u00e7o, finalizada com sucesso");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao(TipoNotificacaoSimples.ERROR, "Ocorreu um erro ao fazer a replica\u00e7\u00e3o de pre\u00e7o");
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        Sessao sessao = SessaoUtil.getSessaoSistema();
        ReplicacaoPrecoWrapper replicacao = (ReplicacaoPrecoWrapper)this.getObjetoDeserializado(ReplicacaoPrecoWrapper.class);
        if (replicacao.isApenasAtualizarProduto()) {
            List listaFormacaoPrecoProdutoCopiar = FormacaoPrecoProdutoCommonRN.getInstance().buscarFormacaoPrecoPorFilial(replicacao.getIdFilialParaCopiar());
            for (FormacaoPrecoProduto formacaoPrecoProduto : listaFormacaoPrecoProdutoCopiar) {
                ProdutoRN.getInstance().atualizaProdutoComFormacaoPreco(Contexto.getInstance().getSessao(), formacaoPrecoProduto, null, true);
            }
        } else {
            Filial filialParaCopiar = (Filial)FilialRN.getInstance().buscarPorId(replicacao.getIdFilialParaCopiar());
            Filial filialParaAtualizar = (Filial)FilialRN.getInstance().buscarPorId(replicacao.getIdNovaFilial());
            FormacaoPrecoProdutoRN.getInstance().replicaPrecoEntreFilial(sessao, null, filialParaCopiar, filialParaAtualizar);
        }
    }
}

