/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.filial.inscricaoestadualsubstituto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.InscricaoEstadualContribuinteSubstituto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.InscricaoEstadualContribuinteSubstitutoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/inscricoes-estaduais-substituto"})
public class InscricaoEstadualSubstitutoCrudController
extends CrudController<InscricaoEstadualContribuinteSubstituto, InscricaoEstadualContribuinteSubstitutoRN> {
    public InscricaoEstadualSubstitutoCrudController() {
        super((AbstractRegraNegocio)InscricaoEstadualContribuinteSubstitutoRN.getInstance(), InscricaoEstadualContribuinteSubstituto::new);
        this.dependsOn("idFilial");
    }

    protected void beforeSave(@RequestBody InscricaoEstadualContribuinteSubstituto iecs, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)iecs.getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WWW65", "Id filial nao informado");
        }
        if (Util.longNullOuZero((Long)iecs.getIdEstado())) {
            throw new UnicoMensagemUsuarioException("WWW66", "Campo Estado n\u00e3o inforamdo");
        }
        Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(iecs.getIdEstado());
        if (!Util.validaIE((String)iecs.getInscricaoEstadual(), (String)estado.getCodigo(), (boolean)true)) {
            throw new UnicoMensagemUsuarioException("WWCAD12", "Inscri\u00e7\u00e3o estadual inv\u00e1lida");
        }
    }

    protected GridBuilder<InscricaoEstadualContribuinteSubstitutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idFilial", "IdFilial", 0, false));
        colunas.add(new ColunaSQL("idEstado", "IdEstado", 0, false));
        colunas.add(new ColunaSQL("inscricaoEstadual", "Inscri\u00e7\u00e3o estadual", 0, true));
        colunas.add(new ColunaSQL("codigo", "estado", "UF", 0, true, new String[]{"fk_iesubstituto_estado"}));
        return new GridBuilder(InscricaoEstadualContribuinteSubstitutoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "inscricoes-estaduais-substituto";
    }
}

