/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.filial.simplesnacional.tabelasimplesnacionalproduto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.FilialTabelaSimplesNacional;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialTabelaSimplesNacionalRN;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tabela-simples-nacional-produto"})
public class TabelaSimplesNacionalProdutoCrudController
extends CrudController<FilialTabelaSimplesNacional, FilialTabelaSimplesNacionalRN> {
    public TabelaSimplesNacionalProdutoCrudController() {
        super((AbstractRegraNegocio)FilialTabelaSimplesNacionalRN.getInstance(), FilialTabelaSimplesNacional::new, false);
        this.dependsOn("idFilial");
    }

    protected String getCacheId() {
        return "tabela-simples-nacional-produto";
    }

    protected GridBuilder<FilialTabelaSimplesNacionalRN> getGridBuilder() {
        ColunaSQL colunaSaldoOriginal = new ColunaSQL("total", "Aliquota", 0, true);
        colunaSaldoOriginal.setVirtual(true);
        return new GridBuilder(FilialTabelaSimplesNacionalRN.getInstance().getTabela(), Arrays.asList(new ColunaSQL("id", "Dd", 0, false), new ColunaSQL("idFilial", "idFilial", 0, false), new ColunaSQL("periodo", "Periodo", 0, true), colunaSaldoOriginal, new ColunaSQL("aliquotaIrpj", "IRPJ", 0, true), new ColunaSQL("aliquotaCsll", "CSLL", 0, true), new ColunaSQL("aliquotaCofins", "PIS", 0, true), new ColunaSQL("aliquotaPisPasep", "COFINS", 0, true), new ColunaSQL("aliquotaCpp", "CPP", 0, true), new ColunaSQL("aliquotaIcms", "ICMS", 0, true), new ColunaSQL("aliquotaIpi", "IPI", 0, true)));
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(dado -> {
            BigDecimal total = BigDecimal.ZERO;
            total = total.add((BigDecimal)dado[this.getIndexColuna("aliquotaIrpj", colunas)]);
            total = total.add((BigDecimal)dado[this.getIndexColuna("aliquotaCsll", colunas)]);
            total = total.add((BigDecimal)dado[this.getIndexColuna("aliquotaCofins", colunas)]);
            total = total.add((BigDecimal)dado[this.getIndexColuna("aliquotaPisPasep", colunas)]);
            total = total.add((BigDecimal)dado[this.getIndexColuna("aliquotaCpp", colunas)]);
            total = total.add((BigDecimal)dado[this.getIndexColuna("aliquotaIcms", colunas)]);
            total = total.add((BigDecimal)dado[this.getIndexColuna("aliquotaIpi", colunas)]);
            int idxTotal = this.getIndexColuna("total", colunas);
            dado[idxTotal] = Util.bigDecimal2String((BigDecimal)total, (String)"#,###,###,##0.00");
        });
    }
}

