/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.finalizador;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoFinalizador;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoRetaguarda;
import br.intelidata.commons.domain.pojo.pafecf.Finalizador;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.pdv.regranegocio.FinalizadorContaCorrenteRN;
import br.intelidata.commons.modulo.pdv.regranegocio.FinalizadorRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/finalizadores"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Meios de pagamento", ICONE="icon-incluir-subgrupo", ROTA="/pdvs/finalizadores", PROGRAMA=63)
public class FinalizadorCrudController
extends CrudController<Finalizador, FinalizadorRN> {
    public FinalizadorCrudController() {
        super((AbstractRegraNegocio)FinalizadorRN.getInstance(), Finalizador::new);
    }

    protected GridBuilder<FinalizadorRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 150, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        return new GridBuilder(FinalizadorRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "finalizadores";
    }

    @RequestMapping(value={"/validar-tecla"})
    @DBAutoCommit
    public boolean validaTecla(@RequestParam(value="idFinalizador") Long idFinalizador, @RequestParam(value="tecla") int tecla) throws UnicoMensagemUsuarioException {
        if (FinalizadorRN.getInstance().buscarPorTecla(Integer.valueOf(tecla), idFinalizador) != null) {
            throw new UnicoMensagemUsuarioException("WPDV285", "Tecla j\u00e1 cadastrada!");
        }
        return true;
    }

    @RequestMapping(value={"/configuracao-instalacao"})
    @DBAutoCommit
    public void configuracaoInstalacao(@RequestParam(value="opcao") int opcao, @RequestParam(value="linhaSelecionada", required=false) Long linhaSelecionada) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (opcao == 1) {
            Finalizador finalizador = (Finalizador)FinalizadorRN.getInstance().buscarPorId(linhaSelecionada);
            FinalizadorRN.getInstance().setValorInstalacao(finalizador, sessao);
            FinalizadorRN.getInstance().alterar(finalizador, sessao);
        } else if (opcao == 2) {
            List finalizadores = FinalizadorRN.getInstance().buscarLista();
            StringBuilder sb = new StringBuilder();
            for (Finalizador finalizador : finalizadores) {
                try {
                    FinalizadorRN.getInstance().setValorInstalacao(finalizador, sessao);
                    FinalizadorRN.getInstance().alterar(finalizador, sessao);
                }
                catch (UnicoMensagemUsuarioException e) {
                    sb.append(e.getMensagemSemCodigoDeErro());
                }
            }
            if (sb.length() > 0) {
                throw new UnicoMensagemUsuarioException("WPDV471", sb.toString());
            }
        }
    }

    @RequestMapping(value={"/buscar-lista"})
    @DBAutoCommit
    public List<Finalizador> buscarListaFinalizadores() {
        return FinalizadorRN.getInstance().buscarLista();
    }

    @RequestMapping(value={"/combo-venda-nfce"})
    @DBAutoCommit
    public List<Finalizador> buscarComboVendaNfce() {
        List finalizadores = FinalizadorRN.getInstance().getComboVendaNfceWeb();
        for (Finalizador finalizador : finalizadores) {
            if (StringUtil.stringNullOrEmpty((String)finalizador.getTipoDocumentoRetaguarda())) continue;
            finalizador.setTipoDocumentoFinanceiro(TipoDocumentoFinanceiroRN.getInstance().buscarPorId(Long.valueOf(finalizador.getTipoDocumentoRetaguarda())));
        }
        return finalizadores;
    }

    @RequestMapping(value={"/finalizador-default"}, method={RequestMethod.POST})
    public Finalizador getFinalizadorDefault(@RequestBody Finalizador finalizador) {
        FinalizadorRN.getInstance().setValorDefault(finalizador);
        return finalizador;
    }

    protected void read(Finalizador finalizador, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        finalizador.setGerarFinanceiro(finalizador.getTipoRetaguarda() != null && finalizador.getTipoRetaguarda() != TipoRetaguarda.NAO_GERAR_FINANCEIRO);
        List fcc = FinalizadorContaCorrenteRN.getInstace().buscarListaPorFinalizador(finalizador.getId());
        fcc.forEach(f -> {
            Map filialCodigo = FilialRN.getInstance().buscarValoresPorID(f.getIdFilial(), new String[]{"codigo"});
            Map stringObjectMap = ContaCorrenteRN.getInstance().buscarValoresPorID(f.getIdContaCorrente(), new String[]{"descricao"});
            f.setFilial((String)filialCodigo.get("codigo"));
            f.setContaCorrente((String)stringObjectMap.get("descricao"));
        });
        finalizador.setContasCorrentes(fcc);
    }

    protected void beforeSave(Finalizador finalizador, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (finalizador.isGerarFinanceiro()) {
            finalizador.setTipoRetaguarda(this.getTipoRetaguarda(finalizador.getTipoDocumento()));
        } else {
            finalizador.setTipoRetaguarda(TipoRetaguarda.NAO_GERAR_FINANCEIRO);
        }
        FinalizadorRN.getInstance().setValorDefault(finalizador);
    }

    private TipoRetaguarda getTipoRetaguarda(TipoDocumentoFinalizador tipoDocumento) {
        if (tipoDocumento == TipoDocumentoFinalizador.PIX) {
            return TipoRetaguarda.LANCAR_CONTA_CORRENTE;
        }
        return TipoRetaguarda.GERAR_CONTAS_RECEBER;
    }
}

