/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.bancoonline.IntegracaoBancoOnline;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.uboleto.bancos.asaas.Asaas;
import br.intelidata.commons.core.uboleto.enums.BancoDisponivel;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteAcaoGeracaoRemessa;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.DocumentoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.TipoSaidaBoleto;
import br.intelidata.commons.domain.regranegocio.ArquivoRemessaCommonRN;
import br.intelidata.commons.domain.regranegocio.BancoCommonRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.CobrancaEscrituralRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.RemessaCobrancaEscritural;
import br.intelidata.commons.domain.wrapper.GeracaoRemessaWrapper;
import br.intelidata.commons.modulo.c3po.ecommerce.regranegocio.geral.ConversorImagem;
import br.intelidata.commons.modulo.financeiro.bancoonline.BancoOnlineRetorno;
import br.intelidata.commons.modulo.financeiro.bancoonline.BancoOnlineRetornoBoleto;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteCarteiraRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

public interface IGeraRemessa {
    default public RemessaCobrancaEscritural remessaOline(GeracaoRemessaWrapper remessaWrapper, boolean validar, ConversorImagem convert) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(remessaWrapper.getIdContaCorrenteRemessa());
        if (validar) {
            this.validarRemessa(remessaWrapper, contaCorrente, true);
        }
        remessaWrapper.setDocumentos(FinanceiroDadoRN.getInstance().atualizaDocumentosCobranca(remessaWrapper.getDocumentos()));
        Banco banco = (Banco)BancoCommonRN.getInstance().buscarPorId(contaCorrente.getIdbanco());
        IntegracaoBancoOnline integracao = new IntegracaoBancoOnline(sessao, contaCorrente, convert);
        boolean isAsaas = BancoDisponivel.isAsaas((String)banco.getCodigo());
        ContaCorrenteCarteira contaCarteira = this.getContaCorrenteCarteira(remessaWrapper, isAsaas);
        ContaCorrenteAcaoGeracaoRemessa contaAcaoRemessa = new ContaCorrenteAcaoGeracaoRemessa();
        contaAcaoRemessa.setAcaoCobrancaAPI(remessaWrapper.getAcaoCobrancaAPI());
        this.gravarPreferenciaDesconto(sessao, remessaWrapper.getPercentualDescontoPagamentoAteVencimento());
        RemessaCobrancaEscritural remessaCobrancaEscritural = CobrancaEscrituralRN.getInstance().gerarRemessaWeb(sessao, remessaWrapper.getDocumentos(), contaCorrente, contaCarteira, banco, false, null, contaAcaoRemessa, remessaWrapper.getTipoImpressao(), remessaWrapper.getPercentualDescontoPagamentoAteVencimento(), remessaWrapper.getInstrucaoProtesto(), remessaWrapper.getDiasInstrucao(), remessaWrapper.getObservacao());
        BancoOnlineRetorno retorno = integracao.processar(contaAcaoRemessa.getAcaoCobrancaAPI(), remessaCobrancaEscritural.getBoletos());
        remessaCobrancaEscritural.setBancoOnlineRetorno(retorno);
        for (BancoOnlineRetornoBoleto boleto : retorno.getBoletos()) {
            remessaWrapper.getDocumentos().stream().filter(cob -> cob.getIdFinanceiroDado().toString().equals(boleto.getIdentificacaoBoletoEmpresa())).findFirst().ifPresent(cobranca -> {
                if (isAsaas) {
                    cobranca.setNossoNumero(boleto.getNossoNumero());
                    cobranca.setDvNossoNumero(boleto.getDvNossoNumero());
                    cobranca.setIdContaCorrente(contaCorrente.getId());
                }
                cobranca.setUrlQrCode(boleto.getQrCode());
            });
        }
        ArquivoRemessaCommonRN.getInstance().gravaNossoNumero(sessao, contaCorrente, remessaWrapper.getDocumentos(), contaCarteira.getId(), remessaWrapper.getObservacao());
        FinanceiroDadoRN.getInstance().atualizaDadosBoletoFinanceiro(retorno);
        remessaCobrancaEscritural.setBoletos(null);
        return remessaCobrancaEscritural;
    }

    default public void validarRemessa(GeracaoRemessaWrapper remessa, ContaCorrente contaCorrente, boolean gerarRemessa) throws UnicoMensagemUsuarioException {
        if (contaCorrente == null) {
            throw new UnicoMensagemUsuarioException("WCBE59", "Selecione uma conta corrente");
        }
        List idsDocumentos = remessa.getDocumentos().stream().map(DocumentoCobranca::getIdFinanceiroDado).collect(Collectors.toList());
        FinanceiroDadoRN.getInstance().verificaDocumentosPendentes(idsDocumentos);
        if (!ContaCorrenteRN.getInstance().possuiIntegracaoOnline(contaCorrente)) {
            if (NumberUtil.longNullOuZero((Long)remessa.getIdCarteira())) {
                throw new UnicoMensagemUsuarioException("WCBE60", "Selecione uma carteira");
            }
            if (NumberUtil.longNullOuZero((Long)remessa.getIdAcaoCobrancaRemessa()) && gerarRemessa) {
                throw new UnicoMensagemUsuarioException("WCBE73", "Selecione uma a\u00e7\u00e3o de cobran\u00e7a");
            }
            if (!gerarRemessa && (remessa.getTipoSaidaBoleto().equals((Object)TipoSaidaBoleto.EMAIL) || remessa.getTipoSaidaBoleto().equals((Object)TipoSaidaBoleto.EMAIL_COM_NOTA_FISCAL))) {
                for (DocumentoCobranca doc : remessa.getDocumentos()) {
                    if (!Util.stringNullOrEmpty((String)doc.getEmailEntidade())) continue;
                    throw new UnicoMensagemUsuarioException("WCBE72", "Cliente " + doc.getNomeSacado() + " n\u00e3o possui e-mail cadastrado! Verifique.");
                }
            }
        }
    }

    default public ContaCorrenteCarteira getContaCorrenteCarteira(GeracaoRemessaWrapper remessaWrapper, boolean isAsaas) throws UnicoMensagemUsuarioException {
        if (isAsaas) {
            return Asaas.getContaCarteira((Long)remessaWrapper.getIdContaCorrenteRemessa());
        }
        ContaCorrenteCarteira contaCarteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraRN.getInstance().buscarPorId(remessaWrapper.getIdCarteira());
        if (contaCarteira == null) {
            List carteiras = ContaCorrenteCarteiraRN.getInstance().buscarListaPorContaCorrente(remessaWrapper.getIdContaCorrenteRemessa(), true);
            if (Util.listNullOrEmpty((List)carteiras) || carteiras.size() > 1) {
                throw new UnicoMensagemUsuarioException("COM236595", "Carteira n\u00e3o encontrada.");
            }
            contaCarteira = (ContaCorrenteCarteira)carteiras.get(0);
        }
        return contaCarteira;
    }

    default public void gravarPreferenciaDesconto(Sessao sessao, BigDecimal desconto) throws UnicoMensagemUsuarioException {
        PropriedadeRN.getInstance().setPropriedade(sessao, 592, desconto.toString());
    }
}

