/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.uboleto.enums.BancoDisponivel;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.ArquivoRemessa;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.ArquivoRemessaRN;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.DocumentoCobrancaRN;
import br.intelidata.commons.modulo.cobrancaescritural.relatorio.FrancesinhaRemessaRelatorio;
import br.intelidata.commons.modulo.financeiro.bancoonline.asaas.StatusTransmissao;
import br.intelidata.commons.modulo.financeiro.regranegocio.BancoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/remessas"})
@SubMenuMapping(MENU="SubMenuFinanceiroCobrancaEscritural", NOME="Consulta de remessa", ROTA="/financeiros/remessas", PROGRAMA=422)
public class RemessaCrudController
extends CrudController<ArquivoRemessa, ArquivoRemessaRN> {
    public RemessaCrudController() {
        super((AbstractRegraNegocio)ArquivoRemessaRN.getInstance(), ArquivoRemessa::new);
    }

    protected String getCacheId() {
        return "remessas";
    }

    protected GridBuilder<ArquivoRemessaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idContaCorrente", "idContaCorrente", 0, false));
        colunas.add(new ColunaSQL("dataGravacao", "Data", 100, true));
        colunas.add(new ColunaSQL("horaGravacao", "Hora", 100, true));
        colunas.add(new ColunaSQL("descricao", "descricaoContaCorrente", "Conta corrente", 150, true, new String[]{"fk_arquivoremessa_cc"}));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usu\u00e1rio", 150, true, new String[]{"fk_arquivoremessa_usuario"}));
        colunas.add(new ColunaSQL("bancoEmiteBoleto", "Banco emite boleto", 80, true, EnumSimNao.class));
        colunas.add(new ColunaSQL("layout", "Layout", 150, true));
        colunas.add(new ColunaSQL("arquivoLicenca", "Arquivo licen\u00e7a", 150, true));
        colunas.add(new ColunaSQL("codigoAcaoCobranca", "Cod.", 80, true));
        colunas.add(new ColunaSQL("descricaoAcaoCobranca", "A\u00e7\u00e3o cobran\u00e7a", 150, true));
        colunas.add(new ColunaSQL("sequencia", "Sequ\u00eancia", 80, true));
        colunas.add(new ColunaSQL("codigoBanco", "Banco", 80, true));
        colunas.add(new ColunaSQL("codigoAgencia", "Ag\u00eancia", 80, true));
        colunas.add(new ColunaSQL("numeroContacorrente", "Numero conta", 120, true));
        colunas.add(new ColunaSQL("codigoCedente", "C\u00f3d. cedente", 120, true));
        colunas.add(new ColunaSQL("carteira", "Carteira", 130, true));
        colunas.add(new ColunaSQL("outrodadoConfiguracao1", "Outro dado config1", 150, true));
        colunas.add(new ColunaSQL("outrodadoConfiguracao2", "Outro dado config2", 150, true));
        colunas.add(new ColunaSQL("instrucaoCaixa", "Instru\u00e7\u00e3o caixa", 200, true));
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 200, true));
        ColunaSQL coluna = new ColunaSQL("integracao", "integracao", 0, false);
        coluna.setVirtual(true);
        colunas.add(coluna);
        GridBuilder grid = new GridBuilder(ArquivoRemessaRN.getInstance().getTabela(), colunas);
        grid.addOrdemDefault(new Ordem("dataGravacao", true));
        grid.addOrdemDefault(new Ordem("horaGravacao", true));
        return grid;
    }

    @RequestMapping(value={"/cancelar"})
    @DBAutoCommit
    public void cancelar(@RequestParam Long idRemessa) throws UnicoMensagemUsuarioException {
        ContaCorrente conta;
        ArquivoRemessa remessa = (ArquivoRemessa)ArquivoRemessaRN.getInstance().buscarPorId(idRemessa);
        if (remessa != null && !StatusTransmissao.SUCESSO.equals((Object)remessa.getStatusTransmissao()) && !StatusTransmissao.CANCELADO.equals((Object)remessa.getStatusTransmissao()) && (conta = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(Long.valueOf(remessa.getIdContaCorrente()))) != null && conta.getTipoIntegracao() != null) {
            List documentos = DocumentoCobrancaRN.getInstace().buscarPendenteTransmissaoPorIdRemessa(remessa.getId());
            documentos.forEach(doc -> doc.setStatusTransmissao(StatusTransmissao.CANCELADO));
            remessa.setDocumentosCobranca(documentos);
            remessa.setStatusTransmissao(StatusTransmissao.CANCELADO);
            ArquivoRemessaRN.getInstance().alterar(remessa, SessaoUtil.getSessao());
            return;
        }
        throw new UnicoMensagemUsuarioException("BLG008", "N\u00e3o foi poss\u00edvel cancelar a remessa pois o status est\u00e1 como 'Sucesso', 'Cancelado' ou a conta corrente n\u00e3o possui integra\u00e7\u00e3o.");
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        dados.forEach(registro -> {
            Long idContaCorrente = (Long)registro[this.getIndexColuna("idContaCorrente", colunas)];
            ContaCorrente conta = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idContaCorrente);
            if (conta != null) {
                Banco banco = (Banco)BancoRN.getInstance().buscarPorId(conta.getIdbanco());
                registro[this.getIndexColuna((String)"integracao", (List)colunas)] = banco != null && BancoDisponivel.isAsaas((String)banco.getCodigo());
            }
        });
    }

    @RequestMapping(value={"/imprimir-francesinha"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirFrancesinha(@RequestBody Long idArquivoRemessa) throws UnicoMensagemUsuarioException {
        ArquivoRemessa arquivoRemessa = (ArquivoRemessa)ArquivoRemessaRN.getInstance().buscarPorId(idArquivoRemessa);
        if (arquivoRemessa != null) {
            arquivoRemessa.setDocumentosCobranca(DocumentoCobrancaRN.getInstace().buscarPorArquivoRemessa(idArquivoRemessa));
            return this.responseEntityService.createPDFResponse(FrancesinhaRemessaRelatorio.getInstance().imprimir(arquivoRemessa).getMalote().extrai("pdf"), "francesinha");
        }
        throw new UnicoMensagemUsuarioException("WCBE", "Arquivo de remessa n\u00e3o encontrado!");
    }
}

