/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.retorno;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.ArquivoRetorno;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.OcorrenciaCobranca;
import br.intelidata.commons.domain.regranegocio.ArquivoRetornoCommonRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.ProcessarArquivoRetornoRN;
import br.intelidata.commons.domain.wrapper.FiltroRetornoBancos;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.ArquivoRetornoRN;
import br.intelidata.commons.modulo.cobrancaescritural.relatorio.FrancesinhaRelatorio;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ParametroCobrancaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.remessa.DocumentoRetornoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.cobrancaescritural.retorno.ProcessarRetornoWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/processar-arquivos"})
@SubMenuMapping(MENU="SubMenuFinanceiroGeral", ICONE="icon-ascendente", NOME="Retorno de cobran\u00e7a", ROTA="/financeiros/processar-arquivos", PROGRAMA=421)
public class ProcessarRetornoSimpleController
extends SimpleController {
    @RequestMapping(value={"/processar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ArquivoRetorno> lerArquivosRetorno(@RequestPart(value="file") MultipartFile[] files, @RequestPart(value="idContaCorrente") Long idContaCorrente) throws UnicoMensagemUsuarioException, IOException {
        if (ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            throw new UnicoMensagemUsuarioException("CBE193", "Arquivos n\u00e3o informados.");
        }
        HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
        for (MultipartFile file : files) {
            mapArquivos.put(file.getOriginalFilename(), file.getBytes());
        }
        return ProcessarArquivoRetornoRN.getInstance().lerArquivosWeb(SessaoUtil.getSessao(), mapArquivos, idContaCorrente);
    }

    @RequestMapping(value={"/processar-api"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ArquivoRetorno> processaRetornoApi(@RequestBody FiltroRetornoBancos filtroRetornoBancos) throws UnicoMensagemUsuarioException {
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(filtroRetornoBancos.getIdContaCorrente());
        Sessao sessao = SessaoUtil.getSessao();
        if (ContaCorrenteRN.getInstance().possuiIntegracaoOnline(contaCorrente)) {
            return ArquivoRetornoCommonRN.getInstance().buscaArquivosRetornoAPI(sessao, contaCorrente, filtroRetornoBancos.getDataInicio(), filtroRetornoBancos.getDataFim());
        }
        throw new UnicoMensagemUsuarioException("BLG010", "Conta corrente n\u00e3o possui integra\u00e7\u00e3o");
    }

    @RequestMapping(value={"/atualizar-cobranca"}, method={RequestMethod.POST})
    @DBAutoCommit
    public OcorrenciaCobranca atualizarDadosCobranca(@RequestBody DocumentoRetornoWrapper wrapper) {
        boolean isConsideraTaxa = ParametroCobrancaRN.getInstance().isParametroTrue(wrapper.getIdContaCorrente(), "consideraTaxaCobranca");
        ProcessarArquivoRetornoRN.getInstance().atualizaDadosDocumento(wrapper.getFinanceiroDado(), wrapper.getOcorrenciaCobranca(), isConsideraTaxa);
        return wrapper.getOcorrenciaCobranca();
    }

    @RequestMapping(value={"/gravar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gravarArquivoRetorno(@RequestBody ProcessarRetornoWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)wrapper.getArquivosRetorno())) {
            throw new UnicoMensagemUsuarioException("WCBE63", "Selecione pelo menos um arquivo de retorno.");
        }
        boolean temOcorrencias = wrapper.getArquivosRetorno().stream().anyMatch(arquivoRetorno -> !ListMapUtil.listNullOrEmpty((List)arquivoRetorno.getOcorrenciasCobranca()));
        if (!temOcorrencias) {
            throw new UnicoMensagemUsuarioException("WCBE64", "Os arquivos selecionados n\u00e3o possuem nenhuma ocorr\u00eancia de cobran\u00e7a");
        }
        boolean exiteDocBaixadosAnteriormente = false;
        for (ArquivoRetorno arquivoRetorno2 : wrapper.getArquivosRetorno()) {
            if (arquivoRetorno2.getOcorrenciasCobranca() == null || arquivoRetorno2.getOcorrenciasCobranca().isEmpty()) continue;
            arquivoRetorno2.setDataLeitura(DataHoraFactory.getData());
            ArquivoRetornoRN.getInstance().incluir(arquivoRetorno2, SessaoUtil.getSessao());
            for (OcorrenciaCobranca ocorrenciaCobranca : arquivoRetorno2.getOcorrenciasCobranca()) {
                if (!ocorrenciaCobranca.isFoiBaixado()) continue;
                exiteDocBaixadosAnteriormente = true;
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Uniplusweb-doc-baixados", exiteDocBaixadosAnteriormente ? "true" : "false");
        headers.add("Content-Disposition", "attachment;filename=francesinha.pdf");
        if (wrapper.isImprimirFrancesinha()) {
            byte[] contents = FrancesinhaRelatorio.getInstance().getRemessa(wrapper.getArquivosRetorno()).getMalote().extrai("pdf");
            headers.setContentType(MediaType.APPLICATION_PDF);
            return new ResponseEntity((Object)contents, (MultiValueMap)headers, HttpStatus.OK);
        }
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.OK);
    }
}

