/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.conciliacaorecebimento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.conciliacaorecebimento.IntegracaoConciliacaoRecebimento;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.ItemComboBox;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.Coalesce;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.FiltroGridWrapper;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.TipoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.financeiro.BandeiraConciflex;
import br.intelidata.commons.domain.pojo.financeiro.ConciliacaoRecebimento;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteLancamento;
import br.intelidata.commons.domain.pojo.financeiro.OperadoraConciflex;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.conciliacaorecebimento.enums.StatusConciliacaoGrid;
import br.intelidata.commons.modulo.financeiro.conciliacaorecebimento.enums.StatusConciliacaoRecebimento;
import br.intelidata.commons.modulo.financeiro.enums.OperacaoLancamentoFinanceiro;
import br.intelidata.commons.modulo.financeiro.regranegocio.BancoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.BandeiraConciflexRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ConciliacaoRecebimentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ConfiguracaoConciliadoraRecebimentoFilialRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.OperadoraConciflexRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.conciliacaorecebimento.ConciliacaoRecebimentoCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.conciliacaorecebimento.ConciliacaoRecebimentoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.conciliacaorecebimento.filtrogrid.FiltroGridEmissao;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.conciliacaorecebimento.filtrogrid.FiltroGridFilial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/conciliacao-recebimentos"})
@SubMenuMapping(MENU="SubMenuFinanceiroGeral", NOME="Concilia\u00e7\u00e3o de recebimentos", ICONE="icon-e-moeda", ROTA="/financeiros/conciliacao-recebimentos", PROGRAMA=1131)
public class ConciliacaoRecebimentoCrudController
extends CrudController<ConciliacaoRecebimento, ConciliacaoRecebimentoRN> {
    private final TaskManager taskManager;

    public ConciliacaoRecebimentoCrudController(TaskManager taskManager) {
        super((AbstractRegraNegocio)ConciliacaoRecebimentoRN.getInstance(), ConciliacaoRecebimento::new, true, true, false);
        this.taskManager = taskManager;
    }

    protected GridBuilder<ConciliacaoRecebimentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL(new Coalesce("idFilial", "-1"), "idFilial", new String[0]));
        colunas.add(new ColunaSQL("lancamentoDebito", "Lan\u00e7amento d\u00e9bito", 0, false));
        colunas.add(new ColunaSQL("emissao", "dataDe", "Emiss\u00e3o", 0, false, new String[0]));
        colunas.add(new ColunaSQL("emissao", "dataAte", "Emiss\u00e3o", 0, false, new String[0]));
        if (LicencaManager.getInstance().isMultiFilial()) {
            colunas.add(new ColunaSQL("codigoFilial", "Filial", 80, true));
        }
        colunas.add(new ColunaSQL("tipoDocumentoConciliacao", "Tipo", 150, true));
        colunas.add(new ColunaSQL("documento", "Documento", 150, true));
        colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 100, true));
        colunas.add(new ColunaSQL("nsu", "Nsu", 100, true));
        colunas.add(new ColunaSQL("parcela", "Parcela", 100, true));
        colunas.add(new ColunaSQL("contaCorrente", "Conta corrente", 250, true));
        colunas.add(new ColunaSQL("vencimentoSistema", "Sistema", 100, true).setNomeCabecalho("Vencimento"));
        colunas.add(new ColunaSQL("dataPrevisao", "Conciliadora", 120, true).setNomeCabecalho("Vencimento"));
        colunas.add(new ColunaSQL("valorBrutoSistema", "Sistema", 120, true).setNomeCabecalho("Valor da venda"));
        colunas.add(new ColunaSQL("valorBruto", "Conciliadora", 120, true).setNomeCabecalho("Valor da venda"));
        colunas.add(new ColunaSQL("taxaPercentualSistema", "Sistema", 120, true).setNomeCabecalho("%Taxa"));
        colunas.add(new ColunaSQL("taxaPercentual", "Conciliadora", 120, true).setNomeCabecalho("%Taxa"));
        colunas.add(new ColunaSQL("valorTaxaSistema", "Sistema", 120, true).setNomeCabecalho("Valor da taxa"));
        colunas.add(new ColunaSQL("valorTaxa", "Conciliadora", 120, true).setNomeCabecalho("Valor da taxa"));
        colunas.add(new ColunaSQL("tarifaTransacaoSistema", "Sistema", 120, true).setNomeCabecalho("Tarifa"));
        colunas.add(new ColunaSQL("tarifaTransacao", "Conciliadora", 120, true).setNomeCabecalho("Tarifa"));
        colunas.add(new ColunaSQL("taxaAntecipacao", "Sistema", 120, true).setNomeCabecalho("Valor da antecipa\u00e7\u00e3o"));
        colunas.add(new ColunaSQL("valorTaxaAntecipacao", "Conciliadora", 120, true).setNomeCabecalho("Valor da antecipa\u00e7\u00e3o"));
        colunas.add(new ColunaSQL("valorLiquidoSistema", "Sistema", 120, true).setNomeCabecalho("Valor l\u00edquido"));
        colunas.add(new ColunaSQL("valorLiquido", "Conciliadora", 120, true).setNomeCabecalho("Valor l\u00edquido"));
        colunas.add(new ColunaSQL("statusConciliacaoRecebimento", "Status", 180, true));
        colunas.add(new ColunaSQL("observacoes", "Observa\u00e7\u00e3o sobre o lan\u00e7amento", 300, true));
        colunas.add(new ColunaSQL("criticaSistema", "Cr\u00edticas do sistema", 300, true));
        GridBuilder grid = new GridBuilder(ConciliacaoRecebimentoRN.getInstance().getTabela(), colunas);
        grid.addOrdem(new Ordem("emissao"));
        return grid;
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        super.prepareGrid();
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridEmissao());
        this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridFilial());
    }

    protected String getCacheId() {
        return "conciliacao-recebimentos";
    }

    @RequestMapping(value={"/exibir-filial"})
    @DBAutoCommit
    public boolean exibirFilial() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        return LicencaManager.getInstance().isEnterprise() && ConfiguracaoConciliadoraRecebimentoFilialRN.getInstance().isPossuiMaisDeUmaFilialLicenciadaHabilitada(sessao);
    }

    @RequestMapping(value={"/tipo-documento-conciliacao-recebimento"})
    @DBAutoCommit
    public List<TipoDocumentoFinanceiro> buscarTipoDocumentoConciliacaoRecebimento() {
        return TipoDocumentoFinanceiroRN.getInstance().buscarTipoDocumentoConciliacaoRecebimentoWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/combo-operadoras"})
    @DBAutoCommit
    public List<ItemComboBox> getComboOperadoras() throws UnicoMensagemUsuarioException {
        return new IntegracaoConciliacaoRecebimento(SessaoUtil.getSessao()).getComboOperadoraWeb();
    }

    @RequestMapping(value={"/combo-produtos"})
    @DBAutoCommit
    public List<ItemComboBox> getComboProdutos() throws UnicoMensagemUsuarioException {
        return new IntegracaoConciliacaoRecebimento(SessaoUtil.getSessao()).getComboProdutoWeb();
    }

    @RequestMapping(value={"/combo-bandeiras"})
    @DBAutoCommit
    public List<ItemComboBox> getComboBandeiras() throws UnicoMensagemUsuarioException {
        return new IntegracaoConciliacaoRecebimento(SessaoUtil.getSessao()).getComboBandeiraWeb();
    }

    @RequestMapping(value={"/atualizar-operadoras"})
    @DBTransaction
    public void buscarOperadoras() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        IntegracaoConciliacaoRecebimento integracao = new IntegracaoConciliacaoRecebimento(sessao);
        integracao.atualizarOperadoras(sessao, null, true);
        this.notificationService.notifyUser(sessao.getIdUsuario(), "Operadoras atualizadas.", TipoNotificacaoSimples.SUCCESS, NotificationType.SIMPLE_NOTIFICATION);
    }

    @RequestMapping(value={"/atualizar-bandeiras"})
    @DBTransaction
    public void buscarBandeiras() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        IntegracaoConciliacaoRecebimento integracao = new IntegracaoConciliacaoRecebimento(sessao);
        integracao.atualizarBandeiras(sessao, null, true);
        this.notificationService.notifyUser(sessao.getIdUsuario(), "Bandeiras atualizadas.", TipoNotificacaoSimples.SUCCESS, NotificationType.SIMPLE_NOTIFICATION);
    }

    @RequestMapping(value={"/atualizar-produtos"})
    @DBTransaction
    public void buscarProdutos() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        IntegracaoConciliacaoRecebimento integracao = new IntegracaoConciliacaoRecebimento(sessao);
        integracao.atualizarProdutosConciliadora(sessao, null, true);
        this.notificationService.notifyUser(sessao.getIdUsuario(), "Produtos atualizados.", TipoNotificacaoSimples.SUCCESS, NotificationType.SIMPLE_NOTIFICATION);
    }

    @RequestMapping(value={"/sincronizar"})
    @DBTransaction
    public void sincronizar() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        IntegracaoConciliacaoRecebimento integracao = new IntegracaoConciliacaoRecebimento(sessao);
        integracao.validarCadastrosAdministradoraBandeira(sessao);
        1 createTask = new /* Unavailable Anonymous Inner Class!! */;
        createTask.createTask(null);
        this.notificationService.notifyUser(SessaoUtil.getSessao().getIdUsuario(), "Sincroniza\u00e7\u00e3o agendado com sucesso. Voc\u00ea ser\u00e1 notificado quando o processo for conclu\u00eddo.", TipoNotificacaoSimples.SUCCESS, NotificationType.SIMPLE_NOTIFICATION);
    }

    @RequestMapping(value={"/configurar-botoes"})
    @DBAutoCommit
    public Map<String, Boolean> configurarBotoes(@RequestParam Long id) {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        ConciliacaoRecebimento conciliacaoRecebimento = (ConciliacaoRecebimento)ConciliacaoRecebimentoRN.getInstance().buscarPorId(id);
        if (conciliacaoRecebimento != null) {
            Long idFinanceiro = conciliacaoRecebimento.getIdFinanceiro();
            Long idContaCorrente = conciliacaoRecebimento.getIdContaCorrente();
            Long idContaCorrenteLancamento = conciliacaoRecebimento.getIdContaCorrenteLancamento();
            StatusConciliacaoRecebimento status = conciliacaoRecebimento.getStatusConciliacaoRecebimento();
            boolean isBtnVisualizar = !Util.longNullOuZero((Long)idFinanceiro) || !Util.longNullOuZero((Long)idContaCorrente) && !Util.longNullOuZero((Long)idContaCorrenteLancamento);
            boolean isBtnGerarRecebimento = StatusConciliacaoRecebimento.ADVERTENCIA.equals((Object)status) && Util.longNullOuZero((Long)idFinanceiro) && Util.longNullOuZero((Long)idContaCorrente);
            boolean isBtnDesconsiderarRecebimento = StatusConciliacaoRecebimento.NAO_LOCALIZADO.equals((Object)status);
            config.put("visualizar", isBtnVisualizar);
            config.put("gerarRecebimento", isBtnGerarRecebimento);
            config.put("desconsiderarRecebimento", isBtnDesconsiderarRecebimento);
        }
        return config;
    }

    @RequestMapping(value={"/gerar-recebimento"})
    @DBAutoCommit
    public ConciliacaoRecebimentoWrapper gerarRecebimento(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        ConciliacaoRecebimentoWrapper wrapper = new ConciliacaoRecebimentoWrapper();
        ConciliacaoRecebimento conciliacaoRecebimento = (ConciliacaoRecebimento)ConciliacaoRecebimentoRN.getInstance().buscarPorId(id);
        if (conciliacaoRecebimento != null) {
            if (!StatusConciliacaoRecebimento.ADVERTENCIA.equals((Object)conciliacaoRecebimento.getStatusConciliacaoRecebimento())) {
                throw new UnicoMensagemUsuarioException("FIN492", "O recebimento n\u00e3o pode ser gerado pois o status deve estar como 'Advert\u00eancia'.");
            }
            if (Util.longNullOuZero((Long)conciliacaoRecebimento.getIdFinanceiro()) && Util.longNullOuZero((Long)conciliacaoRecebimento.getIdContaCorrente())) {
                boolean isGerarDocumento;
                boolean bl = isGerarDocumento = (!Util.longNullOuZero((Long)conciliacaoRecebimento.getIdOperadoraConciflex()) || !Util.longNullOuZero((Long)conciliacaoRecebimento.getIdBandeiraConciflex())) && EnumSimNao.NAO.equals((Object)conciliacaoRecebimento.getLancamentoDebito());
                if (isGerarDocumento) {
                    BandeiraConciflex bandeiraConciflex;
                    FinanceiroDado financeiroDado = new FinanceiroDado();
                    financeiroDado.setTipo(TipoFinanceiro.RECEBER.getId());
                    financeiroDado.setEmissao(conciliacaoRecebimento.getDataVenda());
                    financeiroDado.setEntrada(conciliacaoRecebimento.getDataVenda());
                    financeiroDado.setVencimento(conciliacaoRecebimento.getDataPrevisao());
                    financeiroDado.setDataReferencia(conciliacaoRecebimento.getDataPrevisao());
                    financeiroDado.setValor(conciliacaoRecebimento.getValorBruto());
                    financeiroDado.setTipoOrigem(Integer.valueOf(-31));
                    financeiroDado.setIdOrigem(conciliacaoRecebimento.getId());
                    String administradora = "";
                    if (!Util.longNullOuZero((Long)conciliacaoRecebimento.getIdOperadoraConciflex())) {
                        Long idAdquirente;
                        OperadoraConciflex operadoraConciflex = OperadoraConciflexRN.getInstance().buscarOperadoraPorCodigo(Integer.valueOf(conciliacaoRecebimento.getIdOperadoraConciflex().intValue()));
                        if (operadoraConciflex != null) {
                            administradora = operadoraConciflex.getDescricao();
                        }
                        if (!Util.longNullOuZero((Long)(idAdquirente = EntidadeRN.getInstance().getIdAdquirentePorCodigoOperadoraConciflex(Integer.valueOf(conciliacaoRecebimento.getIdOperadoraConciflex().intValue()))))) {
                            financeiroDado.setIdEntidade(idAdquirente);
                        }
                    }
                    String bandeira = "";
                    if (!Util.longNullOuZero((Long)conciliacaoRecebimento.getIdBandeiraConciflex()) && (bandeiraConciflex = BandeiraConciflexRN.getInstance().buscarBandeiraPorCodigo(Integer.valueOf(conciliacaoRecebimento.getIdBandeiraConciflex().intValue()))) != null) {
                        bandeira = bandeiraConciflex.getDescricao();
                    }
                    String complemento = conciliacaoRecebimento.getFormaPagamentoConciflex() != null ? ". (" + conciliacaoRecebimento.getFormaPagamentoConciflex().getDescricao() + ")" : "";
                    complemento = complemento + (!administradora.isEmpty() ? " - Administradora: " + administradora : "");
                    complemento = complemento + (!bandeira.isEmpty() ? " - Bandeira: " + bandeira : "");
                    financeiroDado.setHistorico("Lan\u00e7amento gerado pela concilia\u00e7\u00e3o de recebimentos" + complemento);
                    wrapper.setFinanceiroDado(financeiroDado);
                } else {
                    Banco banco;
                    ContaCorrente contaCorrente = null;
                    if (!Util.stringNullOrEmpty((String)conciliacaoRecebimento.getCodigoBanco()) && (banco = (Banco)BancoRN.getInstance().getDao().buscarPorCodigo(conciliacaoRecebimento.getCodigoBanco())) != null) {
                        contaCorrente = ContaCorrenteRN.getInstance().buscaContaCorrentePorBancoAgenciaConta(banco.getId(), conciliacaoRecebimento.getAgencia(), conciliacaoRecebimento.getConta());
                    }
                    ContaCorrenteLancamento contaCorrenteLancamento = new ContaCorrenteLancamento();
                    if (contaCorrente != null) {
                        contaCorrenteLancamento.setIdcontacorrente(contaCorrente.getId());
                    }
                    contaCorrenteLancamento.setOperacao(OperacaoLancamentoFinanceiro.SAIDA);
                    contaCorrenteLancamento.setIdConciliacaoRecebimento(conciliacaoRecebimento.getId());
                    contaCorrenteLancamento.setDatahora(conciliacaoRecebimento.getDataVenda());
                    contaCorrenteLancamento.setValor(conciliacaoRecebimento.getValorBruto().abs());
                    if (EnumSimNao.SIM.equals((Object)conciliacaoRecebimento.getLancamentoDebito())) {
                        contaCorrenteLancamento.setHistorico(conciliacaoRecebimento.getObservacoes());
                    } else {
                        contaCorrenteLancamento.setHistorico("Lan\u00e7amento gerado pela concilia\u00e7\u00e3o de recebimentos");
                    }
                    wrapper.setContaCorrenteLancamento(contaCorrenteLancamento);
                }
            } else {
                throw new UnicoMensagemUsuarioException("WFIN481", "O recebimento n\u00e3o pode ser lan\u00e7ado, pois j\u00e1 existe um documento ou lan\u00e7amento na conta corrente.");
            }
        }
        return wrapper;
    }

    @RequestMapping(value={"/visualizar"})
    @DBAutoCommit
    public ConciliacaoRecebimentoWrapper visualizar(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        ConciliacaoRecebimentoWrapper wrapper = new ConciliacaoRecebimentoWrapper();
        ConciliacaoRecebimento conciliacaoRecebimento = (ConciliacaoRecebimento)ConciliacaoRecebimentoRN.getInstance().buscarPorId(id);
        if (conciliacaoRecebimento != null) {
            if (!Util.longNullOuZero((Long)conciliacaoRecebimento.getIdFinanceiro())) {
                wrapper.setIdFinanceiro(conciliacaoRecebimento.getIdFinanceiro());
            } else if (!Util.longNullOuZero((Long)conciliacaoRecebimento.getIdContaCorrente()) && !Util.longNullOuZero((Long)conciliacaoRecebimento.getIdContaCorrenteLancamento())) {
                wrapper.setIdContaCorrenteLancamento(conciliacaoRecebimento.getIdContaCorrenteLancamento());
            } else {
                throw new UnicoMensagemUsuarioException("WFIN463", "N\u00e3o foi poss\u00edvel encontrar o registro para visualiza\u00e7\u00e3o.");
            }
        }
        return wrapper;
    }

    @PostMapping(value={"/buscar-status-conciliacao-por-filtro"})
    @DBAutoCommit
    public StatusConciliacaoGrid getStatusConciliacao(@RequestBody FiltroGridWrapper filtro) throws UnicoMensagemUsuarioException {
        List ids = this.getListaIDs(filtro.getQuery(), filtro.getFilter());
        List lista = ConciliacaoRecebimentoRN.getInstance().buscarValoresPorIDs(ids.toArray(new Long[0]), new String[]{"statusConciliacaoRecebimento"});
        List listaStatus = lista.stream().map(map -> (StatusConciliacaoRecebimento)EnumUtils.getPorId(StatusConciliacaoRecebimento.class, map.get("statusConciliacaoRecebimento"))).collect(Collectors.toList());
        return ConciliacaoRecebimentoRN.getInstance().buscarStatusGrid(listaStatus);
    }

    @PostMapping(value={"/desconsiderar-recebimento"})
    @DBTransaction
    public void desconsiderarRecebimento(@RequestBody ConciliacaoRecebimentoWrapper wrapper) throws UnicoMensagemUsuarioException {
        List lista = ConciliacaoRecebimentoRN.getInstance().buscarListaPorIdsSqlUnico(wrapper.getIds());
        ConciliacaoRecebimentoRN.getInstance().marcarConciliacaoComoDesconsiderado(SessaoUtil.getSessao(), lista);
    }

    static /* synthetic */ TaskManager access$000(ConciliacaoRecebimentoCrudController x0) {
        return x0.taskManager;
    }
}

