/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.job;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.wrapper.EmailCartaCobrancaWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JobEmailCartaCobranca
extends AbstractPrepareJob {
    private List<String> criticas;
    private final TaskManager taskManager = (TaskManager)BeanUtil.getBean((String)"taskManager");

    public JobEmailCartaCobranca(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        EmailCartaCobrancaWrapper cobrancaWrapper = (EmailCartaCobrancaWrapper)this.getObjetoDeserializado(EmailCartaCobrancaWrapper.class);
        TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(cobrancaWrapper.getIdTextoGenerico());
        List documentos = FinanceiroDadoRN.getInstance().buscarListaPorIds(cobrancaWrapper.getIdsFinanceiros());
        Map mapClientes = FinanceiroDadoRN.getInstance().montaTextoCartaCobranca(SessaoUtil.getSessao(), textoGenerico, documentos);
        this.criticas = new ArrayList();
        for (Map.Entry entry : mapClientes.entrySet()) {
            Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId((Long)entry.getKey());
            if (cliente == null) continue;
            String email = cliente.getEmailFinanceiro();
            if (StringUtil.stringNullOrEmpty((String)email)) {
                email = cliente.getEmail();
            }
            if (StringUtil.stringNullOrEmpty((String)email)) {
                this.criticas.add(cliente.toString());
                continue;
            }
            String assunto = textoGenerico.getLocalUso().isExibirAssunto() && !Util.stringNullOrEmpty((String)textoGenerico.getAssunto()) ? textoGenerico.getAssunto() : "A/C do financeiro";
            ParametrosEmailWeb parametrosEmailWeb = EmailUtil.getParametros((Sessao)SessaoUtil.getSessao(), (String)email, null, (String)assunto, (String)((String)entry.getValue()));
            CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb);
            taskEmail.createTask((Object)parametrosEmailWeb, this.getTask().getUuid(), parametrosEmailWeb.getAssunto(), false);
        }
        if (!this.criticas.isEmpty()) {
            this.addMensagemRetorno("", this.getCriticas(this.criticas));
        }
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        if (!this.criticas.isEmpty()) {
            return new Notificacao(TipoNotificacaoSimples.WARNING, "Alguns e-mails n\u00e3o foram agendados no envio de carta de cobra\u00e7a! Verifique.");
        }
        return null;
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao(TipoNotificacaoSimples.ERROR, "Ocorreu um erro ao agendar o envio de carta de cobran\u00e7a! Verifique.");
    }

    private String getCriticas(List<String> clientes) {
        StringBuilder msg = new StringBuilder();
        msg.append("Alguns e-mails n\u00e3o foram agendados\n");
        msg.append("Os clientes abaixo n\u00e3o possuem e-mail configurados.\n");
        clientes.forEach(cliente -> msg.append((String)cliente).append("\n"));
        return msg.toString();
    }
}

