/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.pagar;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.bancoonline.IntegracaoBancoOnline;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.modulo.financeiro.bancoonline.BancoOnlineRetornoPagamento;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.PropriedadeService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.FinanceiroCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.pagar.PagamentoOnlineWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="contas_pagar", QUANTIDADE=QuantidadeCampoExtra.CONTAS_RECEBER_PAGAR)
@RestController
@RequestMapping(value={"/api/financeiros-contas-pagar"})
@SubMenuMapping(MENU="SubMenuFinanceiroGeral", NOME="Contas a Pagar", ICONE="icon-e-money1", ROTA="/financeiros/financeiros-contas-pagar", PROGRAMA=403)
public class FinanceiroContasPagarCrudController
extends FinanceiroCrudController {
    @Autowired
    public FinanceiroContasPagarCrudController(ResponseEntityService responseEntityService, PropriedadeService propriedadeService, FuncionalidadeService funcionalidadeService, TaskManager taskManage) {
        super(responseEntityService, propriedadeService, funcionalidadeService, TipoFinanceiro.PAGAR, taskManage);
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        HashMap mapContaCorrente = new HashMap();
        boolean existeColunaBanco = colunas.stream().anyMatch(coluna -> "banco".equals(coluna.getTabela()));
        if (existeColunaBanco) {
            dados.forEach(registro -> {
                Long idBanco = (Long)registro[this.getIndexColuna("idBanco", colunas)];
                String aliasCodigoBanco = this.getAliasColunaTabelaBanco("codigo", colunas);
                String aliasNomeBanco = this.getAliasColunaTabelaBanco("nome", colunas);
                if (!Util.longNullOuZero((Long)idBanco)) {
                    String acaoTipoDoc = (String)registro[this.getIndexColuna("acaoTipoDoc", colunas)];
                    if (TipoAcaoFinanceiro.CHEQUE.getDescricao().equals(acaoTipoDoc) || TipoAcaoFinanceiro.CHEQUE.name().equals(acaoTipoDoc)) {
                        ContaCorrente contaCorrente = (ContaCorrente)mapContaCorrente.get(idBanco);
                        if (contaCorrente == null) {
                            contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idBanco);
                            mapContaCorrente.put(idBanco, contaCorrente);
                        }
                        if (contaCorrente != null) {
                            if (aliasCodigoBanco != null) {
                                registro[this.getIndexColuna((String)aliasCodigoBanco, (List)colunas)] = contaCorrente.getCodigo();
                            }
                            if (aliasNomeBanco != null) {
                                registro[this.getIndexColuna((String)aliasNomeBanco, (List)colunas)] = contaCorrente.getDescricao();
                            }
                        }
                    }
                }
            });
        }
    }

    @RequestMapping(value={"/consultar-pagamento-online"})
    @DBAutoCommit
    public BancoOnlineRetornoPagamento consultarDocumentoOnlinePagamento(@RequestParam Long idFinanceiro) throws UnicoMensagemUsuarioException {
        ContaCorrente conta = null;
        FinanceiroDado financeiro = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(idFinanceiro);
        if (financeiro == null) {
            return null;
        }
        if (!Util.longNullOuZero((Long)financeiro.getIdContaGeraBoleto())) {
            conta = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(financeiro.getIdContaGeraBoleto());
        } else {
            List contasComIntegracaoAPI = ContaCorrenteRN.getInstance().buscarContas(Contexto.getInstance().getSessao(), true);
            if (!Util.listNullOrEmpty((List)contasComIntegracaoAPI) && contasComIntegracaoAPI.size() == 1) {
                conta = (ContaCorrente)contasComIntegracaoAPI.get(0);
            }
        }
        if (conta != null) {
            return new IntegracaoBancoOnline(SessaoUtil.getSessao(), conta).consultarPagamento(financeiro);
        }
        return null;
    }

    @RequestMapping(value={"/pagamento-online"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void baixarOnline(@RequestBody PagamentoOnlineWrapper pagamentoOnline) throws UnicoMensagemUsuarioException {
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(pagamentoOnline.getIdContaCorrente());
        List documentos = FinanceiroDadoRN.getInstance().buscarListaPorIds(pagamentoOnline.getIdsDocumentos());
        FinanceiroDadoRN.getInstance().pagarBoletosViaAPI(SessaoUtil.getSessao(), contaCorrente, documentos);
    }

    @RequestMapping(value={"/contas-integradas"})
    @DBAutoCommit
    public List<ContaCorrente> contasIntegradas() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ArrayList<ContaCorrente> contasFiltradas = new ArrayList<ContaCorrente>();
        List contaCorrentes = ContaCorrenteRN.getInstance().buscarContas(SessaoUtil.getSessao(), true);
        for (ContaCorrente conta : contaCorrentes) {
            if (!new IntegracaoBancoOnline(sessao, conta).possuiPagamentoOnline()) continue;
            contasFiltradas.add(conta);
        }
        return contasFiltradas;
    }

    private String getAliasColunaTabelaBanco(String nomeColuna, List<ColunaSQL> colunas) {
        Optional<ColunaSQL> filter = colunas.stream().filter(c -> "banco".equals(c.getTabela()) && nomeColuna.equals(c.getNome())).findFirst();
        return filter.map(ColunaSQL::getAlias).orElse(null);
    }
}

