/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.gerenciadorlicenca;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.licenca.ProdutoLicenca;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloFuncionalidadeBackupRNSimplificada;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.LicencaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.GerenciadorLicencaManager;
import br.intelidata.uniplusweb.web.rest.app.crud.gerenciadorlicenca.DadosLicencaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.gerenciadorlicenca.LicencaRequestWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.LicencaWrapper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gerenciador-licencas"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Gerenciador de licen\u00e7as", ROTA="/licencas/gerenciador-licencas", PROGRAMA=508, ICONE="icon-gerenciar-licencas")
public class GerenciadorLicencaSimpleController {
    private final GerenciadorLicencaManager gerenciadorLicencaManager;
    private final ResponseEntityService service;

    public GerenciadorLicencaSimpleController(GerenciadorLicencaManager gerenciadorLicencaManager, ResponseEntityService service) {
        this.gerenciadorLicencaManager = gerenciadorLicencaManager;
        this.service = service;
    }

    @RequestMapping(value={"/licencas-instaladas"})
    @DBAutoCommit
    public List<LicencaWrapper> getLicencasInstaladas() {
        List licencas = LicencaRN.getInstance().getLicencasInstaladas();
        if (!ListMapUtil.listNullOrEmpty((List)licencas)) {
            return licencas.stream().map(LicencaWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @RequestMapping(value={"/licencas-instaladas-combo"})
    @DBAutoCommit
    public List<LicencaWrapper> getLicencasInstaladasCombo() {
        List licencas = LicencaRN.getInstance().getLicencasInstaladasCombo(false);
        if (!ListMapUtil.listNullOrEmpty((List)licencas)) {
            return licencas.stream().map(LicencaWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @RequestMapping(value={"/pedido-instalacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public DadosLicencaWrapper pedidoInstalacao(@RequestBody LicencaRequestWrapper request) throws UnicoMensagemUsuarioException {
        String tenant = ContextoHolder.getTenant();
        ConfiguradorModuloFuncionalidadeBackupRNSimplificada.getInstance().gerarBackup(SessaoUtil.getSessao());
        return this.gerenciadorLicencaManager.pedidoInstalacao(request, tenant);
    }

    @RequestMapping(value={"/finalizar-pedido-instalacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void finalizarPedidoInstalacao(@RequestBody DadosLicencaWrapper dadosLicenca) throws UnicoMensagemUsuarioException {
        this.gerenciadorLicencaManager.finalizarPedidoInstalacao(dadosLicenca);
    }

    @RequestMapping(value={"/reinstalar-licencas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public DadosLicencaWrapper reinstalarLicencas(@RequestBody LicencaRequestWrapper request) throws UnicoMensagemUsuarioException {
        String tenant = ContextoHolder.getTenant();
        ConfiguradorModuloFuncionalidadeBackupRNSimplificada.getInstance().gerarBackup(SessaoUtil.getSessao());
        return this.gerenciadorLicencaManager.reinstalarLicencas(request, tenant);
    }

    @RequestMapping(value={"/finalizar-reinstalacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void finalizarReinstalacao(@RequestBody DadosLicencaWrapper dadosLicenca) throws UnicoMensagemUsuarioException {
        this.gerenciadorLicencaManager.finalizarReinstalacao(dadosLicenca);
    }

    @RequestMapping(value={"/contrato"})
    @DBAutoCommit
    public ResponseEntity<String> getTextoContrato() throws UnicoMensagemUsuarioException {
        return ResponseEntity.ok((Object)this.gerenciadorLicencaManager.getTextoContrato());
    }

    @RequestMapping(value={"/aceite-contrato"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void aceiteContrato(@RequestBody LicencaRequestWrapper request) throws UnicoMensagemUsuarioException {
        this.gerenciadorLicencaManager.aceiteContrato(request);
    }

    @PostMapping(value={"/atualizar-informacoes"})
    @DBAutoCommit
    public void atualizarInformacoes() throws UnicoMensagemUsuarioException {
        this.gerenciadorLicencaManager.verificarLicenca(ContextoHolder.getTenant());
    }

    @RequestMapping(value={"/relatorio"})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarRelatorio() throws UnicoMensagemUsuarioException {
        Remessa remessa = ConfiguradorModuloFuncionalidadeBackupRNSimplificada.getInstance().gerarRelatorio(SessaoUtil.getSessao());
        return this.service.createPDFResponse(remessa.getMalote().extrai("pdf"));
    }

    @RequestMapping(value={"/validar-licenca-instalada-filiais"})
    @DBAutoCommit
    public void validarLicencaInstaladaPorFilial(@RequestParam ProdutoLicenca licenca) throws UnicoMensagemUsuarioException {
        LicencaManager.getInstance().validarLicencaPorFilial(licenca, FilialRN.getInstance().buscarLista());
    }
}

