/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.grupo;

import br.intelidata.commons.domain.pojo.HierarquiaGrupoProduto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.modulo.produto.regranegocio.HierarquiaGrupoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.wrapper.AtualizacaoGrupoWrapper;
import java.util.Objects;

public class JobAtualizacaoGrupo
extends AbstractPrepareJob {
    private int qtdRegistros;
    private HierarquiaGrupoProduto grupoProduto;

    public JobAtualizacaoGrupo(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao(this.qtdRegistros + " produtos do grupo " + this.grupoProduto.getNome() + " foram atualizados.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Ocorreu um erro ao atualizar os produtos do grupo " + this.grupoProduto.getNome());
    }

    public void execute() throws Exception {
        AtualizacaoGrupoWrapper params = (AtualizacaoGrupoWrapper)Objects.requireNonNull(JsonUtil.fromJson((String)this.getParameters(), AtualizacaoGrupoWrapper.class));
        this.grupoProduto = (HierarquiaGrupoProduto)HierarquiaGrupoProdutoRN.getInstance().buscarPorId(params.getIdHierarquia());
        this.qtdRegistros = ProdutoRN.getInstance().atualizarProdutosPorGrupo(this.getSessao(), this.grupoProduto, params.isReplicarCamposEmBranco());
        this.addMensagemRetorno(this.qtdRegistros + " produtos do grupo " + this.grupoProduto.getNome() + " foram atualizados.");
    }
}

