/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.imagem;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.CadastroImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.CadastroImagemRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastros-imagem"})
@SubMenuMapping(MENU="SubMenuEstoqueAuxiliar", NOME="Imagens", ROTA="/estoques/cadastros-imagem", PROGRAMA=36)
public class CadastroImagemCrudController
extends CrudController<CadastroImagem, CadastroImagemRN> {
    public CadastroImagemCrudController() {
        super((AbstractRegraNegocio)CadastroImagemRN.getInstance(), CadastroImagem::new, true, true, TipoArquivoArmazenado.Imagem);
    }

    protected GridBuilder<CadastroImagemRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        return new GridBuilder(CadastroImagemRN.getInstance().getTabela(), colunas);
    }

    protected void beforeRead(CadastroImagem cadastroImagem, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)cadastroImagem.getCaminhoImagem())) {
            cadastroImagem.setCaminhoImagem(this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Imagem, TipoImagem.Pequena, cadastroImagem.getCaminhoImagem()));
        }
    }

    protected void beforeUpdate(CadastroImagem cadastroImagem, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String caminhoOriginal = (String)CadastroImagemRN.getInstance().buscarValorPorID(cadastroImagem.getId(), "caminhoImagem");
        if (!StringUtil.stringNullOrEmpty((String)caminhoOriginal)) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Imagem, TipoImagem.Pequena, caminhoOriginal);
            if (StringUtil.stringNullOrEmpty((String)cadastroImagem.getCaminhoImagem()) || !cadastroImagem.getCaminhoImagem().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, caminhoOriginal);
            } else {
                cadastroImagem.setCaminhoImagem(caminhoOriginal);
            }
        }
    }

    protected void beforeDelete(CadastroImagem cadastroImagem) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)cadastroImagem.getCaminhoImagem())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Imagem, cadastroImagem.getCaminhoImagem());
        }
    }

    protected String getCacheId() {
        return "cadastros-imagem";
    }
}

