/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.importacao;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.importacao.r2d2.ImportacaoArquivoR2D2;
import br.intelidata.commons.domain.pojo.importacao.r2d2.StatusImportacao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ImportacaoArquivoR2D2CommonRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.importacao.JobImportacaoArquivoR2D2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/importacao-arquivo-r2d2"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliar", NOME="Importa\u00e7\u00e3o de arquivos do R2D2", ROTA="/ferramentas/importacao-arquivo-r2d2", PROGRAMA=513)
public class ImportacaoArquivoR2D2CrudController
extends CrudController<ImportacaoArquivoR2D2, ImportacaoArquivoR2D2CommonRN>
implements ICreateTask {
    private final StorageService storageService;
    private final TaskManager taskManager;
    private final ResponseEntityService responseEntityService;

    public ImportacaoArquivoR2D2CrudController(StorageService storageService, TaskManager taskManager, ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)ImportacaoArquivoR2D2CommonRN.getInstance(), ImportacaoArquivoR2D2::new);
        this.storageService = storageService;
        this.taskManager = taskManager;
        this.responseEntityService = responseEntityService;
    }

    public TipoJob getTipoJob() {
        return TipoJob.IMPORTACAO_R2D2;
    }

    public Class<? extends AbstractJob> job() {
        return JobImportacaoArquivoR2D2.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    protected String getCacheId() {
        return "importacao-arquivo-r2d2";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nomeArquivo", "Arquivo", 800, true));
        colunas.add(new ColunaSQL("dataHora", "Data", 200, true));
        colunas.add(new ColunaSQL("nome", "nomeUsuario", "Usu\u00e1rio", 300, true, new String[]{"fk_importacao_usuario"}));
        colunas.add(new ColunaSQL("tamanho", "Tamanho (kb)", 200, true));
        ColunaSQL colunaStatus = new ColunaSQL("status", "Status", 350, true);
        colunaStatus.setClasseEnum(StatusImportacao.class);
        colunas.add(colunaStatus);
        return new GridBuilder(((ImportacaoArquivoR2D2CommonRN)this.rn).getTabela(), colunas, Collections.singletonList(new Ordem("dataHora", true)));
    }

    @RequestMapping(value={"/processar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void processarArquivo(@RequestPart(value="file") MultipartFile[] files) throws UnicoMensagemUsuarioException, IOException {
        if (ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            throw new UnicoMensagemUsuarioException("WWW686", "Arquivos n\u00e3o informados.");
        }
        for (MultipartFile file : files) {
            String extensao = FilenameUtils.getExtension((String)file.getOriginalFilename());
            String url = this.storageService.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.R2D2, file, extensao, false, true, true);
            ImportacaoArquivoR2D2 importArquivo = new ImportacaoArquivoR2D2();
            importArquivo.setNomeArquivo(FilenameUtils.removeExtension((String)file.getOriginalFilename()));
            importArquivo.setDataHora(DataHoraFactory.getDataHora());
            importArquivo.setTamanho(file.getSize() / 1000L);
            importArquivo.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
            importArquivo.setStatus(StatusImportacao.PENDENTE);
            importArquivo.setUrlArquivo(url);
            this.create((AbstractPojo)importArquivo, Optional.empty());
        }
        this.createTask(null);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> baixarArquivoFalha(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        ImportacaoArquivoR2D2 importacaoArquivoR2D2 = (ImportacaoArquivoR2D2)ImportacaoArquivoR2D2CommonRN.getInstance().buscarPorId(id);
        if (importacaoArquivoR2D2.getStatus().in(new AbstractEnum[]{StatusImportacao.SUCESSO, StatusImportacao.PENDENTE})) {
            throw new UnicoMensagemUsuarioException("WWW685", "N\u00e3o existe retorno a ser baixado");
        }
        File file = this.storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.R2D2, importacaoArquivoR2D2.getUrlArquivoErro(), true, true);
        return this.responseEntityService.createFileResponse(FileUtil.file2ByteArray((File)file), MediaType.APPLICATION_OCTET_STREAM, importacaoArquivoR2D2.getNomeArquivo().concat(".txt"));
    }
}

