/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.enuns.TipoExtensaoPlanilha;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.integracao.EnvioIntegracaoFiscalProduto;
import br.intelidata.commons.domain.pojo.integracao.RetornoIntegracaoFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.integracao.arquivo.ArquivoRemessaIntegracao;
import br.intelidata.commons.modulo.integracao.regranegocio.EnvioIntegracaoFiscalProdutoRN;
import br.intelidata.commons.modulo.integracao.regranegocio.RetornoIntegracaoFiscalProdutoRN;
import br.intelidata.commons.modulo.integracao.regranegocio.RetornoIntegracaoFiscalRN;
import br.intelidata.commons.modulo.integracao.regranegocio.UnicoIntegracaoFiscal;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal.AlteracaoProdutoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal.FiltroProdutoIntegracaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal.IntegracaoFiscalJobWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal.IntegracaoFiscalWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal.LotesIntegracaoFiscalCrudController;
import java.io.IOException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/lotes-integracao-fiscal"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarIntegracaoFiscal", NOME="Lotes de integra\u00e7\u00e3o fiscal", ROTA="/notas-fiscais/lotes-integracao-fiscal", PROGRAMA=1411)
public class LotesIntegracaoFiscalCrudController
extends CrudController<RetornoIntegracaoFiscal, RetornoIntegracaoFiscalRN> {
    private static final int NUMERO_PRODUTOS_JOB_INTEGRACAO_FISCAL = 10;
    private final TaskManager taskManager;

    public LotesIntegracaoFiscalCrudController(TaskManager taskManager) {
        super((AbstractRegraNegocio)RetornoIntegracaoFiscalRN.getInstance(), RetornoIntegracaoFiscal::new);
        this.taskManager = taskManager;
    }

    protected GridBuilder<RetornoIntegracaoFiscalRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("consultaGeral", "geral", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("tipoIntegracaoFiscal", "Tipo", 0, true));
        colunas.add(new ColunaSQL("dataHora", "Data / Hora", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 0, true));
        return new GridBuilder(RetornoIntegracaoFiscalRN.getInstance().getTabela(), colunas);
    }

    @RequestMapping(value={"/importar-arquivo"}, method={RequestMethod.POST})
    @DBTransaction
    public void importarArquivo(@RequestPart(value="file") MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            if (file == null) {
                throw new UnicoMensagemUsuarioException("WWW663", "Arquivo de importa\u00e7\u00e3o n\u00e3o encontrado");
            }
            Sessao sessao = SessaoUtil.getSessao();
            UnicoIntegracaoFiscal integracao = new UnicoIntegracaoFiscal(sessao);
            integracao.importarArquivo(sessao, file.getBytes());
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW664", "Houve um problema na importa\u00e7\u00e3o deste arquivo");
        }
    }

    @RequestMapping(value={"/download-xls"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXLS(@RequestBody(required=false) Long idRetornoIntegracaoFiscal) throws UnicoMensagemUsuarioException {
        UnicoIntegracaoFiscal integracao;
        ArquivoRemessaIntegracao remessaProdutos;
        String nomeArquivo = "produtosIntegracaoFiscal" + Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd-MM-yyyy");
        List idsProdutosIgnorar = null;
        if (!Util.longNullOuZero((Long)idRetornoIntegracaoFiscal)) {
            nomeArquivo = "produtosInexistentesIntegracaoFiscal" + Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd-MM-yyyy");
            idsProdutosIgnorar = RetornoIntegracaoFiscalProdutoRN.getInstance().buscarListaIdsPorRetornoIntegracao(idRetornoIntegracaoFiscal, "idproduto");
        }
        if ((remessaProdutos = (integracao = new UnicoIntegracaoFiscal(SessaoUtil.getSessao())).geraRemessaProdutos(SessaoUtil.getSessao(), idsProdutosIgnorar, null)) == null) {
            throw new UnicoMensagemUsuarioException("WWW662", "N\u00e3o foi poss\u00edvel gerar o arquivo para download");
        }
        return this.responseEntityService.createXLSResponse(remessaProdutos.getByteArrayOutputStream().toByteArray(), nomeArquivo, TipoExtensaoPlanilha.XLS);
    }

    @RequestMapping(value={"/configuracao-integracao-fiscal"})
    @DBAutoCommit
    public IntegracaoFiscalWrapper getConfiguracaoIntegracaoFiscal() throws UnicoMensagemUsuarioException {
        UnicoIntegracaoFiscal integracaoFiscal = new UnicoIntegracaoFiscal(SessaoUtil.getSessao());
        return new IntegracaoFiscalWrapper(integracaoFiscal.isPossuiConsultarTodosProdutos(), integracaoFiscal.isPossuiExportarProdutosInexistentes(), integracaoFiscal.isPossuiConsultarProdutosAtualizados(), integracaoFiscal.isPossuiExportacaoXls());
    }

    @RequestMapping(value={"/atualizar-produtos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void atualizarProdutos(@RequestBody Long idRetornoIntegracaoFiscal, @RequestParam(required=false) List<Long> idsRetornoProduto) throws UnicoMensagemUsuarioException {
        if (!Util.longNullOuZero((Long)idRetornoIntegracaoFiscal)) {
            1 task = new /* Unavailable Anonymous Inner Class!! */;
            task.createTask((Object)new AlteracaoProdutoWrapper(idRetornoIntegracaoFiscal, idsRetornoProduto), null, "", true);
        }
    }

    @RequestMapping(value={"/enviar-produtos-novos"})
    @DBAutoCommit
    public void novosProdutos() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        UnicoIntegracaoFiscal integracaoFiscal = new UnicoIntegracaoFiscal(sessao);
        integracaoFiscal.geraRemessaProdutos(sessao);
    }

    @RequestMapping(value={"/consultar-produtos-atualizados"}, method={RequestMethod.POST})
    @DBAutoCommit
    public RetornoIntegracaoFiscal consultarProdutosAtualizados() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        UnicoIntegracaoFiscal integracaoFiscal = new UnicoIntegracaoFiscal(sessao);
        return integracaoFiscal.consultarProdutosAtualizados(sessao, null);
    }

    @RequestMapping(value={"/consultar-todos-produtos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void consultarTodosProdutos() throws UnicoMensagemUsuarioException {
        2 task = new /* Unavailable Anonymous Inner Class!! */;
        task.createTask((Object)"");
    }

    protected String getCacheId() {
        return "lotes-integracao-fiscal";
    }

    @RequestMapping(value={"/escolher-produtos-integracao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EnvioIntegracaoFiscalProduto> escolherProdutos(@RequestBody FiltroProdutoIntegracaoWrapper filtroProduto) {
        return EnvioIntegracaoFiscalProdutoRN.getInstance().buscaProdutosParaEnvio(SessaoUtil.getSessao(), filtroProduto.getInicio(), filtroProduto.getFim(), filtroProduto.getTipo());
    }

    @RequestMapping(value={"/gravar-remessa-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public RetornoIntegracaoFiscal gravarRemessaProdutos(@RequestBody List<Produto> produtosSelecionados) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (produtosSelecionados.size() <= 10) {
            return new UnicoIntegracaoFiscal(sessao).geraRemessaProdutosJson(sessao, produtosSelecionados, null);
        }
        3 createTask = new /* Unavailable Anonymous Inner Class!! */;
        createTask.createTask((Object)new IntegracaoFiscalJobWrapper(produtosSelecionados));
        this.notificationService.notifyUser(sessao.getIdUsuario(), "Envio de produtos agendado com sucesso. Voc\u00ea ser\u00e1 notificado quando o processo for conclu\u00eddo.", TipoNotificacaoSimples.SUCCESS, NotificationType.SIMPLE_NOTIFICATION);
        return null;
    }

    static /* synthetic */ TaskManager access$000(LotesIntegracaoFiscalCrudController x0) {
        return x0.taskManager;
    }
}

