/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.kit;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Kit;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelCustoKit;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelPrecoKit;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelUnidadeKit;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/kits"})
public class KitCrudController
extends CrudController<Kit, KitRN> {
    public KitCrudController() {
        super((AbstractRegraNegocio)KitRN.getInstance(), Kit::new, true, true);
        this.dependsOn("idprodutokit");
    }

    @RequestMapping(value={"/filtrar-por-produto"})
    @DBAutoCommit
    public List<Kit> buscarListaPorIdProdutoKit(@RequestParam Long idProduto) {
        return KitRN.getInstance().buscarListaPorIdProdutoKit(SessaoUtil.getSessao(), idProduto);
    }

    protected GridBuilder<KitRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("id", "idProduto", "ID Prod. KIT filho", 0, false, new String[]{"fk_kit_produto"}));
        colunas.add(new ColunaSQL("id", "idkitpai", "ID Prod. KIT pai", 0, false, new String[]{"fk_kit_produtokit"}));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimais", "Casas decimais", 0, false, new String[]{"fk_kit_produto", "fk_produto_unidademedida"}));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaispreco", "Casas decimais", 0, false, new String[]{"fk_kit_produto"}));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaisprecopai", "Casas decimais", 0, false, new String[]{"fk_kit_produtokit"}));
        colunas.add(new ColunaSQL("quantidade", "quantidadekit", "quantidadekit", 0, false, new String[0]));
        colunas.add(new ColunaSQL("nome", "nomeprodutofilho", "Descri\u00e7\u00e3o", 0, false, new String[]{"fk_kit_produto"}));
        colunas.add(new ColunaSQL("nome", "nomeprodutopai", "Nome produto pai", 0, false, new String[]{"fk_kit_produtokit"}));
        colunas.add(new ColunaSQL("casasdecimaisprecocusto", "casasdecimaiscusto", "Casas decimais", 0, false, new String[]{"fk_kit_produto"}));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaisquantidade", "Casas decimais", 0, false, new String[]{"fk_kit_produto", "fk_produto_unidademedida"}));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaispreco", "Casas decimais", 0, false, new String[]{"fk_kit_produto"}));
        colunas.add(new ColunaSQL("casasdecimais", "casasdecimaisprecopai", "Casas decimais", 0, false, new String[]{"fk_kit_produtokit"}));
        colunas.add(new ColunaSQL("quantidade", "quantidadekit", "quantidadekit", 0, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "codigoproduto", "Produto", 200, true, new String[]{"fk_kit_produto"}));
        colunas.add(new ColunaSQL("nome", "nomeproduto", "Descri\u00e7\u00e3o", 0, true, new String[]{"fk_kit_produto"}));
        colunas.add(new ColunaSQL("codigo", "unidade", "UN", 200, true, new String[]{"fk_kit_produto", "fk_produto_unidademedida"}));
        colunas.add(new ColunaSQL("quantidade", "Quantidade", 200, true));
        ColunaSQL colunaPrecoFilho = new ColunaSQL("precoprodutofilho", "precoprodutofilho", "Pre\u00e7o", 200, true, new String[0]);
        colunaPrecoFilho.setTipoDadoBase(TipoDadoBase.NUMERIC);
        colunaPrecoFilho.setClasseValor(BigDecimal.class);
        colunaPrecoFilho.setVirtual(true);
        colunas.add(colunaPrecoFilho);
        colunas.add(new ColunaSQL("quantidade", "total", "Total", 200, true, new String[0]));
        GridBuilder grid = new GridBuilder(KitRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idproduto"));
        grid.addReferenciaDefault(new Referencia("idprodutokit"));
        Sessao sessao = SessaoUtil.getSessao();
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPrecoKit(sessao, "precoprodutofilhocalculado", "idProduto"));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPrecoKit(sessao, "precoprodutofilho", "idProduto"));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPrecoKit(sessao, "precoprodutopai", "idkitpai"));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelUnidadeKit(sessao, "unprodutofilho", "fk_kit_produto"));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelUnidadeKit(sessao, "unprodutopai", "fk_kit_produtokit"));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelCustoKit(sessao, "custoprodutofilho", "idProduto"));
        return grid;
    }

    public List<Coluna> getColunasCustomizaveis() {
        return KitRN.getInstance().getColunaGridCustomizaveisWW();
    }

    @RequestMapping(value={"/permitir-cadastrar-kit"})
    @DBAutoCommit
    public void isPermiteCadastro(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        KitRN.getInstance().isPermiteCadastro(SessaoUtil.getSessao(), idProduto);
    }

    @RequestMapping(value={"/texto-total-kit"})
    @DBAutoCommit
    public String getTextoTotalKit(@RequestParam Long idProduto) {
        return KitRN.getInstance().buscarMsgPrecoKit(SessaoUtil.getSessao(), idProduto);
    }

    @RequestMapping(value={"/calcular-quantidade-possivel"})
    @DBAutoCommit
    public String calcularQuantidadePossivel(@RequestParam Long idProduto) throws UnicoMensagemUsuarioException {
        try {
            BigDecimal qtd = KitRN.getInstance().calcularQuantidadePossivel(Contexto.getInstance().getSessao(), idProduto);
            return "\u00c9 poss\u00edvel compor " + Util.formataNumero((BigDecimal)qtd, (String)Util.getMascaraQuantidade((int)qtd.scale())) + " kits com o estoque dispon\u00edvel";
        }
        catch (UnicoMensagemUsuarioException ex) {
            throw new UnicoMensagemUsuarioException("WWW680", ex.getMensagemSemCodigoDeErro().replace(Util.newLine(), "<br>"));
        }
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        int indexTotal = this.getIndexColuna("total", colunas);
        int indexPreco = this.getIndexColuna("precoprodutofilho", colunas);
        if (indexPreco > -1 && indexTotal > -1) {
            int indexQnt = this.getIndexColuna("quantidadekit", colunas);
            dados.forEach(registro -> {
                BigDecimal quantidade = (BigDecimal)registro[indexQnt];
                BigDecimal preco = BigDecimal.ZERO;
                if (registro[indexPreco] != null && registro[indexPreco] instanceof BigDecimal) {
                    preco = (BigDecimal)registro[indexPreco];
                }
                registro[indexTotal] = quantidade.multiply(preco).setScale(2, RoundingMode.HALF_EVEN);
            });
        }
    }

    protected void afterSave(Kit kit, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.alterarPrecoKitPai(kit.getIdprodutokit());
    }

    protected void afterDelete(Kit kit) throws UnicoMensagemUsuarioException {
        this.alterarPrecoKitPai(kit.getIdprodutokit());
    }

    private void alterarPrecoKitPai(Long idKitPai) throws UnicoMensagemUsuarioException {
        if (!FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO)) {
            Sessao sessao = SessaoUtil.getSessao();
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 243) || PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 244)) {
                ProdutoRN.getInstance().alterarPrecoKitPai(sessao, idKitPai);
            }
        }
    }

    protected String getCacheId() {
        return "kits";
    }
}

