/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.localtrabalho;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/change-place-work"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", ROTA="/ferramentas/alterar-local-trabalho", NOME="Alterar local trabalho", PROGRAMA=514, CUSTOM_ACTION=true, VISIBLE=false)
public class AlterarLocalTrabalhoController
extends SimpleController {
    private final CacheService cacheService;
    private final FuncionalidadeService funcionalidadeService;

    public AlterarLocalTrabalhoController(CacheService cacheService, FuncionalidadeService funcionalidadeService) {
        this.cacheService = cacheService;
        this.funcionalidadeService = funcionalidadeService;
    }

    @PostMapping
    @DBTransaction
    public void alterarLocalTrabalho(@RequestParam(required=false) Long idFilial, @RequestParam(required=false) Long idLocalEstoque) throws UnicoMensagemUsuarioException {
        if ((LicencaManager.getInstance().isEnterprise() || LicencaManager.getInstance().isDemonstracao()) && NumberUtil.longNullOuZero((Long)idFilial)) {
            throw new UnicoMensagemUsuarioException("WWW565", "Por favor informe a filial.");
        }
        Sessao sessao = SessaoUtil.getSessao();
        if (NumberUtil.longNullOuZero((Long)idFilial)) {
            idFilial = sessao.getIdFilial();
        }
        Usuario usuario = sessao.getUsuario();
        if (this.funcionalidadeService.isAtiva(Funcionalidade.LOCAL_ESTOQUE)) {
            usuario.setIdLocalEstoqueTrabalho(idLocalEstoque);
            UsuarioRN.getInstance().alterarLocalTrabalho(sessao, idFilial, idLocalEstoque);
        } else {
            UsuarioRN.getInstance().alterarLocalTrabalho(sessao, idFilial);
        }
        this.cacheService.clear();
    }
}

