/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.InputStreamDataSource;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.UnicoByteArrayDataSource;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.manifesto.StatusManifesto;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoDocumento;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.manifesto.MdfeManagerWeb;
import br.intelidata.commons.modulo.manifesto.regranegocio.ManifestoDocumentoRN;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.DataSource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/manifesto-documentos"})
public class ManifestoDocumentoCompartilhamentoController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    public ManifestoDocumentoCompartilhamentoController(TaskManager taskManager) {
        super(taskManager);
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        if (manifestoDocumento == null) {
            throw new UnicoMensagemUsuarioException("WWW520", "N\u00e3o foi selecionada MDF-e para a impress\u00e3o! Verifique.");
        }
        if (!manifestoDocumento.getStatus().in(new AbstractEnum[]{StatusManifesto.AUTORIZADO, StatusManifesto.CANCELADO, StatusManifesto.ENCERRADO})) {
            throw new UnicoMensagemUsuarioException("WWW521", "A MDF-e selecionada deve estar autorizada, cancelada ou encerrada! Verifique.");
        }
        Notificacao notificacao = new Notificacao();
        notificacao.setFone(compartilhamento.getCelular());
        notificacao.setEmail(compartilhamento.getEmail());
        notificacao.setEmailCopia(compartilhamento.getCopiaPara());
        notificacao.setAssunto(compartilhamento.getAssunto());
        String nomeEmpresa = SessaoUtil.getSessao().getFilial().getRazaoSocialCompleta();
        String chave = manifestoDocumento.getChaveAcesso();
        String numero = manifestoDocumento.getNumeroManifesto();
        String modelo = "58";
        String mensagem = compartilhamento.getMensagem();
        mensagem = mensagem.replace("@numeroManifesto", numero);
        mensagem = mensagem.replace("@modelo", modelo);
        mensagem = mensagem.replace("@nomeEmpresa", nomeEmpresa);
        notificacao.setMsg(mensagem);
        Malote malote = new Malote();
        ArrayList<Object> dataSources = new ArrayList<Object>();
        ByteArrayInputStream inputAut = new ByteArrayInputStream(manifestoDocumento.getArquivoXmlAutorizado().getBytes(StandardCharsets.UTF_8));
        InputStreamDataSource dataSourceXmlAutorizada = new InputStreamDataSource(chave + "-procMDFe.xml", "text/xml", (InputStream)inputAut);
        dataSources.add(dataSourceXmlAutorizada);
        malote.inclui(chave + "-procMDFe.xml", manifestoDocumento.getArquivoXmlAutorizado());
        byte[] mdfe = new MdfeManagerWeb(SessaoUtil.getSessao(), null).gerarDamdfe(manifestoDocumento);
        UnicoByteArrayDataSource dataSourcePDF = new UnicoByteArrayDataSource(mdfe, "DAMDFE-" + chave + ".pdf", "application/pdf");
        dataSources.add(dataSourcePDF);
        malote.inclui("DAMDFE-" + chave + ".pdf", mdfe);
        if (!Util.stringNullOrEmpty((String)manifestoDocumento.getArquivoXmlCancelado())) {
            ByteArrayInputStream inputCanc = new ByteArrayInputStream(manifestoDocumento.getArquivoXmlCancelado().getBytes(StandardCharsets.UTF_8));
            InputStreamDataSource dataSourceXmlCancelada = new InputStreamDataSource(chave + "-can.xml", "text/xml", (InputStream)inputCanc);
            dataSources.add(dataSourceXmlCancelada);
            malote.inclui(chave + "-can.xml", manifestoDocumento.getArquivoXmlCancelado());
        }
        if (!Util.stringNullOrEmpty((String)manifestoDocumento.getArquivoXmlEncerrado())) {
            ByteArrayInputStream inputEnc = new ByteArrayInputStream(manifestoDocumento.getArquivoXmlEncerrado().getBytes(StandardCharsets.UTF_8));
            InputStreamDataSource dataSourceXmlEncerrado = new InputStreamDataSource(chave + "-enc.xml", "text/xml", (InputStream)inputEnc);
            dataSources.add(dataSourceXmlEncerrado);
            malote.inclui(chave + "-enc.xml", manifestoDocumento.getArquivoXmlEncerrado());
        }
        notificacao.setMalote(malote);
        notificacao.setDataSources(dataSources.toArray(new DataSource[0]));
        return Collections.singletonList(notificacao);
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId((Long)compartilhamento.getIdsDocumentos().get(0));
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "MDF-e - ".concat(manifestoDocumento.getNumeroManifesto()));
        taskEmail.createTask((Object)parametrosEmail, parametrosEmail.getAssunto());
    }
}

