/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimento;
import br.intelidata.commons.domain.pojo.enuns.manifesto.FormaEmissaoManifesto;
import br.intelidata.commons.domain.pojo.enuns.manifesto.ModalManifesto;
import br.intelidata.commons.domain.pojo.enuns.manifesto.StatusManifesto;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoDocumento;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoNotaFiscal;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoSeguro;
import br.intelidata.commons.domain.regranegocio.ManifestoDocumentoCommonRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.manifesto.regranegocio.ManifestoDocumentoRN;
import br.intelidata.commons.modulo.manifesto.regranegocio.ManifestoSeguroRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento.TransmissaoManifestoDocumentoController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/manifesto-documentos"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="MDF-e de sa\u00edda", ICONE="icon-nota-fiscal-saida", ROTA="/manifesto-documento/manifesto-documentos", PROGRAMA=224)
public class ManifestoDocumentoCrudController
extends TransmissaoManifestoDocumentoController {
    protected GridBuilder<ManifestoDocumentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("numeromanifesto", "N\u00famero", 90, true));
        colunas.add(new ColunaSQL("codigo", "modelo", "Modelo", 90, true, new String[]{"fk_manif_modelo"}));
        colunas.add(new ColunaSQL("serie", "serie", "S\u00e9rie", 80, true, new String[]{"fk_manif_modelo"}));
        colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 120, true));
        colunas.add(new ColunaSQL("valortotalmercadoria", "Total da mercadoria", 160, true));
        colunas.add(new ColunaSQL("status", "Status", 150, true));
        colunas.add(new ColunaSQL("descricaosituacao", "Situa\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("chaveacesso", "Chave de acesso", 0, true));
        GridBuilder grid = new GridBuilder(ManifestoDocumentoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.addOrdemDefault(new Ordem("emissao", true));
        grid.addOrdemDefault(new Ordem("numeromanifesto"));
        grid.addOrdemDefault(new Ordem("modelo"));
        grid.addOrdemDefault(new Ordem("serie"));
        return grid;
    }

    protected String getCacheId() {
        return "manifesto-documentos".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected void beforeSave(ManifestoDocumento manifestoDocumento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave((AbstractPojo)manifestoDocumento, parentId);
        if (Util.longNullOuZero((Long)manifestoDocumento.getId())) {
            manifestoDocumento.setIdFilial(SessaoUtil.getSessao().getIdFilial());
            manifestoDocumento.setModal(ModalManifesto.RODOVIARIO);
            manifestoDocumento.setStatus(StatusManifesto.NORMAL);
            manifestoDocumento.setFormaEmissao(FormaEmissaoManifesto.NORMAL);
            manifestoDocumento.setTipoMovimento(TipoMovimento.SAIDA);
        } else {
            manifestoDocumento.setAlteradoPorTransacao(true);
        }
        ArrayList notas = new ArrayList();
        if (!Util.listNullOrEmpty((List)manifestoDocumento.getNfes())) {
            notas.addAll(manifestoDocumento.getNfes());
        }
        if (!Util.listNullOrEmpty((List)manifestoDocumento.getNfesTerceiro())) {
            notas.addAll(manifestoDocumento.getNfesTerceiro());
        }
        manifestoDocumento.setNfes(notas);
        ArrayList conhecimentos = new ArrayList();
        if (!Util.listNullOrEmpty((List)manifestoDocumento.getConhecimentos())) {
            conhecimentos.addAll(manifestoDocumento.getConhecimentos());
        }
        if (!Util.listNullOrEmpty((List)manifestoDocumento.getConhecimentosTerceiro())) {
            conhecimentos.addAll(manifestoDocumento.getConhecimentosTerceiro());
        }
        manifestoDocumento.setConhecimentos(conhecimentos);
    }

    protected void beforeRead(ManifestoDocumento manifestoDocumento, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (manifestoDocumento != null) {
            if (!Util.listNullOrEmpty((List)manifestoDocumento.getNfes())) {
                ArrayList nfesTerceiro = new ArrayList();
                manifestoDocumento.getNfes().removeIf(manifestoNotaFiscal -> {
                    if (Util.longNullOuZero((Long)manifestoNotaFiscal.getIdNotaFiscal())) {
                        nfesTerceiro.add(manifestoNotaFiscal);
                        return true;
                    }
                    return false;
                });
                manifestoDocumento.setNfesTerceiro(nfesTerceiro);
            }
            if (!Util.listNullOrEmpty((List)manifestoDocumento.getConhecimentos())) {
                ArrayList conhecimentosTerceiro = new ArrayList();
                manifestoDocumento.getConhecimentos().removeIf(manifestoConhecimento -> {
                    if (Util.longNullOuZero((Long)manifestoConhecimento.getIdConhecimento())) {
                        conhecimentosTerceiro.add(manifestoConhecimento);
                        return true;
                    }
                    return false;
                });
                manifestoDocumento.setConhecimentosTerceiro(conhecimentosTerceiro);
            }
        }
    }

    @RequestMapping(value={"/calcular-pesovalor-total-nf-terceiro"}, method={RequestMethod.POST})
    @DBAutoCommit
    public Map<String, BigDecimal> calcularPesoValorNotaTerceiros(@RequestBody List<String> chavesNfe) {
        HashMap<String, BigDecimal> valores = new HashMap<String, BigDecimal>();
        if (!ListMapUtil.listNullOrEmpty(chavesNfe)) {
            BigDecimal pesoTotal = BigDecimal.ZERO;
            BigDecimal valorTotal = BigDecimal.ZERO;
            for (String chave : chavesNfe) {
                Long idNota = NotaFiscalRN.getInstance().buscarIdPorChaveNfeEmissaoPropria(chave);
                if (Util.longNullOuZero((Long)idNota)) {
                    idNota = NotaFiscalRN.getInstance().buscarIdPorChaveNfeTerceiros(chave);
                }
                if (Util.longNullOuZero((Long)idNota)) continue;
                Map dadosNota = NotaFiscalRN.getInstance().buscarValoresPorID(idNota, new String[]{"pesobruto", "valortotalnota"});
                pesoTotal = pesoTotal.add(dadosNota.getOrDefault("pesobruto", BigDecimal.ZERO));
                valorTotal = valorTotal.add(dadosNota.getOrDefault("valortotalnota", BigDecimal.ZERO));
            }
            valores.put("peso", pesoTotal);
            valores.put("valor", valorTotal);
        }
        return valores;
    }

    @RequestMapping(value={"/importar-xml-terceiros"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public ManifestoDocumento importarXmlTerceiros(@RequestPart MultipartFile[] files) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            throw new UnicoMensagemUsuarioException("MTRP91", "Informe ao menos um XML de terceiros para importar para MDF-e");
        }
        ArrayList<String> xmls = new ArrayList<String>();
        try {
            for (MultipartFile file : files) {
                xmls.add(FileUtil.byteArrayToString((byte[])file.getBytes()));
            }
        }
        catch (Throwable ex) {
            throw new UnicoMensagemUsuarioException("MTRP92", "N\u00e3o foi poss\u00edvel importar o(s) XML(s) de terceiros", ex);
        }
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoCommonRN.getInstance().gerarManifestoComXML(xmls, true);
        if (!Util.listNullOrEmpty((List)manifestoDocumento.getNfes())) {
            ArrayList<ManifestoNotaFiscal> listaNF = new ArrayList<ManifestoNotaFiscal>();
            ArrayList<ManifestoNotaFiscal> listaNFTerceiro = new ArrayList<ManifestoNotaFiscal>();
            for (ManifestoNotaFiscal nota : manifestoDocumento.getNfes()) {
                if (!Util.longNullOuZero((Long)nota.getIdNotaFiscal())) {
                    listaNF.add(nota);
                    continue;
                }
                listaNFTerceiro.add(nota);
            }
            manifestoDocumento.setNfes(listaNF);
            manifestoDocumento.setNfesTerceiro(listaNFTerceiro);
        }
        return manifestoDocumento;
    }

    @RequestMapping(value={"/email-seguradora"})
    @DBAutoCommit
    public String emailsSeguradora(@RequestParam Long idMdfe) {
        List seguros = ManifestoSeguroRN.getInstance().buscarListaPorIdManifesto(idMdfe);
        return EntidadeRN.getInstance().buscarEmailsDeSeguradoras(seguros.stream().map(ManifestoSeguro::getIdSeguradora).collect(Collectors.toList()));
    }
}

