/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.commons.domain.pojo.manifesto.ManifestoDocumento;
import br.intelidata.commons.modulo.manifesto.MdfeManagerWeb;
import br.intelidata.commons.modulo.manifesto.regranegocio.ManifestoDocumentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento.JobTransmissaoMdfe;
import br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento.ManifestoDocumentoTransmissaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento.TransmissaoManifestoDocumentoController;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/jobs-mdfe"})
public class ManifestoDocumentoTaskJobController
extends TransmissaoManifestoDocumentoController
implements ICreateTask {
    private final TaskManager taskManager;

    public ManifestoDocumentoTaskJobController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.TRANSMISSAO_MDFE;
    }

    public Class<? extends AbstractJob> job() {
        return JobTransmissaoMdfe.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public TypeQueue getQueue() {
        return TypeQueue.RECURRING_QUEUE;
    }

    @RequestMapping(value={"/gerar-damdfe"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarDamdfe(@RequestBody Long idMdfe) throws UnicoMensagemUsuarioException {
        ManifestoDocumento manifestoDocumento = ManifestoDocumentoRN.getInstance().buscarPorId(idMdfe);
        if (manifestoDocumento == null) {
            throw new UnicoMensagemUsuarioException("WWW518", "N\u00e3o foi selecionada MDF-e para a impress\u00e3o! Verifique.");
        }
        if (!manifestoDocumento.getStatus().isPermiteImprimir()) {
            throw new UnicoMensagemUsuarioException("WWW519", "N\u00e3o \u00e9 poss\u00edvel imprimir MDF-e com status " + manifestoDocumento.getStatus().getDescricao() + "! Verifique.");
        }
        return this.responseEntityService.createPDFResponse(new MdfeManagerWeb(SessaoUtil.getSessao(), null).gerarDamdfe(manifestoDocumento), "DAMDFE-".concat(manifestoDocumento.getChaveAcesso()));
    }

    @RequestMapping(value={"/agendar-transmissao"}, method={RequestMethod.POST})
    @DBTransaction
    public void agendarMdfes(@RequestBody ManifestoDocumentoTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.verificarValidadeCertificado(new MdfeManagerWeb(SessaoUtil.getSessao(), null));
        String detalhe = "Transmiss\u00e3o da MDF-e " + ManifestoDocumentoRN.getInstance().buscarValoresPorID(wrapper.getId(), new String[]{"numeromanifesto"}).get("numeroManifesto") + ".";
        this.createTask((Object)wrapper, detalhe);
    }

    protected String getCacheId() {
        return null;
    }

    protected GridBuilder<?> getGridBuilder() {
        return null;
    }
}

