/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.manifestodocumento;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.manifesto.SerieManifestoDocumento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.manifesto.regranegocio.ManifestoDocumentoRN;
import br.intelidata.commons.modulo.manifesto.regranegocio.SerieManifestoDocumentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/serie-manifesto-documento"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="S\u00e9ries de MDF-e", ROTA="/manifesto-documento/serie-manifesto-documento", PROGRAMA=1000021)
public class SerieManifestoDocumentoCrudController
extends CrudController<SerieManifestoDocumento, SerieManifestoDocumentoRN> {
    public SerieManifestoDocumentoCrudController() {
        super((AbstractRegraNegocio)SerieManifestoDocumentoRN.getInstance(), SerieManifestoDocumento::new, true, true);
    }

    protected GridBuilder<SerieManifestoDocumentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "Modelo", 100, true));
        colunas.add(new ColunaSQL("serie", "S\u00e9rie", 0, true));
        colunas.add(new ColunaSQL("proximonumero", "Pr\u00f3ximo n\u00famero", 0, true));
        GridBuilder grid = new GridBuilder(SerieManifestoDocumentoRN.getInstance().getTabela(), colunas);
        Sessao sessao = SessaoUtil.getSessao();
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, sessao.getIdFilial()));
        return grid;
    }

    @RequestMapping(value={"/combo"})
    @DBAutoCommit
    public List<SerieManifestoDocumento> getCombo() {
        return SerieManifestoDocumentoRN.getInstance().getComboWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/proximo-numero-mdfe"})
    @DBAutoCommit
    public String getProximoNumeroMDFE(@RequestParam Long idModelo) {
        return ManifestoDocumentoRN.getInstance().getProximoNumero(SessaoUtil.getSessao(), idModelo);
    }

    protected String getCacheId() {
        return "serie-manifesto-documento";
    }
}

