/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.marca;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.Marca;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.MarcaRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/marcas"})
@SubMenuMapping(MENU="SubMenuEstoqueAuxiliar", NOME="Marcas", ROTA="/estoques/marcas", PROGRAMA=1000076)
public class MarcaCrudController
extends CrudController<Marca, MarcaRN> {
    public MarcaCrudController() {
        super((AbstractRegraNegocio)MarcaRN.getInstance(), Marca::new, TipoArquivoArmazenado.MARCA);
    }

    protected String getCacheId() {
        return "marcas";
    }

    protected GridBuilder<MarcaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idFabricante", "ID fabricante", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        return new GridBuilder(((MarcaRN)this.rn).getTabela(), colunas);
    }

    @RequestMapping(value={"/por-id-fabricante"})
    @DBTransaction
    public List<Marca> carrgarPorIdFabricante(@RequestParam Long idFabricante) {
        return MarcaRN.getInstance().buscarPorIdFabricante(idFabricante);
    }

    protected void beforeRead(Marca marca, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)marca.getCaminhoImagem())) {
            marca.setCaminhoImagem(this.saveFile.publishImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), TipoImagem.Pequena, marca.getCaminhoImagem()));
        }
    }

    protected void beforeUpdate(Marca marca, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String caminhoOriginal = MarcaRN.getInstance().getCaminhoImagemWeb(marca.getId());
        if (!StringUtil.stringNullOrEmpty((String)caminhoOriginal)) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), TipoImagem.Pequena, caminhoOriginal);
            if (StringUtil.stringNullOrEmpty((String)marca.getCaminhoImagem()) || !marca.getCaminhoImagem().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), caminhoOriginal);
            } else {
                marca.setCaminhoImagem(caminhoOriginal);
            }
        }
    }
}

