/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.notafiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.ImpressaoDocumentoConfigurado;
import br.intelidata.commons.core.impressao.TipoImpressao;
import br.intelidata.commons.core.impressao.TipoModelo;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscal;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscalFactory;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ModeloImpressoraNaoFiscal;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Layout;
import br.intelidata.commons.domain.pojo.ModeloImpressaoCabecalho;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoIReportRN;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoRN;
import br.intelidata.commons.domain.regranegocio.NotaFiscalCommonRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.ImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.ModeloImpressaoCrudController;
import java.util.Base64;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.nfce.ImpressaoDanfePDF;

@RestController
@RequestMapping(value={"/api/modelos-nota-fiscal"})
public class ModeloImpressaoNotaFiscalCrudController
extends ModeloImpressaoCrudController {
    public ModeloImpressaoNotaFiscalCrudController() {
        super(TipoModelo.NOTAFISCAL);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @DBAutoCommit
    public ModeloImpressaoCabecalho read(@PathVariable Long id, @PathVariable Optional<Long> parentId, @RequestParam(required=false, defaultValue="0") int modo, @RequestParam(required=false) MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        Layout layout = ModeloImpressaoRN.getInstance().carregaModelo(SessaoUtil.getSessao(), TipoModelo.NOTAFISCAL, id);
        layout.setIdSerie(id);
        if (!StringUtil.stringNullOrEmpty((String)layout.getCaminhoLogo())) {
            layout.setCaminhoLogo(this.saveFile.publishArquivo(layout.getCaminhoLogo()));
        }
        if (!StringUtil.stringNullOrEmpty((String)layout.getCaminhoLogo2())) {
            layout.setCaminhoLogo2(this.saveFile.publishArquivo(layout.getCaminhoLogo2()));
        }
        ModeloImpressaoCabecalho modelo = new ModeloImpressaoCabecalho();
        modelo.setLayout(layout);
        modelo.setIdSerie(id);
        modelo.setId(id);
        if (TipoImpressao.IREPORT_CONFIGURADO.equals((Object)layout.getTipoImpressao())) {
            modelo.setModelosImpressaoIReport(ModeloImpressaoIReportRN.getInstance().buscarRelatoriosPorIdSerie(id));
        }
        return modelo;
    }

    @DBTransaction
    public Long update(@RequestBody ModeloImpressaoCabecalho entity, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Layout layout = entity.getLayout();
        layout.setIdSerie(entity.getIdSerie());
        if (!StringUtil.stringNullOrEmpty((String)layout.getCaminhoLogo())) {
            layout.setCaminhoLogo(layout.getCaminhoLogo().replace(this.saveFile.getServidorURL(), ""));
        }
        if (!StringUtil.stringNullOrEmpty((String)layout.getCaminhoLogo2())) {
            layout.setCaminhoLogo2(layout.getCaminhoLogo2().replace(this.saveFile.getServidorURL(), ""));
        }
        ModeloImpressaoRN.getInstance().salvaModelo(SessaoUtil.getSessao(), layout, null);
        if (TipoImpressao.IREPORT_CONFIGURADO.equals((Object)layout.getTipoImpressao())) {
            Sessao sessao = SessaoUtil.getSessao();
            ModeloImpressaoIReportRN.getInstance().excluirPorIdSerie(sessao, entity.getIdSerie());
            entity.getModelosImpressaoIReport().forEach(modeloImpressaoIReport -> modeloImpressaoIReport.setIdSerie(entity.getIdSerie()));
            ModeloImpressaoIReportRN.getInstance().gravarLista(sessao, null, entity.getModelosImpressaoIReport());
        }
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        return layout.getIdSerie();
    }

    @RequestMapping(value={"/modelo"})
    @DBTransaction
    public TipoImpressao carregarModeloImpressaoNotaFiscal(@RequestParam Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalCommonRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WWW495", "Nota fiscal n\u00e3o encontrada para impress\u00e3o");
        }
        if (notaFiscal.getSerie().equalsIgnoreCase("55")) {
            throw new UnicoMensagemUsuarioException("WNTF697", "Nota fiscal \u00e9 uma NF-e e n\u00e3o pode ser impressa atrav\u00e9s de modelo.");
        }
        if (!NotaFiscalRN.getInstance().isNotaEmitida(notaFiscal.getId())) {
            throw new UnicoMensagemUsuarioException("WNTF698", "Nota fiscal n\u00e3o \u00e9 uma emiss\u00e3o pr\u00f3pria");
        }
        return ModeloImpressaoRN.getInstance().carregaModelo(SessaoUtil.getSessao(), TipoModelo.NOTAFISCAL, notaFiscal.getIdSerie()).getTipoImpressao();
    }

    @DBAutoCommit
    public String impressaoNaoFiscal(@RequestBody ImpressaoWrapper impressaoWrapper) throws UnicoMensagemUsuarioException {
        byte[] impressao;
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(((Long[])impressaoWrapper.getId())[0]);
        boolean isImpressoraNaoFiscal = impressaoWrapper.getModeloNaoFiscal() != null;
        ImpressoraNaoFiscal inf = null;
        if (isImpressoraNaoFiscal) {
            inf = ImpressoraNaoFiscalFactory.getImpressora((ModeloImpressoraNaoFiscal)impressaoWrapper.getModeloNaoFiscal());
            inf.setNaoCriarPrintService(true);
            inf.setRemoveAcentos(impressaoWrapper.isRemoveAcento());
            inf.inicializa("", impressaoWrapper.getLinhas(), impressaoWrapper.getPagina(), true);
            inf.setCabecalho(ImpressaoDanfePDF.getCabecalhoPadrao((Filial)SessaoUtil.getSessao().getFilial()));
        }
        Remessa remessa = this.imprimir(notaFiscal.getIdSerie(), notaFiscal.getId(), inf);
        if (isImpressoraNaoFiscal) {
            inf.acionaGuilhotinha();
            impressao = inf.getBytesImpressao();
        } else {
            impressao = remessa.getMalote().extrai("matricial");
        }
        return Base64.getEncoder().encodeToString(impressao);
    }

    @RequestMapping(value={"/imprimir-nota-fiscal"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> imprimirNotaFiscal(@RequestBody Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalCommonRN.getInstance().buscarPorId(idNotaFiscal);
        Remessa remessa = this.imprimir(notaFiscal.getIdSerie(), idNotaFiscal, null);
        notaFiscal.setImpresso(true);
        NotaFiscalCommonRN.getInstance().alterar(notaFiscal, SessaoUtil.getSessao());
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)("Nota fiscal " + notaFiscal.getNumeroNotaFiscal()));
    }

    private Remessa imprimir(Long idSerie, Long idNotaFiscal, ImpressoraNaoFiscal inf) throws UnicoMensagemUsuarioException {
        ImpressaoDocumentoConfigurado impressaoDocumentoConfigurado = TipoModelo.NOTAFISCAL.getImpressaoDocumentoConfigurado(SessaoUtil.getSessao());
        if (inf != null) {
            impressaoDocumentoConfigurado.setImpressoraNaoFiscal(inf);
        }
        impressaoDocumentoConfigurado.setTrataImagemWeb((TrataImagemWeb)this);
        return impressaoDocumentoConfigurado.imprimir(null, idSerie, TipoModelo.NOTAFISCAL, null, null, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{idNotaFiscal});
    }
}

