/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.motivosangriasuprimento;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentoPlanoContas;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoSangriaSuprimento;
import br.intelidata.commons.domain.pojo.pafecf.MotivoSangriaSuprimento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.pdv.regranegocio.MotivoSangriaSuprimentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/motivos-sangria-suprimento"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Motivos de sangria e suprimento", ROTA="/pdvs/motivos-sangria-suprimento", PROGRAMA=64, ICONE="icon icon-date")
public class MotivoSangriaSuprimentoCrudController
extends CrudController<MotivoSangriaSuprimento, MotivoSangriaSuprimentoRN> {
    public MotivoSangriaSuprimentoCrudController() {
        super((AbstractRegraNegocio)MotivoSangriaSuprimentoRN.getInstance(), MotivoSangriaSuprimento::new);
    }

    protected GridBuilder<MotivoSangriaSuprimentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("sangria", "Tipo", 0, true));
        return new GridBuilder(MotivoSangriaSuprimentoRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "motivos-sangria-suprimento";
    }

    protected void beforeSave(MotivoSangriaSuprimento motivoSangriaSuprimento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!Util.longNullOuZero((Long)motivoSangriaSuprimento.getIdPlanoContas())) {
            HierarquiaPlanoContas planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(motivoSangriaSuprimento.getIdPlanoContas());
            if (motivoSangriaSuprimento.getSangria() == TipoSangriaSuprimento.SANGRIA && planoContas.getTipoMovimento() == TipoMovimentoPlanoContas.SAIDA) {
                throw new UnicoMensagemUsuarioException("WPDV530", "Para motivo de sangria informar um plano de conta de entrada");
            }
            if (motivoSangriaSuprimento.getSangria() == TipoSangriaSuprimento.SUPRIMENTO && planoContas.getTipoMovimento() == TipoMovimentoPlanoContas.ENTRADA) {
                throw new UnicoMensagemUsuarioException("WPDV531", "Para motivo de suprimento informar um plano de conta de saida");
            }
        }
        super.beforeSave((AbstractPojo)motivoSangriaSuprimento, parentId);
    }

    @RequestMapping(value={"buscar-por-tipo"}, method={RequestMethod.GET})
    @DBAutoCommit
    public List<MotivoSangriaSuprimento> buscarPorTipo(@RequestParam TipoSangriaSuprimento tipo) {
        return MotivoSangriaSuprimentoRN.getInstance().buscarListaPorTipo(tipo);
    }
}

