/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.naturezaoperacao.cfopestado;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.domain.pojo.CfopEstado;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.CstSNICMS;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.CfopEstadoCommonRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CfopEstadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cfops-estado"})
public class CfopEstadoCrudController
extends CrudController<CfopEstado, CfopEstadoRN> {
    public CfopEstadoCrudController() {
        super((AbstractRegraNegocio)CfopEstadoRN.getInstance(), CfopEstado::new);
    }

    @RequestMapping(value={"/buscar"})
    @DBAutoCommit
    public List<CfopEstado> buscarLista(@RequestParam Long idNaturezaOperacao) {
        List cfopEstados = CfopEstadoCommonRN.getInstance().buscarPorIdNaturezaOperacao(idNaturezaOperacao);
        for (CfopEstado estado : cfopEstados) {
            CstSNICMS cst;
            if (SessaoUtil.getSessao().getFilial().isSimplesNacional()) {
                cst = (CstSNICMS)EnumUtils.getPorId(CstSNICMS.class, (Object)estado.getSt());
                if (cst == null) continue;
                estado.setSt(cst.name());
                continue;
            }
            cst = (CstICMS)EnumUtils.getPorId(CstICMS.class, (Object)estado.getSt());
            if (cst == null) continue;
            estado.setSt(cst.name());
        }
        return cfopEstados;
    }

    protected GridBuilder<CfopEstadoRN> getGridBuilder() {
        return new GridBuilder(CfopEstadoRN.getInstance().getTabela(), Collections.emptyList());
    }

    protected String getCacheId() {
        return "cfops-estado";
    }
}

